/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp;

import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.OBDPRuntimeException;
import id.onyx.obdp.server.agent.stomp.AgentHostDataHolder;
import id.onyx.obdp.server.agent.stomp.dto.AlertCluster;
import id.onyx.obdp.server.events.AlertDefinitionEventType;
import id.onyx.obdp.server.events.AlertDefinitionsAgentUpdateEvent;
import id.onyx.obdp.server.events.HostsAddedEvent;
import id.onyx.obdp.server.events.HostsRemovedEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.orm.dao.AlertDefinitionDAO;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import id.onyx.obdp.server.state.alert.AlertDefinitionFactory;
import id.onyx.obdp.server.state.alert.AlertDefinitionHash;
import id.onyx.obdp.server.state.alert.AlertHelper;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AlertDefinitionsHolder
extends AgentHostDataHolder<AlertDefinitionsAgentUpdateEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(AlertDefinitionsHolder.class);
    @Inject
    private Provider<AlertDefinitionHash> helper;
    @Inject
    private Provider<Clusters> clusters;
    @Inject
    private AlertDefinitionDAO alertDefinitionDAO;
    @Inject
    private AlertHelper alertHelper;
    @Inject
    private AlertDefinitionFactory alertDefinitionFactory;

    @Inject
    public AlertDefinitionsHolder(OBDPEventPublisher eventPublisher) {
        eventPublisher.register(this);
    }

    @Override
    protected AlertDefinitionsAgentUpdateEvent getCurrentData(Long hostId) throws OBDPException {
        TreeMap<Long, AlertCluster> result = new TreeMap<Long, AlertCluster>();
        Map<Long, Map<Long, AlertDefinition>> alertDefinitions = ((AlertDefinitionHash)this.helper.get()).getAlertDefinitions(hostId);
        String hostName = ((Clusters)this.clusters.get()).getHostById(hostId).getHostName();
        long count = 0L;
        for (Map.Entry<Long, Map<Long, AlertDefinition>> e : alertDefinitions.entrySet()) {
            Long clusterId = e.getKey();
            Map<Long, AlertDefinition> definitionMap = e.getValue();
            AlertDefinitionEntity ambariStaleAlert = this.alertDefinitionDAO.findByName(clusterId, "ambari_server_stale_alerts");
            Integer staleIntervalMultiplier = this.alertHelper.getWaitFactorMultiplier(this.alertDefinitionFactory.coerce(ambariStaleAlert));
            result.put(clusterId, new AlertCluster(definitionMap, hostName, staleIntervalMultiplier));
            count += (long)definitionMap.size();
        }
        LOG.info("Loaded {} alert definitions for {} clusters for host {}", new Object[]{count, result.size(), hostName});
        return new AlertDefinitionsAgentUpdateEvent(AlertDefinitionEventType.CREATE, result, hostName, hostId);
    }

    public AlertDefinitionsAgentUpdateEvent getDeleteCluster(Long clusterId, Long hostId) throws OBDPException {
        TreeMap<Long, AlertCluster> result = new TreeMap<Long, AlertCluster>();
        result.put(clusterId, AlertCluster.emptyAlertCluster());
        return new AlertDefinitionsAgentUpdateEvent(AlertDefinitionEventType.DELETE, result, null, hostId);
    }

    @Override
    protected AlertDefinitionsAgentUpdateEvent getEmptyData() {
        return AlertDefinitionsAgentUpdateEvent.emptyEvent();
    }

    @Override
    protected AlertDefinitionsAgentUpdateEvent handleUpdate(AlertDefinitionsAgentUpdateEvent current, AlertDefinitionsAgentUpdateEvent update) throws OBDPException {
        Map<Long, AlertCluster> updateClusters = update.getClusters();
        if (updateClusters.isEmpty()) {
            return null;
        }
        AlertDefinitionsAgentUpdateEvent result = null;
        Long hostId = update.getHostId();
        boolean changed = false;
        Map<Long, AlertCluster> existingClusters = current.getClusters();
        HashMap<Long, AlertCluster> mergedClusters = new HashMap<Long, AlertCluster>();
        switch (update.getEventType()) {
            case UPDATE: 
            case DELETE: {
                Long clusterId;
                if (!existingClusters.keySet().containsAll(updateClusters.keySet())) {
                    LOG.info("Unknown clusters in update, perhaps cluster was removed previously");
                }
                for (Map.Entry<Long, AlertCluster> e : existingClusters.entrySet()) {
                    clusterId = e.getKey();
                    if (updateClusters.containsKey(clusterId)) continue;
                    mergedClusters.put(clusterId, e.getValue());
                }
                for (Map.Entry<Long, AlertCluster> e : updateClusters.entrySet()) {
                    clusterId = e.getKey();
                    if (existingClusters.containsKey(clusterId)) {
                        if (update.getEventType().equals((Object)AlertDefinitionEventType.DELETE) && CollectionUtils.isEmpty(e.getValue().getAlertDefinitions())) {
                            changed = true;
                            continue;
                        }
                        AlertCluster mergedCluster = existingClusters.get(e.getKey()).handleUpdate(update.getEventType(), e.getValue());
                        if (mergedCluster == null) continue;
                        mergedClusters.put(clusterId, mergedCluster);
                        changed = true;
                        continue;
                    }
                    mergedClusters.put(clusterId, e.getValue());
                    changed = true;
                }
                LOG.debug("Handled {} of alerts for {} cluster(s) on host with id {}, changed = {}", new Object[]{update.getEventType(), updateClusters.size(), hostId, changed});
                break;
            }
            case CREATE: {
                if (!Sets.intersection(existingClusters.keySet(), updateClusters.keySet()).isEmpty()) {
                    throw new OBDPException("Existing clusters in create");
                }
                mergedClusters.putAll(existingClusters);
                mergedClusters.putAll(updateClusters);
                LOG.debug("Handled {} of alerts for {} cluster(s)", (Object)update.getEventType(), (Object)updateClusters.size());
                changed = true;
                break;
            }
            default: {
                LOG.warn("Unhandled event type {}", (Object)update.getEventType());
            }
        }
        if (changed) {
            result = new AlertDefinitionsAgentUpdateEvent(AlertDefinitionEventType.CREATE, mergedClusters, current.getHostName(), hostId);
        }
        return result;
    }

    @Subscribe
    public void onHostToClusterAssign(HostsAddedEvent hostsAddedEvent) throws OBDPException {
        Long clusterId = hostsAddedEvent.getClusterId();
        for (String hostName : hostsAddedEvent.getHostNames()) {
            Long hostId = ((Clusters)this.clusters.get()).getHost(hostName).getHostId();
            Map<Long, AlertCluster> existingClusters = ((AlertDefinitionsAgentUpdateEvent)this.getData(hostId)).getClusters();
            if (existingClusters.containsKey(clusterId)) continue;
            existingClusters.put(clusterId, new AlertCluster(new HashMap<Long, AlertDefinition>(), hostName));
        }
    }

    @Subscribe
    public void onHostsRemoved(HostsRemovedEvent event) {
        for (Long hostId : event.getHostIds()) {
            this.onHostRemoved(hostId);
        }
    }

    private void safelyUpdateData(AlertDefinitionsAgentUpdateEvent event) throws OBDPException {
        try {
            this.updateData(event);
        }
        catch (OBDPRuntimeException e) {
            LOG.warn(String.format("Failed to %s alert definitions for host %s", new Object[]{event.getEventType(), event.getHostName()}), (Throwable)e);
        }
    }

    private void safelyResetData(Long hostId) {
        try {
            this.resetData(hostId);
        }
        catch (OBDPException e) {
            LOG.warn(String.format("Failed to reset alert definitions for host with id %s", hostId), (Throwable)e);
        }
    }

    public void provideAlertDefinitionAgentUpdateEvent(AlertDefinitionEventType eventType, Long clusterId, Map<Long, AlertDefinition> alertDefinitions, String hostName) throws OBDPException {
        Long hostId = ((Clusters)this.clusters.get()).getHost(hostName).getHostId();
        Map<Long, AlertCluster> update = Collections.singletonMap(clusterId, new AlertCluster(alertDefinitions, hostName));
        AlertDefinitionsAgentUpdateEvent event = new AlertDefinitionsAgentUpdateEvent(eventType, update, hostName, hostId);
        this.safelyUpdateData(event);
    }

    public void provideStaleAlertDefinitionUpdateEvent(AlertDefinitionEventType eventType, Long clusterId, Integer staleIntervalMultiplier, String hostName) throws OBDPException {
        Long hostId = ((Clusters)this.clusters.get()).getHost(hostName).getHostId();
        Map<Long, AlertCluster> update = Collections.singletonMap(clusterId, new AlertCluster(Collections.emptyMap(), hostName, staleIntervalMultiplier));
        AlertDefinitionsAgentUpdateEvent event = new AlertDefinitionsAgentUpdateEvent(eventType, update, hostName, hostId);
        this.safelyUpdateData(event);
    }
}

