/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Injector;
import id.onyx.obdp.server.configuration.Configuration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentsRegistrationQueue {
    private static final Logger LOG = LoggerFactory.getLogger(AgentsRegistrationQueue.class);
    private final BlockingQueue<String> registrationQueue;
    private final ThreadFactory threadFactoryExecutor = new ThreadFactoryBuilder().setNameFormat("agents-queue-%d").build();
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, this.threadFactoryExecutor);

    public AgentsRegistrationQueue(Injector injector) {
        Configuration configuration = (Configuration)injector.getInstance(Configuration.class);
        this.registrationQueue = new LinkedBlockingQueue<String>(configuration.getAgentsRegistrationQueueSize());
    }

    public boolean offer(String sessionId) {
        boolean offered = this.registrationQueue.offer(sessionId);
        this.scheduledExecutorService.schedule(new CompleteJob(sessionId, this.registrationQueue), 60L, TimeUnit.SECONDS);
        return offered;
    }

    public void complete(String sessionId) {
        this.registrationQueue.remove(sessionId);
    }

    private class CompleteJob
    implements Runnable {
        private String sessionId;
        private BlockingQueue<String> registrationQueue;

        public CompleteJob(String sessionId, BlockingQueue<String> registrationQueue) {
            this.sessionId = sessionId;
            this.registrationQueue = registrationQueue;
        }

        @Override
        public void run() {
            this.registrationQueue.remove(this.sessionId);
        }
    }
}

