/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp;

import com.google.inject.Injector;
import id.onyx.obdp.server.HostNotRegisteredException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.AgentReportsProcessor;
import id.onyx.obdp.server.agent.AgentSessionManager;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.agent.CommandStatusAgentReport;
import id.onyx.obdp.server.agent.ComponentStatus;
import id.onyx.obdp.server.agent.ComponentStatusAgentReport;
import id.onyx.obdp.server.agent.ComponentVersionAgentReport;
import id.onyx.obdp.server.agent.HeartBeatHandler;
import id.onyx.obdp.server.agent.HostStatusAgentReport;
import id.onyx.obdp.server.agent.stomp.ReportsResponse;
import id.onyx.obdp.server.agent.stomp.dto.AckReport;
import id.onyx.obdp.server.agent.stomp.dto.CommandStatusReports;
import id.onyx.obdp.server.agent.stomp.dto.ComponentStatusReport;
import id.onyx.obdp.server.agent.stomp.dto.ComponentStatusReports;
import id.onyx.obdp.server.agent.stomp.dto.ComponentVersionReports;
import id.onyx.obdp.server.agent.stomp.dto.HostStatusReport;
import id.onyx.obdp.server.events.DefaultMessageEmitter;
import id.onyx.obdp.server.state.Alert;
import id.onyx.obdp.server.state.fsm.InvalidStateTransitionException;
import jakarta.inject.Provider;
import jakarta.ws.rs.WebApplicationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.stereotype.Controller;

@Controller
@SendToUser(value={"/"})
@MessageMapping(value={"/reports"})
public class AgentReportsController {
    private static final Logger LOG = LoggerFactory.getLogger(AgentReportsController.class);
    @Autowired
    private Provider<DefaultMessageEmitter> defaultMessageEmitterProvider;
    private final HeartBeatHandler hh;
    private final AgentSessionManager agentSessionManager;
    private final AgentReportsProcessor agentReportsProcessor;

    public AgentReportsController(Injector injector) {
        this.hh = (HeartBeatHandler)injector.getInstance(HeartBeatHandler.class);
        this.agentSessionManager = (AgentSessionManager)injector.getInstance(AgentSessionManager.class);
        this.agentReportsProcessor = (AgentReportsProcessor)injector.getInstance(AgentReportsProcessor.class);
    }

    @MessageMapping(value={"/component_version"})
    public ReportsResponse handleComponentVersionReport(@Header String simpSessionId, ComponentVersionReports message) throws WebApplicationException, InvalidStateTransitionException, OBDPException {
        this.agentReportsProcessor.addAgentReport(new ComponentVersionAgentReport(this.hh, this.agentSessionManager.getHost(simpSessionId).getHostName(), message));
        return new ReportsResponse();
    }

    @MessageMapping(value={"/component_status"})
    public ReportsResponse handleComponentReportStatus(@Header String simpSessionId, ComponentStatusReports message) throws WebApplicationException, InvalidStateTransitionException, OBDPException {
        ArrayList<ComponentStatus> statuses = new ArrayList<ComponentStatus>();
        for (Map.Entry<String, List<ComponentStatusReport>> clusterReport : message.getComponentStatusReports().entrySet()) {
            for (ComponentStatusReport report : clusterReport.getValue()) {
                ComponentStatus componentStatus = new ComponentStatus();
                componentStatus.setClusterId(report.getClusterId());
                componentStatus.setComponentName(report.getComponentName());
                componentStatus.setServiceName(report.getServiceName());
                componentStatus.setStatus(report.getStatus());
                statuses.add(componentStatus);
            }
        }
        this.agentReportsProcessor.addAgentReport(new ComponentStatusAgentReport(this.hh, this.agentSessionManager.getHost(simpSessionId).getHostName(), statuses));
        return new ReportsResponse();
    }

    @MessageMapping(value={"/commands_status"})
    public ReportsResponse handleCommandReportStatus(@Header String simpSessionId, CommandStatusReports message) throws WebApplicationException, InvalidStateTransitionException, OBDPException {
        ArrayList<CommandReport> statuses = new ArrayList<CommandReport>();
        for (Map.Entry<String, List<CommandReport>> clusterReport : message.getClustersComponentReports().entrySet()) {
            statuses.addAll((Collection)clusterReport.getValue());
        }
        this.agentReportsProcessor.addAgentReport(new CommandStatusAgentReport(this.hh, this.agentSessionManager.getHost(simpSessionId).getHostName(), statuses));
        return new ReportsResponse();
    }

    @MessageMapping(value={"/host_status"})
    public ReportsResponse handleHostReportStatus(@Header String simpSessionId, HostStatusReport message) throws OBDPException {
        this.agentReportsProcessor.addAgentReport(new HostStatusAgentReport(this.hh, this.agentSessionManager.getHost(simpSessionId).getHostName(), message));
        return new ReportsResponse();
    }

    @MessageMapping(value={"/alerts_status"})
    public ReportsResponse handleAlertsStatus(@Header String simpSessionId, Alert[] message) throws OBDPException {
        String hostName = this.agentSessionManager.getHost(simpSessionId).getHostName();
        List<Alert> alerts = Arrays.asList(message);
        LOG.debug("Handling {} alerts status for host {}", (Object)alerts.size(), (Object)hostName);
        this.hh.getHeartbeatProcessor().processAlerts(hostName, alerts);
        return new ReportsResponse();
    }

    @MessageMapping(value={"/responses"})
    public ReportsResponse handleReceiveReport(@Header String simpSessionId, AckReport ackReport) throws HostNotRegisteredException {
        Long hostId = this.agentSessionManager.getHost(simpSessionId).getHostId();
        LOG.debug("Handling agent receive report for execution message with messageId {}, status {}, reason {}", new Object[]{ackReport.getMessageId(), ackReport.getStatus(), ackReport.getReason()});
        ((DefaultMessageEmitter)this.defaultMessageEmitterProvider.get()).processReceiveReport(hostId, ackReport);
        return new ReportsResponse();
    }
}

