/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.OBDPRuntimeException;
import id.onyx.obdp.server.agent.stomp.AgentDataHolder;
import id.onyx.obdp.server.agent.stomp.dto.Hashable;
import id.onyx.obdp.server.events.STOMPEvent;
import id.onyx.obdp.server.events.STOMPHostEvent;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AgentHostDataHolder<T extends STOMPHostEvent>
extends AgentDataHolder<T> {
    public static final Logger LOG = LoggerFactory.getLogger(AgentHostDataHolder.class);
    @Inject
    private STOMPUpdatePublisher STOMPUpdatePublisher;
    private final ConcurrentHashMap<Long, T> data = new ConcurrentHashMap();

    protected abstract T getCurrentData(Long var1) throws OBDPException;

    protected abstract T handleUpdate(T var1, T var2) throws OBDPException;

    public T getUpdateIfChanged(String agentHash, Long hostId) throws OBDPException {
        T hostData = this.initializeDataIfNeeded(hostId, true);
        return (T)(!Objects.equals(agentHash, ((Hashable)hostData).getHash()) ? hostData : (STOMPHostEvent)this.getEmptyData());
    }

    public T initializeDataIfNeeded(Long hostId, boolean regenerateHash) throws OBDPRuntimeException {
        return (T)this.data.computeIfAbsent(hostId, id -> this.initializeData(hostId, regenerateHash));
    }

    private T initializeData(Long hostId, boolean regenerateHash) {
        T hostData;
        try {
            hostData = this.getCurrentData(hostId);
        }
        catch (OBDPException e) {
            LOG.error("Error during retrieving initial value for host: {} and class {}", new Object[]{hostId, this.getClass().getName(), e});
            throw new OBDPRuntimeException("Error during retrieving initial value for host: " + hostId + " and class: " + this.getClass().getName(), e);
        }
        if (regenerateHash) {
            this.regenerateDataIdentifiers(hostData);
        }
        return hostData;
    }

    public void updateData(T update) throws OBDPException {
        try {
            this.data.compute(((STOMPHostEvent)update).getHostId(), (id, current) -> {
                STOMPHostEvent updated;
                if (current == null) {
                    current = this.initializeData((Long)id, true);
                }
                try {
                    updated = this.handleUpdate(current, update);
                }
                catch (OBDPException e) {
                    LOG.error("Error during handling update for host: {} and class {}", new Object[]{id, this.getClass().getName(), e});
                    throw new OBDPRuntimeException("Error during handling update for host: " + id + " and class: " + this.getClass().getName(), e);
                }
                if (updated == null) {
                    return current;
                }
                this.regenerateDataIdentifiers(updated);
                this.setIdentifiersToEventUpdate(update, updated);
                return updated;
            });
        }
        catch (OBDPRuntimeException e) {
            throw new OBDPException(e.getMessage(), (Throwable)e);
        }
        if (this.isIdentifierValid(update)) {
            if (((STOMPEvent)update).getType().equals((Object)STOMPEvent.Type.AGENT_CONFIGS)) {
                LOG.info("Configs update with hash {} will be sent to host {}", (Object)((Hashable)update).getHash(), (Object)((STOMPHostEvent)update).getHostId());
            }
            this.STOMPUpdatePublisher.publish((STOMPEvent)update);
        }
    }

    protected void setIdentifiersToEventUpdate(T update, T hostData) {
        ((Hashable)update).setHash(((Hashable)hostData).getHash());
    }

    public final void resetData(Long hostId) throws OBDPException {
        T newData = this.getCurrentData(hostId);
        this.data.replace(hostId, newData);
        this.STOMPUpdatePublisher.publish((STOMPEvent)newData);
    }

    public final void onHostRemoved(Long hostId) {
        this.data.remove(hostId);
    }

    public Map<Long, T> getData() {
        return this.data;
    }

    public T getData(Long hostId) {
        return (T)((STOMPHostEvent)this.data.get(hostId));
    }

    public void setData(T data, Long hostId) {
        this.data.put(hostId, data);
    }
}

