/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import id.onyx.obdp.server.agent.stomp.dto.HashAndTimestampIgnoreMixIn;
import id.onyx.obdp.server.agent.stomp.dto.HashIgnoreMixIn;
import id.onyx.obdp.server.agent.stomp.dto.Hashable;
import id.onyx.obdp.server.events.AgentConfigsUpdateEvent;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;

public abstract class AgentDataHolder<T extends Hashable> {
    protected final ReentrantLock updateLock = new ReentrantLock();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    protected abstract T getEmptyData();

    protected void regenerateDataIdentifiers(T data) {
        data.setHash(this.getHash(data));
    }

    protected boolean isIdentifierValid(T data) {
        return StringUtils.isNotEmpty((String)data.getHash());
    }

    protected String getHash(T data) {
        return this.getHash(data, "");
    }

    protected String getHash(T data, String salt) {
        String json = null;
        try {
            json = MAPPER.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error during mapping message to calculate hash", e);
        }
        String generatedPassword = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            md.update(salt.getBytes("UTF-8"));
            byte[] bytes = md.digest(json.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (byte b : bytes) {
                sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
            }
            generatedPassword = sb.toString();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return generatedPassword;
    }

    static {
        MAPPER.addMixIn(Hashable.class, HashIgnoreMixIn.class);
        MAPPER.addMixIn(AgentConfigsUpdateEvent.class, HashAndTimestampIgnoreMixIn.class);
    }
}

