/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp;

import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.AgentSessionManager;
import id.onyx.obdp.server.agent.stomp.AgentConfigsHolder;
import id.onyx.obdp.server.agent.stomp.AlertDefinitionsHolder;
import id.onyx.obdp.server.agent.stomp.HostLevelParamsHolder;
import id.onyx.obdp.server.agent.stomp.MetadataHolder;
import id.onyx.obdp.server.agent.stomp.TopologyHolder;
import id.onyx.obdp.server.agent.stomp.dto.Hash;
import id.onyx.obdp.server.events.AgentConfigsUpdateEvent;
import id.onyx.obdp.server.events.AlertDefinitionsAgentUpdateEvent;
import id.onyx.obdp.server.events.HostLevelParamsUpdateEvent;
import id.onyx.obdp.server.events.MetadataUpdateEvent;
import id.onyx.obdp.server.events.TopologyUpdateEvent;
import id.onyx.obdp.server.state.fsm.InvalidStateTransitionException;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.stereotype.Controller;

@Controller
@SendToUser(value={"/"})
@MessageMapping(value={"/agents"})
public class AgentCurrentDataController {
    private final AgentSessionManager agentSessionManager;
    private final TopologyHolder topologyHolder;
    private final MetadataHolder metadataHolder;
    private final HostLevelParamsHolder hostLevelParamsHolder;
    private final AgentConfigsHolder agentConfigsHolder;
    private final AlertDefinitionsHolder alertDefinitionsHolder;

    public AgentCurrentDataController(Injector injector) {
        this.agentSessionManager = (AgentSessionManager)injector.getInstance(AgentSessionManager.class);
        this.topologyHolder = (TopologyHolder)injector.getInstance(TopologyHolder.class);
        this.metadataHolder = (MetadataHolder)injector.getInstance(MetadataHolder.class);
        this.hostLevelParamsHolder = (HostLevelParamsHolder)injector.getInstance(HostLevelParamsHolder.class);
        this.agentConfigsHolder = (AgentConfigsHolder)injector.getInstance(AgentConfigsHolder.class);
        this.alertDefinitionsHolder = (AlertDefinitionsHolder)injector.getInstance(AlertDefinitionsHolder.class);
    }

    @MessageMapping(value={"/topologies"})
    public TopologyUpdateEvent getCurrentTopology(Hash hash) throws OBDPException, InvalidStateTransitionException {
        return this.topologyHolder.getUpdateIfChanged(hash.getHash());
    }

    @MessageMapping(value={"/metadata"})
    public MetadataUpdateEvent getCurrentMetadata(Hash hash) throws OBDPException {
        return (MetadataUpdateEvent)this.metadataHolder.getUpdateIfChanged(hash.getHash());
    }

    @MessageMapping(value={"/alert_definitions"})
    public AlertDefinitionsAgentUpdateEvent getAlertDefinitions(@Header String simpSessionId, Hash hash) throws OBDPException {
        Long hostId = this.agentSessionManager.getHost(simpSessionId).getHostId();
        return (AlertDefinitionsAgentUpdateEvent)this.alertDefinitionsHolder.getUpdateIfChanged(hash.getHash(), hostId);
    }

    @MessageMapping(value={"/configs"})
    public AgentConfigsUpdateEvent getCurrentConfigs(@Header String simpSessionId, Hash hash) throws OBDPException {
        return this.agentConfigsHolder.getUpdateIfChanged(hash.getHash(), this.agentSessionManager.getHost(simpSessionId).getHostId());
    }

    @MessageMapping(value={"/host_level_params"})
    public HostLevelParamsUpdateEvent getCurrentHostLevelParams(@Header String simpSessionId, Hash hash) throws OBDPException {
        return (HostLevelParamsUpdateEvent)this.hostLevelParamsHolder.getUpdateIfChanged(hash.getHash(), this.agentSessionManager.getHost(simpSessionId).getHostId());
    }
}

