/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.stomp.AgentHostDataHolder;
import id.onyx.obdp.server.events.AgentConfigsUpdateEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.security.encryption.Encryptor;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.utils.ThreadPools;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AgentConfigsHolder
extends AgentHostDataHolder<AgentConfigsUpdateEvent> {
    public static final Logger LOG = LoggerFactory.getLogger(AgentConfigsHolder.class);
    private final Encryptor<AgentConfigsUpdateEvent> encryptor;
    @Inject
    private ConfigHelper configHelper;
    @Inject
    private Provider<Clusters> clusters;
    @Inject
    private ThreadPools threadPools;

    @Inject
    public AgentConfigsHolder(OBDPEventPublisher ambariEventPublisher, @Named(value="AgentConfigEncryptor") Encryptor<AgentConfigsUpdateEvent> encryptor) {
        this.encryptor = encryptor;
        ambariEventPublisher.register(this);
    }

    @Override
    public AgentConfigsUpdateEvent getCurrentData(Long hostId) throws OBDPException {
        return this.configHelper.getHostActualConfigs(hostId);
    }

    public AgentConfigsUpdateEvent getCurrentDataExcludeCluster(Long hostId, Long clusterId) throws OBDPException {
        return this.configHelper.getHostActualConfigsExcludeCluster(hostId, clusterId);
    }

    @Override
    protected AgentConfigsUpdateEvent handleUpdate(AgentConfigsUpdateEvent current, AgentConfigsUpdateEvent update) {
        return update;
    }

    public void updateData(Long clusterId, List<Long> hostIds) throws OBDPException {
        if (CollectionUtils.isEmpty(hostIds)) {
            Collection<Host> hosts = ((Clusters)this.clusters.get()).getCluster(clusterId).getHosts();
            hostIds = CollectionUtils.isEmpty(hosts) ? ((Clusters)this.clusters.get()).getHosts().stream().map(Host::getHostId).collect(Collectors.toList()) : hosts.stream().map(Host::getHostId).collect(Collectors.toList());
        }
        for (Long hostId : hostIds) {
            AgentConfigsUpdateEvent agentConfigsUpdateEvent = this.configHelper.getHostActualConfigs(hostId);
            this.updateData(agentConfigsUpdateEvent);
        }
    }

    @Override
    public AgentConfigsUpdateEvent getUpdateIfChanged(String agentHash, Long hostId) throws OBDPException {
        AgentConfigsUpdateEvent update = (AgentConfigsUpdateEvent)super.getUpdateIfChanged(agentHash, hostId);
        if (update.getClustersConfigs() == null) {
            update.setTimestamp(((AgentConfigsUpdateEvent)this.getData(hostId)).getTimestamp());
        }
        return update;
    }

    @Override
    protected void regenerateDataIdentifiers(AgentConfigsUpdateEvent data) {
        data.setHash(this.getHash(data, this.encryptor.getEncryptionKey()));
        this.encryptor.encryptSensitiveData(data);
        data.setTimestamp(System.currentTimeMillis());
    }

    @Override
    protected boolean isIdentifierValid(AgentConfigsUpdateEvent data) {
        return StringUtils.isNotEmpty((String)data.getHash()) && data.getTimestamp() != null;
    }

    @Override
    protected void setIdentifiersToEventUpdate(AgentConfigsUpdateEvent update, AgentConfigsUpdateEvent hostData) {
        super.setIdentifiersToEventUpdate(update, hostData);
        update.setTimestamp(hostData.getTimestamp());
    }

    @Override
    protected AgentConfigsUpdateEvent getEmptyData() {
        return AgentConfigsUpdateEvent.emptyUpdate();
    }
}

