/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.stomp.AgentDataHolder;
import id.onyx.obdp.server.agent.stomp.dto.Hashable;
import id.onyx.obdp.server.events.STOMPEvent;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import jakarta.inject.Inject;
import java.util.Objects;

public abstract class AgentClusterDataHolder<T extends STOMPEvent>
extends AgentDataHolder<T> {
    @Inject
    protected STOMPUpdatePublisher STOMPUpdatePublisher;
    private volatile T data;

    public T getUpdateIfChanged(String agentHash) throws OBDPException {
        this.initializeDataIfNeeded(true);
        return (T)(!Objects.equals(agentHash, ((Hashable)this.data).getHash()) ? this.data : (STOMPEvent)this.getEmptyData());
    }

    protected abstract T getCurrentData() throws OBDPException;

    protected abstract boolean handleUpdate(T var1) throws OBDPException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateData(T update) throws OBDPException {
        this.updateLock.lock();
        try {
            this.initializeDataIfNeeded(true);
            boolean changed = this.handleUpdate(update);
            if (changed) {
                this.regenerateDataIdentifiers(this.data);
                ((Hashable)update).setHash(((Hashable)this.getData()).getHash());
                this.STOMPUpdatePublisher.publish((STOMPEvent)update);
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    protected final void initializeDataIfNeeded(boolean regenerateHash) throws OBDPException {
        if (this.data == null) {
            this.updateLock.lock();
            try {
                if (this.data == null) {
                    T localData = this.getCurrentData();
                    if (regenerateHash) {
                        this.regenerateDataIdentifiers(localData);
                    }
                    this.data = localData;
                }
            }
            finally {
                this.updateLock.unlock();
            }
        }
    }

    public final T getData() {
        return this.data;
    }
}

