/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.RecoveryConfig;
import id.onyx.obdp.server.agent.RecoveryConfigComponent;
import id.onyx.obdp.server.events.ClusterConfigChangedEvent;
import id.onyx.obdp.server.events.MaintenanceModeEvent;
import id.onyx.obdp.server.events.ServiceComponentInstalledEvent;
import id.onyx.obdp.server.events.ServiceComponentRecoveryChangedEvent;
import id.onyx.obdp.server.events.ServiceComponentUninstalledEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponentHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;

@Singleton
public class RecoveryConfigHelper {
    public static final String RECOVERY_ENABLED_KEY = "recovery_enabled";
    public static final String RECOVERY_TYPE_KEY = "recovery_type";
    public static final String RECOVERY_TYPE_DEFAULT = "AUTO_START";
    public static final String RECOVERY_LIFETIME_MAX_COUNT_KEY = "recovery_lifetime_max_count";
    public static final String RECOVERY_LIFETIME_MAX_COUNT_DEFAULT = "12";
    public static final String RECOVERY_MAX_COUNT_KEY = "recovery_max_count";
    public static final String RECOVERY_MAX_COUNT_DEFAULT = "6";
    public static final String RECOVERY_WINDOW_IN_MIN_KEY = "recovery_window_in_minutes";
    public static final String RECOVERY_WINDOW_IN_MIN_DEFAULT = "60";
    public static final String RECOVERY_RETRY_GAP_KEY = "recovery_retry_interval";
    public static final String RECOVERY_RETRY_GAP_DEFAULT = "5";
    @Inject
    private Clusters clusters;
    private ConcurrentHashMap<String, ConcurrentHashMap<String, Long>> timestampMap;

    @Inject
    public RecoveryConfigHelper(OBDPEventPublisher eventPublisher) {
        eventPublisher.register(this);
        this.timestampMap = new ConcurrentHashMap();
    }

    public RecoveryConfig getDefaultRecoveryConfig() throws OBDPException {
        return this.getRecoveryConfig(null, null);
    }

    public RecoveryConfig getRecoveryConfig(String clusterName, String hostname) throws OBDPException {
        long now = System.currentTimeMillis();
        if (StringUtils.isNotEmpty((String)clusterName)) {
            ConcurrentHashMap<String, Long> hostTimestamp = this.timestampMap.get(clusterName);
            if (hostTimestamp == null) {
                hostTimestamp = new ConcurrentHashMap();
                this.timestampMap.put(clusterName, hostTimestamp);
            }
            if (StringUtils.isNotEmpty((String)hostname)) {
                hostTimestamp.put(hostname, now);
            }
        }
        AutoStartConfig autoStartConfig = new AutoStartConfig(clusterName);
        RecoveryConfig recoveryConfig = new RecoveryConfig(autoStartConfig.getEnabledComponents(hostname));
        return recoveryConfig;
    }

    public boolean isConfigStale(String clusterName, String hostname, long recoveryTimestamp) {
        if (StringUtils.isEmpty((String)clusterName)) {
            throw new IllegalArgumentException("clusterName cannot be empty or null.");
        }
        if (StringUtils.isEmpty((String)hostname)) {
            throw new IllegalArgumentException("hostname cannot be empty or null.");
        }
        ConcurrentHashMap<String, Long> hostTimestamp = this.timestampMap.get(clusterName);
        if (hostTimestamp == null) {
            return true;
        }
        Long timestamp = hostTimestamp.get(hostname);
        if (timestamp == null) {
            return true;
        }
        return timestamp != recoveryTimestamp;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handleMaintenanceModeEvent(MaintenanceModeEvent event) throws OBDPException {
        ServiceComponentHost sch;
        if (event.getHost() != null) {
            Cluster cluster = this.clusters.getCluster(event.getClusterId());
            if (cluster == null) {
                return;
            }
            Host host = event.getHost();
            List<ServiceComponentHost> scHosts = cluster.getServiceComponentHosts(host.getHostName());
            for (ServiceComponentHost sch2 : scHosts) {
                if (!sch2.isRecoveryEnabled()) continue;
                this.invalidateRecoveryTimestamp(sch2.getClusterName(), sch2.getHostName());
                break;
            }
        } else if (event.getService() != null) {
            Service service = event.getService();
            this.invalidateRecoveryTimestamp(service.getCluster().getClusterName(), null);
        } else if (event.getServiceComponentHost() != null && (sch = event.getServiceComponentHost()).isRecoveryEnabled()) {
            this.invalidateRecoveryTimestamp(sch.getClusterName(), sch.getHostName());
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handleServiceComponentInstalledEvent(ServiceComponentInstalledEvent event) throws OBDPException {
        Cluster cluster;
        if (event.isRecoveryEnabled() && (cluster = this.clusters.getClusterById(event.getClusterId())) != null) {
            this.invalidateRecoveryTimestamp(cluster.getClusterName(), event.getHostName());
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handleServiceComponentUninstalledEvent(ServiceComponentUninstalledEvent event) throws OBDPException {
        Cluster cluster;
        if (event.isRecoveryEnabled() && (cluster = this.clusters.getClusterById(event.getClusterId())) != null) {
            this.invalidateRecoveryTimestamp(cluster.getClusterName(), event.getHostName());
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handleServiceComponentRecoveryChangedEvent(ServiceComponentRecoveryChangedEvent event) {
        this.invalidateRecoveryTimestamp(event.getClusterName(), null);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handleClusterEnvConfigChangedEvent(ClusterConfigChangedEvent event) {
        if (StringUtils.equals((String)event.getConfigType(), (String)"cluster-env")) {
            this.invalidateRecoveryTimestamp(event.getClusterName(), null);
        }
    }

    private void invalidateRecoveryTimestamp(String clusterName, String hostname) {
        ConcurrentHashMap<String, Long> hostTimestamp;
        if (StringUtils.isNotEmpty((String)clusterName) && (hostTimestamp = this.timestampMap.get(clusterName)) != null) {
            if (StringUtils.isNotEmpty((String)hostname)) {
                hostTimestamp.put(hostname, 0L);
            } else {
                for (Map.Entry<String, Long> hostEntry : hostTimestamp.entrySet()) {
                    hostEntry.setValue(0L);
                }
            }
        }
    }

    class AutoStartConfig {
        private Cluster cluster;
        private Map<String, String> configProperties;

        public AutoStartConfig(String clusterName) throws OBDPException {
            Config config;
            if (StringUtils.isNotEmpty((String)clusterName)) {
                this.cluster = RecoveryConfigHelper.this.clusters.getCluster(clusterName);
            }
            if (this.cluster != null && (config = this.cluster.getDesiredConfigByType(this.getConfigType())) != null) {
                this.configProperties = config.getProperties();
            }
            if (this.configProperties == null) {
                this.configProperties = new HashMap<String, String>();
            }
        }

        private List<RecoveryConfigComponent> getEnabledComponents(String hostname) throws OBDPException {
            ArrayList<RecoveryConfigComponent> enabledComponents = new ArrayList<RecoveryConfigComponent>();
            if (this.cluster == null) {
                return enabledComponents;
            }
            Host host = RecoveryConfigHelper.this.clusters.getHost(hostname);
            if (host == null) {
                return enabledComponents;
            }
            if (host.getMaintenanceState(this.cluster.getClusterId()) == MaintenanceState.ON) {
                return enabledComponents;
            }
            List<ServiceComponentHost> scHosts = this.cluster.getServiceComponentHosts(hostname);
            for (ServiceComponentHost sch : scHosts) {
                Service service;
                if (!sch.isRecoveryEnabled() || (service = this.cluster.getService(sch.getServiceName())).getMaintenanceState() != MaintenanceState.OFF || sch.getMaintenanceState() != MaintenanceState.OFF) continue;
                enabledComponents.add(new RecoveryConfigComponent(sch));
            }
            return enabledComponents;
        }

        private String getConfigType() {
            return "cluster-env";
        }

        private boolean isRecoveryEnabled() {
            return Boolean.parseBoolean(this.getProperty(RecoveryConfigHelper.RECOVERY_ENABLED_KEY, "false"));
        }

        private String getProperty(String key, String defaultValue) {
            if (this.configProperties.containsKey(key)) {
                return this.configProperties.get(key);
            }
            return defaultValue;
        }
    }
}

