/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent;

import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.google.inject.Inject;
import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.ServiceComponentHostNotFoundException;
import id.onyx.obdp.server.ServiceComponentNotFoundException;
import id.onyx.obdp.server.ServiceNotFoundException;
import id.onyx.obdp.server.actionmanager.ActionManager;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.agent.ComponentStatus;
import id.onyx.obdp.server.agent.HeartBeat;
import id.onyx.obdp.server.agent.HeartbeatMonitor;
import id.onyx.obdp.server.agent.stomp.dto.ComponentVersionReport;
import id.onyx.obdp.server.agent.stomp.dto.ComponentVersionReports;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.MaintenanceStateHelper;
import id.onyx.obdp.server.events.ActionFinalReportReceivedEvent;
import id.onyx.obdp.server.events.AlertReceivedEvent;
import id.onyx.obdp.server.events.HostComponentVersionAdvertisedEvent;
import id.onyx.obdp.server.events.publishers.AlertEventPublisher;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.events.publishers.VersionEventPublisher;
import id.onyx.obdp.server.metadata.ActionMetadata;
import id.onyx.obdp.server.orm.dao.KerberosKeytabDAO;
import id.onyx.obdp.server.orm.dao.KerberosKeytabPrincipalDAO;
import id.onyx.obdp.server.orm.entities.KerberosKeytabPrincipalEntity;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.state.Alert;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.HostHealthStatus;
import id.onyx.obdp.server.state.HostState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.server.state.UpgradeState;
import id.onyx.obdp.server.state.fsm.InvalidStateTransitionException;
import id.onyx.obdp.server.state.host.HostStatusUpdatesReceivedEvent;
import id.onyx.obdp.server.state.scheduler.RequestExecution;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostOpFailedEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostOpInProgressEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostOpSucceededEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostStartedEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostStoppedEvent;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatProcessor
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatProcessor.class);
    private ScheduledExecutorService executor;
    private ConcurrentLinkedQueue<HeartBeat> heartBeatsQueue = new ConcurrentLinkedQueue();
    private volatile boolean shouldRun = true;
    private long delay = 5000L;
    private long period = 1000L;
    private int poolSize = 1;
    private Clusters clusterFsm;
    private HeartbeatMonitor heartbeatMonitor;
    private Injector injector;
    private ActionManager actionManager;
    @Inject
    AlertEventPublisher alertEventPublisher;
    @Inject
    OBDPEventPublisher ambariEventPublisher;
    @Inject
    VersionEventPublisher versionEventPublisher;
    @Inject
    ActionMetadata actionMetadata;
    @Inject
    MaintenanceStateHelper maintenanceStateHelper;
    @Inject
    OBDPMetaInfo obdpMetaInfo;
    @Inject
    KerberosKeytabPrincipalDAO kerberosKeytabPrincipalDAO;
    @Inject
    KerberosKeytabDAO kerberosKeytabDAO;
    @Inject
    Gson gson;

    @Inject
    public HeartbeatProcessor(Clusters clusterFsm, ActionManager am, HeartbeatMonitor heartbeatMonitor, Injector injector) {
        injector.injectMembers((Object)this);
        this.injector = injector;
        this.heartbeatMonitor = heartbeatMonitor;
        this.clusterFsm = clusterFsm;
        this.actionManager = am;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("obdp-heartbeat-processor-%d").build();
        this.executor = Executors.newScheduledThreadPool(this.poolSize, threadFactory);
    }

    protected void doStart() {
        LOG.info("**** Starting heartbeats processing threads ****");
        for (int i = 0; i < this.poolSize; ++i) {
            this.executor.scheduleAtFixedRate(new HeartbeatProcessingTask(), this.delay, this.period, TimeUnit.MILLISECONDS);
        }
    }

    protected void doStop() {
        LOG.info("**** Stopping heartbeats processing threads ****");
        this.shouldRun = false;
        this.executor.shutdown();
    }

    public void addHeartbeat(HeartBeat heartBeat) {
        this.heartBeatsQueue.add(heartBeat);
    }

    private HeartBeat pollHeartbeat() {
        return this.heartBeatsQueue.poll();
    }

    public void processHeartbeat(HeartBeat heartbeat) throws OBDPException {
        long now = System.currentTimeMillis();
        this.processAlerts(heartbeat);
        this.processStatusReports(heartbeat);
        this.processCommandReports(heartbeat, now);
        this.processHostStatus(heartbeat);
    }

    protected void processAlerts(HeartBeat heartbeat) {
        if (heartbeat != null) {
            this.processAlerts(heartbeat.getHostname(), heartbeat.getAlerts());
        }
    }

    public void processAlerts(String hostname, List<Alert> alerts) {
        if (alerts != null && !alerts.isEmpty()) {
            for (Alert alert : alerts) {
                if (alert.getHostName() != null) continue;
                alert.setHostName(hostname);
            }
            AlertReceivedEvent event = new AlertReceivedEvent(alerts);
            this.alertEventPublisher.publish(event);
        }
    }

    protected void processHostStatus(HeartBeat heartbeat) throws OBDPException {
        this.processHostStatus(heartbeat.getComponentStatus(), heartbeat.getReports(), heartbeat.getHostname());
    }

    protected void processHostStatus(List<ComponentStatus> componentStatuses, List<CommandReport> reports, String hostName) throws OBDPException {
        Host host = this.clusterFsm.getHost(hostName);
        HostHealthStatus.HealthStatus healthStatus = host.getHealthStatus().getHealthStatus();
        if (!healthStatus.equals((Object)HostHealthStatus.HealthStatus.UNKNOWN)) {
            boolean calculateHostStatus = false;
            Long clusterId = null;
            if (CollectionUtils.isNotEmpty(componentStatuses)) {
                calculateHostStatus = true;
                clusterId = componentStatuses.stream().findFirst().map(ComponentStatus::getClusterId).orElse(null);
            }
            if (!calculateHostStatus && CollectionUtils.isNotEmpty(reports)) {
                for (CommandReport report : reports) {
                    String service;
                    if (RoleCommand.ACTIONEXECUTE.toString().equals(report.getRoleCommand()) || this.actionMetadata.getActions((service = report.getServiceName()).toLowerCase()).contains(report.getRole()) || !report.getStatus().equals("COMPLETED")) continue;
                    calculateHostStatus = true;
                    clusterId = Long.parseLong(report.getClusterId());
                    break;
                }
            }
            if (calculateHostStatus) {
                host.calculateHostStatus(clusterId);
            }
            if (this.clusterFsm.getClustersForHost(host.getHostName()).size() == 0) {
                healthStatus = HostHealthStatus.HealthStatus.HEALTHY;
                host.setStatus(healthStatus.name());
            }
        }
    }

    protected void processCommandReports(HeartBeat heartbeat, long now) throws OBDPException {
        this.processCommandReports(heartbeat.getReports(), heartbeat.getHostname(), now);
    }

    protected void processCommandReports(List<CommandReport> reports, String hostName, Long now) throws OBDPException {
        ArrayList<Long> taskIds = new ArrayList<Long>();
        for (CommandReport report : reports) {
            taskIds.add(report.getTaskId());
        }
        Map<Long, HostRoleCommand> commands = this.actionManager.getTasksMap(taskIds);
        for (CommandReport report : reports) {
            HostRoleCommand hostRoleCommand;
            Long clusterId = Long.parseLong(report.getClusterId());
            LOG.debug("Received command report: {}", (Object)report);
            Host host = this.clusterFsm.getHost(hostName);
            if (host == null) {
                LOG.error("Received a command report and was unable to retrieve Host for hostname = " + hostName);
                continue;
            }
            if (RoleCommand.valueOf(report.getRoleCommand()) == RoleCommand.ACTIONEXECUTE && HostRoleStatus.valueOf(report.getStatus()).isCompletedState()) {
                ActionFinalReportReceivedEvent event = new ActionFinalReportReceivedEvent(clusterId, hostName, report, false);
                this.ambariEventPublisher.publish(event);
            }
            if ((hostRoleCommand = commands.get(report.getTaskId())) == null) {
                LOG.warn("Can't fetch HostRoleCommand with taskId = " + report.getTaskId());
            } else {
                if (hostRoleCommand.getStatus() == HostRoleStatus.ABORTED) continue;
                if (hostRoleCommand.getStatus() == HostRoleStatus.QUEUED && report.getStatus().equals("IN_PROGRESS")) {
                    hostRoleCommand.setStartTime(now);
                    if (hostRoleCommand.getOriginalStartTime() == -1L) {
                        hostRoleCommand.setOriginalStartTime(now);
                    }
                }
            }
            if (Service.Type.KERBEROS.name().equalsIgnoreCase(report.getServiceName()) && Role.KERBEROS_CLIENT.name().equalsIgnoreCase(report.getRole()) && RoleCommand.CUSTOM_COMMAND.name().equalsIgnoreCase(report.getRoleCommand()) && RequestExecution.Status.COMPLETED.name().equalsIgnoreCase(report.getStatus())) {
                String customCommand = report.getCustomCommand();
                if ("SET_KEYTAB".equalsIgnoreCase(customCommand)) {
                    WriteKeytabsStructuredOut writeKeytabsStructuredOut;
                    try {
                        writeKeytabsStructuredOut = (WriteKeytabsStructuredOut)this.gson.fromJson(report.getStructuredOut(), WriteKeytabsStructuredOut.class);
                    }
                    catch (JsonSyntaxException ex) {
                        writeKeytabsStructuredOut = null;
                    }
                    if (writeKeytabsStructuredOut != null && (keytabs = writeKeytabsStructuredOut.getKeytabs()) != null) {
                        for (Map.Entry<String, String> entry : keytabs.entrySet()) {
                            String keytabPath = entry.getValue();
                            for (KerberosKeytabPrincipalEntity kkpe : this.kerberosKeytabPrincipalDAO.findByHostAndKeytab(host.getHostId(), keytabPath)) {
                                kkpe.setDistributed(true);
                                this.kerberosKeytabPrincipalDAO.merge(kkpe);
                            }
                        }
                    }
                } else if ("CHECK_KEYTABS".equalsIgnoreCase(customCommand)) {
                    ListKeytabsStructuredOut structuredOut = (ListKeytabsStructuredOut)this.gson.fromJson(report.getStructuredOut(), ListKeytabsStructuredOut.class);
                    keytabs = structuredOut.missingKeytabs.iterator();
                    while (keytabs.hasNext()) {
                        MissingKeytab each = (MissingKeytab)keytabs.next();
                        LOG.info("Missing principal: {} for keytab: {} on host: {}", new Object[]{each.principal, each.keytabFilePath, hostName});
                        KerberosKeytabPrincipalEntity kkpe = this.kerberosKeytabPrincipalDAO.findByHostKeytabAndPrincipal(host.getHostId(), each.keytabFilePath, each.principal);
                        kkpe.setDistributed(false);
                        this.kerberosKeytabPrincipalDAO.merge(kkpe);
                    }
                }
            }
            if (RoleCommand.ACTIONEXECUTE.toString().equals(report.getRoleCommand()) || RoleCommand.CUSTOM_COMMAND.toString().equals(report.getRoleCommand()) && !"RESTART".equals(report.getCustomCommand()) && !"START".equals(report.getCustomCommand()) && !"STOP".equals(report.getCustomCommand())) continue;
            Cluster cl = this.clusterFsm.getCluster(Long.parseLong(report.getClusterId()));
            String service = report.getServiceName();
            if (service == null || service.isEmpty()) {
                throw new OBDPException("Invalid command report, service: " + service);
            }
            if (this.actionMetadata.getActions(service.toLowerCase()).contains(report.getRole())) {
                LOG.debug("{} is an action - skip component lookup", (Object)report.getRole());
                continue;
            }
            try {
                ComponentVersionStructuredOut structuredOutput;
                Service svc = cl.getService(service);
                ServiceComponent svcComp = svc.getServiceComponent(report.getRole());
                ServiceComponentHost scHost = svcComp.getServiceComponentHost(hostName);
                String schName = scHost.getServiceComponentName();
                if (report.getStatus().equals(HostRoleStatus.COMPLETED.toString())) {
                    if (StringUtils.isNotBlank((String)report.getStructuredOut()) && !StringUtils.equals((String)"{}", (String)report.getStructuredOut())) {
                        structuredOutput = null;
                        try {
                            structuredOutput = (ComponentVersionStructuredOut)this.gson.fromJson(report.getStructuredOut(), ComponentVersionStructuredOut.class);
                        }
                        catch (JsonSyntaxException kkpe) {
                            // empty catch block
                        }
                        String newVersion = structuredOutput == null ? null : structuredOutput.version;
                        Long repoVersionId = structuredOutput == null ? null : structuredOutput.repositoryVersionId;
                        HostComponentVersionAdvertisedEvent event = new HostComponentVersionAdvertisedEvent(cl, scHost, newVersion, repoVersionId);
                        this.versionEventPublisher.publish(event);
                    }
                    if (!scHost.getState().equals((Object)State.UPGRADING) && (report.getRoleCommand().equals(RoleCommand.START.toString()) || report.getRoleCommand().equals(RoleCommand.CUSTOM_COMMAND.toString()) && ("START".equals(report.getCustomCommand()) || "RESTART".equals(report.getCustomCommand())))) {
                        scHost.setRestartRequired(false);
                    }
                    if ((RoleCommand.INSTALL.toString().equals(report.getRoleCommand()) || RoleCommand.CUSTOM_COMMAND.toString().equals(report.getRoleCommand()) && "INSTALL".equals(report.getCustomCommand())) && svcComp.isClientComponent()) {
                        scHost.setRestartRequired(false);
                    }
                    if (RoleCommand.CUSTOM_COMMAND.toString().equals(report.getRoleCommand()) && !"START".equals(report.getCustomCommand()) && !"STOP".equals(report.getCustomCommand())) continue;
                    if (RoleCommand.START.toString().equals(report.getRoleCommand()) || RoleCommand.CUSTOM_COMMAND.toString().equals(report.getRoleCommand()) && "START".equals(report.getCustomCommand())) {
                        scHost.handleEvent(new ServiceComponentHostStartedEvent(schName, hostName, now));
                        scHost.setRestartRequired(false);
                        continue;
                    }
                    if (RoleCommand.STOP.toString().equals(report.getRoleCommand()) || RoleCommand.CUSTOM_COMMAND.toString().equals(report.getRoleCommand()) && "STOP".equals(report.getCustomCommand())) {
                        scHost.handleEvent(new ServiceComponentHostStoppedEvent(schName, hostName, now));
                        continue;
                    }
                    scHost.handleEvent(new ServiceComponentHostOpSucceededEvent(schName, hostName, now));
                    continue;
                }
                if (report.getStatus().equals("FAILED")) {
                    if (StringUtils.isNotBlank((String)report.getStructuredOut())) {
                        try {
                            structuredOutput = (ComponentVersionStructuredOut)this.gson.fromJson(report.getStructuredOut(), ComponentVersionStructuredOut.class);
                            if (null != structuredOutput.upgradeDirection) {
                                scHost.setUpgradeState(UpgradeState.FAILED);
                            }
                        }
                        catch (JsonSyntaxException ex) {
                            LOG.warn("Structured output was found, but not parseable: {}", (Object)report.getStructuredOut());
                        }
                    }
                    LOG.error("Operation failed - may be retried. Service component host: " + schName + ", host: " + hostName + " Action id " + report.getActionId() + " and taskId " + report.getTaskId());
                    if (this.actionManager.isInProgressCommand(report)) {
                        scHost.handleEvent(new ServiceComponentHostOpFailedEvent(schName, hostName, now));
                        continue;
                    }
                    LOG.info("Received report for a command that is no longer active. " + report);
                    continue;
                }
                if (!report.getStatus().equals("IN_PROGRESS")) continue;
                scHost.handleEvent(new ServiceComponentHostOpInProgressEvent(schName, hostName, now));
            }
            catch (ServiceComponentNotFoundException scnex) {
                LOG.warn("Service component not found ", (Throwable)((Object)scnex));
            }
            catch (InvalidStateTransitionException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("State machine exception.", (Throwable)ex);
                    continue;
                }
                LOG.warn("State machine exception. " + ex.getMessage());
            }
        }
        this.actionManager.processTaskResponse(hostName, reports, commands);
    }

    protected void processStatusReports(HeartBeat heartbeat) throws OBDPException {
        this.processStatusReports(heartbeat.getComponentStatus(), heartbeat.getHostname());
    }

    public void processVersionReports(ComponentVersionReports versionReports, String hostname) throws OBDPException {
        Set<Cluster> clusters = this.clusterFsm.getClustersForHost(hostname);
        for (Cluster cl : clusters) {
            for (Map.Entry<String, List<ComponentVersionReport>> status : versionReports.getComponentVersionReports().entrySet()) {
                if (!Long.valueOf(status.getKey()).equals(cl.getClusterId())) continue;
                for (ComponentVersionReport versionReport : status.getValue()) {
                    try {
                        Service svc = cl.getService(versionReport.getServiceName());
                        String componentName = versionReport.getComponentName();
                        if (!svc.getServiceComponents().containsKey(componentName)) continue;
                        ServiceComponent svcComp = svc.getServiceComponent(componentName);
                        ServiceComponentHost scHost = svcComp.getServiceComponentHost(hostname);
                        String version = versionReport.getVersion();
                        HostComponentVersionAdvertisedEvent event = new HostComponentVersionAdvertisedEvent(cl, scHost, version);
                        this.versionEventPublisher.publish(event);
                    }
                    catch (ServiceNotFoundException e) {
                        LOG.warn("Received a version report for a non-initialized service, clusterId=" + versionReport.getClusterId() + ", serviceName=" + versionReport.getServiceName());
                    }
                    catch (ServiceComponentNotFoundException e) {
                        LOG.warn("Received a version report for a non-initialized servicecomponent, clusterId=" + versionReport.getClusterId() + ", serviceName=" + versionReport.getServiceName() + ", componentName=" + versionReport.getComponentName());
                    }
                    catch (ServiceComponentHostNotFoundException e) {
                        LOG.warn("Received a version report for a non-initialized hostcomponent, clusterId=" + versionReport.getClusterId() + ", serviceName=" + versionReport.getServiceName() + ", componentName=" + versionReport.getComponentName() + ", hostname=" + hostname);
                    }
                    catch (RuntimeException e) {
                        LOG.warn("Received a version report with invalid payload service, clusterId=" + versionReport.getClusterId() + ", serviceName=" + versionReport.getServiceName() + ", componentName=" + versionReport.getComponentName() + ", hostname=" + hostname + ", error=" + e.getMessage());
                    }
                }
            }
        }
    }

    public void processStatusReports(List<ComponentStatus> componentStatuses, String hostname) throws OBDPException {
        Set<Cluster> clusters = this.clusterFsm.getClustersForHost(hostname);
        for (Cluster cl : clusters) {
            for (ComponentStatus status : componentStatuses) {
                if (!status.getClusterId().equals(cl.getClusterId())) continue;
                try {
                    Map<String, Object> extra;
                    Service svc = cl.getService(status.getServiceName());
                    String componentName = status.getComponentName();
                    if (!svc.getServiceComponents().containsKey(componentName)) continue;
                    ServiceComponent svcComp = svc.getServiceComponent(componentName);
                    ServiceComponentHost scHost = svcComp.getServiceComponentHost(hostname);
                    if (status.getStatus() != null) {
                        State prevState = scHost.getState();
                        State liveState = State.valueOf(State.class, status.getStatus());
                        if (prevState.equals((Object)State.INSTALLED) || prevState.equals((Object)State.STARTED) || prevState.equals((Object)State.UNKNOWN)) {
                            scHost.setState(liveState);
                            if (!prevState.equals((Object)liveState)) {
                                LOG.info("State of service component " + componentName + " of service " + status.getServiceName() + " of cluster " + status.getClusterId() + " has changed from " + prevState + " to " + liveState + " at host " + hostname + " according to STATUS_COMMAND report");
                            }
                        }
                    }
                    if (null != (extra = status.getExtra()) && !extra.isEmpty()) {
                        try {
                            if (extra.containsKey("processes")) {
                                List list = (List)extra.get("processes");
                                scHost.setProcesses(list);
                            }
                        }
                        catch (Exception e) {
                            LOG.error("Could not access extra JSON for " + scHost.getServiceComponentName() + " from " + scHost.getHostName() + ": " + status.getExtra() + " (" + e.getMessage() + ")");
                        }
                    }
                    this.heartbeatMonitor.getAgentRequests().setExecutionDetailsRequest(hostname, componentName, status.getSendExecCmdDet());
                }
                catch (ServiceNotFoundException e) {
                    LOG.warn("Received a live status update for a non-initialized service, clusterId=" + status.getClusterId() + ", serviceName=" + status.getServiceName());
                }
                catch (ServiceComponentNotFoundException e) {
                    LOG.warn("Received a live status update for a non-initialized servicecomponent, clusterId=" + status.getClusterId() + ", serviceName=" + status.getServiceName() + ", componentName=" + status.getComponentName());
                }
                catch (ServiceComponentHostNotFoundException e) {
                    LOG.warn("Received a live status update for a non-initialized service, clusterId=" + status.getClusterId() + ", serviceName=" + status.getServiceName() + ", componentName=" + status.getComponentName() + ", hostname=" + hostname);
                }
                catch (RuntimeException e) {
                    LOG.warn("Received a live status with invalid payload service, clusterId=" + status.getClusterId() + ", serviceName=" + status.getServiceName() + ", componentName=" + status.getComponentName() + ", hostname=" + hostname + ", error=" + e.getMessage());
                }
            }
        }
        Host host = this.clusterFsm.getHost(hostname);
        long now = System.currentTimeMillis();
        if (componentStatuses.size() > 0 && host.getState().equals((Object)HostState.WAITING_FOR_HOST_STATUS_UPDATES)) {
            try {
                LOG.debug("Got component status updates for host {}", (Object)hostname);
                host.handleEvent(new HostStatusUpdatesReceivedEvent(hostname, now));
            }
            catch (InvalidStateTransitionException e) {
                LOG.warn("Failed to notify the host about component status updates for host {}", (Object)hostname, (Object)e);
            }
        }
    }

    private class HeartbeatProcessingTask
    implements Runnable {
        private HeartbeatProcessingTask() {
        }

        @Override
        public void run() {
            while (HeartbeatProcessor.this.shouldRun) {
                try {
                    HeartBeat heartbeat = HeartbeatProcessor.this.pollHeartbeat();
                    if (heartbeat == null) break;
                    HeartbeatProcessor.this.processHeartbeat(heartbeat);
                }
                catch (Exception e) {
                    LOG.error("Exception received while processing heartbeat", (Throwable)e);
                }
                catch (Throwable throwable) {
                    LOG.error("ERROR: ", throwable);
                }
            }
        }
    }

    private static class WriteKeytabsStructuredOut {
        @SerializedName(value="keytabs")
        private Map<String, String> keytabs;
        @SerializedName(value="removedKeytabs")
        private Map<String, String> removedKeytabs;

        private WriteKeytabsStructuredOut() {
        }

        public Map<String, String> getKeytabs() {
            return this.keytabs;
        }

        public void setKeytabs(Map<String, String> keytabs) {
            this.keytabs = keytabs;
        }

        public Map<String, String> getRemovedKeytabs() {
            return this.removedKeytabs;
        }

        public void setRemovedKeytabs(Map<String, String> removedKeytabs) {
            this.removedKeytabs = removedKeytabs;
        }
    }

    private static class ListKeytabsStructuredOut {
        @SerializedName(value="missing_keytabs")
        private final List<MissingKeytab> missingKeytabs;

        public ListKeytabsStructuredOut(List<MissingKeytab> missingKeytabs) {
            this.missingKeytabs = missingKeytabs;
        }
    }

    private static class MissingKeytab {
        @SerializedName(value="principal")
        private final String principal;
        @SerializedName(value="keytab_file_path")
        private final String keytabFilePath;

        public MissingKeytab(String principal, String keytabFilePath) {
            this.principal = principal;
            this.keytabFilePath = keytabFilePath;
        }
    }

    private static class ComponentVersionStructuredOut {
        @SerializedName(value="version")
        private String version;
        @SerializedName(value="upgrade_type")
        private UpgradeType upgradeType = null;
        @SerializedName(value="direction")
        private Direction upgradeDirection = null;
        @SerializedName(value="repository_version_id")
        private Long repositoryVersionId;

        private ComponentVersionStructuredOut() {
        }
    }
}

