/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.actionmanager.ActionManager;
import id.onyx.obdp.server.agent.AgentRequests;
import id.onyx.obdp.server.agent.ExecutionCommand;
import id.onyx.obdp.server.agent.StatusCommand;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.events.MessageNotDelivered;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.CommandScriptDefinition;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.HostState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.server.state.fsm.InvalidStateTransitionException;
import id.onyx.obdp.server.state.host.HostHeartbeatLostEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatMonitor
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatMonitor.class);
    private Clusters clusters;
    private ActionManager actionManager;
    private final int threadWakeupInterval;
    private volatile boolean shouldRun = true;
    private Thread monitorThread = null;
    private final ConfigHelper configHelper;
    private final OBDPMetaInfo obdpMetaInfo;
    private final OBDPManagementController ambariManagementController;
    private final Configuration configuration;
    private final AgentRequests agentRequests;
    private final OBDPEventPublisher ambariEventPublisher;

    public HeartbeatMonitor(Clusters clusters, ActionManager am, int threadWakeupInterval, Injector injector) {
        this.clusters = clusters;
        this.actionManager = am;
        this.threadWakeupInterval = threadWakeupInterval;
        this.configHelper = (ConfigHelper)injector.getInstance(ConfigHelper.class);
        this.obdpMetaInfo = (OBDPMetaInfo)injector.getInstance(OBDPMetaInfo.class);
        this.ambariManagementController = (OBDPManagementController)injector.getInstance(OBDPManagementController.class);
        this.configuration = (Configuration)injector.getInstance(Configuration.class);
        this.agentRequests = new AgentRequests();
        this.ambariEventPublisher = (OBDPEventPublisher)injector.getInstance(OBDPEventPublisher.class);
        this.ambariEventPublisher.register(this);
    }

    public void shutdown() {
        this.shouldRun = false;
    }

    public void start() {
        this.monitorThread = new Thread((Runnable)this, "ambari-hearbeat-monitor");
        this.monitorThread.start();
    }

    void join(long millis) throws InterruptedException {
        this.monitorThread.join(millis);
    }

    public boolean isAlive() {
        return this.monitorThread.isAlive();
    }

    public AgentRequests getAgentRequests() {
        return this.agentRequests;
    }

    @Override
    public void run() {
        while (this.shouldRun) {
            try {
                this.doWork();
                LOG.trace("Putting monitor to sleep for {} milliseconds", (Object)this.threadWakeupInterval);
                Thread.sleep(this.threadWakeupInterval);
            }
            catch (InterruptedException ex) {
                LOG.warn("Scheduler thread is interrupted going to stop", (Throwable)ex);
                this.shouldRun = false;
            }
            catch (Exception ex) {
                LOG.warn("Exception received", (Throwable)ex);
            }
            catch (Throwable t) {
                LOG.warn("ERROR", t);
            }
        }
    }

    private void doWork() throws InvalidStateTransitionException, OBDPException {
        List<Host> allHosts = this.clusters.getHosts();
        long now = System.currentTimeMillis();
        for (Host hostObj : allHosts) {
            long timeSpentInState;
            if (hostObj.getState() == HostState.HEARTBEAT_LOST) continue;
            Long hostId = hostObj.getHostId();
            HostState hostState = hostObj.getState();
            long lastHeartbeat = 0L;
            try {
                lastHeartbeat = this.clusters.getHostById(hostId).getLastHeartbeatTime();
            }
            catch (OBDPException e) {
                LOG.warn("Exception in getting host object; Is it fatal?", (Throwable)e);
            }
            if (lastHeartbeat + (long)(2 * this.threadWakeupInterval) < now) {
                this.handleHeartbeatLost(hostId);
            }
            if (hostState != HostState.WAITING_FOR_HOST_STATUS_UPDATES || (timeSpentInState = hostObj.getTimeInState()) + (long)(5 * this.threadWakeupInterval) >= now) continue;
            LOG.warn("timeSpentInState + 5*threadWakeupInterval < now, Go back to init");
            hostObj.setState(HostState.INIT);
        }
    }

    public List<StatusCommand> generateStatusCommands(String hostname) throws OBDPException {
        ArrayList<StatusCommand> cmds = new ArrayList<StatusCommand>();
        for (Cluster cl : this.clusters.getClustersForHost(hostname)) {
            Map<String, DesiredConfig> desiredConfigs = cl.getDesiredConfigs();
            block4: for (ServiceComponentHost sch : cl.getServiceComponentHosts(hostname)) {
                switch (sch.getState()) {
                    case INIT: 
                    case INSTALLING: 
                    case STARTING: 
                    case STOPPING: {
                        continue block4;
                    }
                }
                StatusCommand statusCmd = this.createStatusCommand(hostname, cl, sch, desiredConfigs);
                cmds.add(statusCmd);
            }
        }
        return cmds;
    }

    private StatusCommand createStatusCommand(String hostname, Cluster cluster, ServiceComponentHost sch, Map<String, DesiredConfig> desiredConfigs) throws OBDPException {
        String serviceName = sch.getServiceName();
        String componentName = sch.getServiceComponentName();
        StackId stackId = sch.getDesiredStackId();
        ServiceInfo serviceInfo = this.obdpMetaInfo.getService(stackId.getStackName(), stackId.getStackVersion(), serviceName);
        ComponentInfo componentInfo = this.obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), serviceName, componentName);
        TreeMap<String, Map<String, String>> configurations = new TreeMap<String, Map<String, String>>();
        TreeMap<String, Map<String, Map<String, String>>> configurationAttributes = new TreeMap<String, Map<String, Map<String, String>>>();
        Collection<Config> clusterConfigs = cluster.getAllConfigs();
        Set<String> desiredConfigTypes = desiredConfigs.keySet();
        Map<String, Map<String, String>> allConfigTags = this.configHelper.getEffectiveDesiredTags(cluster, hostname);
        for (Config clusterConfig : clusterConfigs) {
            String configType = clusterConfig.getType();
            if (!configType.endsWith("-env") || !desiredConfigTypes.contains(configType)) continue;
            HashMap<String, String> props = new HashMap<String, String>(clusterConfig.getProperties());
            HashMap<String, Map<String, String>> configTags = new HashMap<String, Map<String, String>>();
            for (Map.Entry<String, Map<String, String>> entry : allConfigTags.entrySet()) {
                if (!entry.getKey().equals(clusterConfig.getType())) continue;
                configTags.put(clusterConfig.getType(), (Map)entry.getValue());
            }
            Map<String, Map<String, String>> properties = this.configHelper.getEffectiveConfigProperties(cluster, configTags);
            if (!properties.isEmpty()) {
                Map.Entry<String, Map<String, String>> entry;
                entry = properties.values().iterator();
                while (entry.hasNext()) {
                    Map propertyMap = (Map)entry.next();
                    props.putAll(propertyMap);
                }
            }
            configurations.put(clusterConfig.getType(), props);
            TreeMap<String, Map<String, String>> attrs = new TreeMap<String, Map<String, String>>();
            this.configHelper.cloneAttributesMap(clusterConfig.getPropertiesAttributes(), attrs);
            Map<String, Map<String, Map<String, String>>> attributes = this.configHelper.getEffectiveConfigAttributes(cluster, configTags);
            for (Map<String, Map<String, String>> attributesMap : attributes.values()) {
                this.configHelper.cloneAttributesMap(attributesMap, attrs);
            }
            configurationAttributes.put(clusterConfig.getType(), attrs);
        }
        StatusCommand statusCmd = new StatusCommand();
        statusCmd.setClusterName(cluster.getClusterName());
        statusCmd.setServiceName(serviceName);
        statusCmd.setComponentName(componentName);
        statusCmd.setConfigurations(configurations);
        statusCmd.setConfigurationAttributes(configurationAttributes);
        statusCmd.setHostname(hostname);
        statusCmd.setDesiredState(sch.getDesiredState());
        statusCmd.setHasStaleConfigs(this.configHelper.isStaleConfigs(sch, desiredConfigs));
        if (this.getAgentRequests().shouldSendExecutionDetails(hostname, componentName).booleanValue()) {
            LOG.info(componentName + " is at " + sch.getState() + " adding more payload per agent ask");
            statusCmd.setPayloadLevel(StatusCommand.StatusCommandPayload.EXECUTION_COMMAND);
        }
        Map<String, String> commandParams = statusCmd.getCommandParams();
        String commandTimeout = this.configuration.getDefaultAgentTaskTimeout(false);
        CommandScriptDefinition script = componentInfo.getCommandScript();
        if (serviceInfo.getSchemaVersion().equals("2.0")) {
            if (script != null) {
                commandParams.put("script", script.getScript());
                commandParams.put("script_type", script.getScriptType().toString());
                if (script.getTimeout() > 0) {
                    commandTimeout = String.valueOf(script.getTimeout());
                }
            } else {
                String message = String.format("Component %s of service %s has not command script defined", componentName, serviceName);
                throw new OBDPException(message);
            }
        }
        commandParams.put("command_timeout", commandTimeout);
        commandParams.put("service_package_folder", serviceInfo.getServicePackageFolder());
        commandParams.put("hooks_folder", this.configuration.getProperty(Configuration.HOOKS_FOLDER));
        Map<String, String> hostLevelParams = statusCmd.getHostLevelParams();
        hostLevelParams.put("jdk_location", this.ambariManagementController.getJdkResourceUrl());
        hostLevelParams.put("stack_name", stackId.getStackName());
        hostLevelParams.put("stack_version", stackId.getStackVersion());
        if (statusCmd.getPayloadLevel() == StatusCommand.StatusCommandPayload.EXECUTION_COMMAND) {
            ExecutionCommand ec = this.ambariManagementController.getExecutionCommand(cluster, sch, RoleCommand.START);
            statusCmd.setExecutionCommand(ec);
            LOG.debug("{} has more payload for execution command", (Object)componentName);
        }
        return statusCmd;
    }

    private void handleHeartbeatLost(Long hostId) throws OBDPException, InvalidStateTransitionException {
        Host hostObj = this.clusters.getHostById(hostId);
        String host = hostObj.getHostName();
        LOG.warn("Heartbeat lost from host " + host);
        hostObj.handleEvent(new HostHeartbeatLostEvent(host));
        for (Cluster cluster : this.clusters.getClustersForHost(hostObj.getHostName())) {
            for (ServiceComponentHost sch : cluster.getServiceComponentHosts(hostObj.getHostName())) {
                Service s = cluster.getService(sch.getServiceName());
                ServiceComponent sc = s.getServiceComponent(sch.getServiceComponentName());
                if (sc.isClientComponent() || sch.getState().equals((Object)State.INIT) || sch.getState().equals((Object)State.INSTALLING) || sch.getState().equals((Object)State.INSTALL_FAILED) || sch.getState().equals((Object)State.UNINSTALLED) || sch.getState().equals((Object)State.DISABLED)) continue;
                LOG.warn("Setting component state to UNKNOWN for component " + sc.getName() + " on " + host);
                State oldState = sch.getState();
                sch.setState(State.UNKNOWN);
            }
        }
        this.actionManager.handleLostHost(host);
    }

    @Subscribe
    public void onMessageNotDelivered(MessageNotDelivered messageNotDelivered) {
        try {
            Host hostObj = this.clusters.getHostById(messageNotDelivered.getHostId());
            if (hostObj.getState() == HostState.HEARTBEAT_LOST) {
                return;
            }
            this.handleHeartbeatLost(messageNotDelivered.getHostId());
        }
        catch (Exception e) {
            LOG.error("Error during host to heartbeat lost moving", (Throwable)e);
        }
    }
}

