/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import id.onyx.obdp.server.HostNotFoundException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.ActionManager;
import id.onyx.obdp.server.agent.AgentSessionManager;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.agent.ComponentStatus;
import id.onyx.obdp.server.agent.ComponentsResponse;
import id.onyx.obdp.server.agent.HeartBeat;
import id.onyx.obdp.server.agent.HeartBeatResponse;
import id.onyx.obdp.server.agent.HeartbeatMonitor;
import id.onyx.obdp.server.agent.HeartbeatProcessor;
import id.onyx.obdp.server.agent.RecoveryReport;
import id.onyx.obdp.server.agent.Register;
import id.onyx.obdp.server.agent.RegistrationCommand;
import id.onyx.obdp.server.agent.RegistrationResponse;
import id.onyx.obdp.server.agent.stomp.dto.ComponentVersionReports;
import id.onyx.obdp.server.agent.stomp.dto.HostStatusReport;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.events.AgentActionEvent;
import id.onyx.obdp.server.events.AgentConfigsUpdateEvent;
import id.onyx.obdp.server.events.EncryptionKeyUpdateEvent;
import id.onyx.obdp.server.events.HostRegisteredEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.security.encryption.Encryptor;
import id.onyx.obdp.server.state.AgentVersion;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.HostState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.alert.AlertHelper;
import id.onyx.obdp.server.state.fsm.InvalidStateTransitionException;
import id.onyx.obdp.server.state.host.HostHealthyHeartbeatEvent;
import id.onyx.obdp.server.state.host.HostRegistrationRequestEvent;
import id.onyx.obdp.server.state.host.HostStatusUpdatesReceivedEvent;
import id.onyx.obdp.server.utils.VersionUtils;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HeartBeatHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HeartBeatHandler.class);
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private final Clusters clusterFsm;
    private final Encryptor<AgentConfigsUpdateEvent> encryptor;
    private HeartbeatMonitor heartbeatMonitor;
    private HeartbeatProcessor heartbeatProcessor;
    private Configuration config;
    @Inject
    private OBDPMetaInfo obdpMetaInfo;
    @Inject
    private STOMPUpdatePublisher STOMPUpdatePublisher;
    @Inject
    private AgentSessionManager agentSessionManager;
    @Inject
    private OBDPEventPublisher ambariEventPublisher;
    @Inject
    private AlertHelper alertHelper;
    private Map<String, Long> hostResponseIds = new ConcurrentHashMap<String, Long>();
    private Map<String, HeartBeatResponse> hostResponses = new ConcurrentHashMap<String, HeartBeatResponse>();

    @Inject
    public HeartBeatHandler(Configuration c, Clusters fsm, ActionManager am, @Named(value="AgentConfigEncryptor") Encryptor<AgentConfigsUpdateEvent> encryptor, Injector injector) {
        this.config = c;
        this.clusterFsm = fsm;
        this.encryptor = encryptor;
        this.heartbeatMonitor = new HeartbeatMonitor(fsm, am, this.config.getHeartbeatMonitorInterval(), injector);
        this.heartbeatProcessor = new HeartbeatProcessor(fsm, am, this.heartbeatMonitor, injector);
        injector.injectMembers((Object)this);
    }

    public void start() {
        this.heartbeatProcessor.startAsync();
        this.heartbeatMonitor.start();
    }

    void setHeartbeatMonitor(HeartbeatMonitor heartbeatMonitor) {
        this.heartbeatMonitor = heartbeatMonitor;
    }

    public void setHeartbeatProcessor(HeartbeatProcessor heartbeatProcessor) {
        this.heartbeatProcessor = heartbeatProcessor;
    }

    public HeartbeatProcessor getHeartbeatProcessor() {
        return this.heartbeatProcessor;
    }

    public HeartBeatResponse handleHeartBeat(HeartBeat heartbeat) throws OBDPException {
        Host hostObject;
        String hostname;
        Long currentResponseId;
        long now = System.currentTimeMillis();
        if (heartbeat.getAgentEnv() != null && heartbeat.getAgentEnv().getHostHealth() != null) {
            heartbeat.getAgentEnv().getHostHealth().setServerTimeStampAtReporting(now);
        }
        if ((currentResponseId = this.hostResponseIds.get(hostname = heartbeat.getHostname())) == null) {
            LOG.error("CurrentResponseId unknown for " + hostname + " - send register command");
            return this.createRegisterCommand();
        }
        LOG.debug("Received heartbeat from host, hostname={}, currentResponseId={}, receivedResponseId={}", new Object[]{hostname, currentResponseId, heartbeat.getResponseId()});
        HeartBeatResponse response = new HeartBeatResponse();
        try {
            hostObject = this.clusterFsm.getHost(hostname);
        }
        catch (HostNotFoundException e) {
            LOG.error("Host: {} not found. Agent is still heartbeating.", (Object)hostname);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Host associated with the agent heratbeat might have been deleted", (Throwable)((Object)e));
            }
            return response;
        }
        if (heartbeat.getResponseId() == currentResponseId - 1L) {
            HeartBeatResponse heartBeatResponse = this.hostResponses.get(hostname);
            LOG.warn("Old responseId={} received form host {} - response was lost - returning cached response with responseId={}", new Object[]{heartbeat.getResponseId(), hostname, heartBeatResponse.getResponseId()});
            return heartBeatResponse;
        }
        if (heartbeat.getResponseId() != currentResponseId.longValue()) {
            LOG.error("Error in responseId sequence - received responseId={} from host {} - sending agent restart command with responseId={}", new Object[]{heartbeat.getResponseId(), hostname, currentResponseId});
            return this.createRestartCommand(currentResponseId);
        }
        currentResponseId = currentResponseId + 1L;
        response.setResponseId(currentResponseId);
        if (hostObject.getState().equals((Object)HostState.HEARTBEAT_LOST)) {
            LOG.warn("Host {} is in HEARTBEAT_LOST state - sending register command", (Object)hostname);
            this.STOMPUpdatePublisher.publish(new AgentActionEvent(AgentActionEvent.AgentAction.RESTART_AGENT, hostObject.getHostId()));
            return this.createRegisterCommand();
        }
        this.hostResponseIds.put(hostname, currentResponseId);
        this.hostResponses.put(hostname, response);
        if (hostObject.getState().equals((Object)HostState.WAITING_FOR_HOST_STATUS_UPDATES)) {
            try {
                LOG.debug("Got component status updates for host {}", (Object)hostname);
                hostObject.handleEvent(new HostStatusUpdatesReceivedEvent(hostname, now));
            }
            catch (InvalidStateTransitionException e) {
                LOG.warn("Failed to notify the host {} about component status updates", (Object)hostname, (Object)e);
            }
        }
        if (heartbeat.getRecoveryReport() != null) {
            RecoveryReport rr = heartbeat.getRecoveryReport();
            this.processRecoveryReport(rr, hostname);
        }
        if (CollectionUtils.isNotEmpty(heartbeat.getStaleAlerts())) {
            this.alertHelper.addStaleAlerts(hostObject.getHostId(), heartbeat.getStaleAlerts());
        }
        try {
            hostObject.handleEvent(new HostHealthyHeartbeatEvent(hostname, now, heartbeat.getAgentEnv(), heartbeat.getMounts()));
        }
        catch (InvalidStateTransitionException ex) {
            LOG.warn("Asking agent to re-register due to " + ex.getMessage(), (Throwable)ex);
            hostObject.setState(HostState.INIT);
            return this.createRegisterCommand();
        }
        this.heartbeatProcessor.addHeartbeat(heartbeat);
        if (hostObject.getState().equals((Object)HostState.HEALTHY)) {
            this.annotateResponse(hostname, response);
        }
        return response;
    }

    public void handleComponentReportStatus(List<ComponentStatus> componentStatuses, String hostname) throws OBDPException {
        this.heartbeatProcessor.processStatusReports(componentStatuses, hostname);
        this.heartbeatProcessor.processHostStatus(componentStatuses, null, hostname);
    }

    public void handleCommandReportStatus(List<CommandReport> reports, String hostname) throws OBDPException {
        this.heartbeatProcessor.processCommandReports(reports, hostname, System.currentTimeMillis());
        this.heartbeatProcessor.processHostStatus(null, reports, hostname);
    }

    public void handleHostReportStatus(HostStatusReport hostStatusReport, String hostname) throws OBDPException {
        Host host = this.clusterFsm.getHost(hostname);
        try {
            host.handleEvent(new HostHealthyHeartbeatEvent(hostname, System.currentTimeMillis(), hostStatusReport.getAgentEnv(), hostStatusReport.getMounts()));
        }
        catch (InvalidStateTransitionException ex) {
            LOG.warn("Asking agent to re-register due to " + ex.getMessage(), (Throwable)ex);
            host.setState(HostState.INIT);
            this.agentSessionManager.unregisterByHost(host.getHostId());
        }
    }

    public void handleComponentVersionReports(ComponentVersionReports componentVersionReports, String hostname) throws OBDPException {
        this.heartbeatProcessor.processVersionReports(componentVersionReports, hostname);
    }

    protected void processRecoveryReport(RecoveryReport recoveryReport, String hostname) throws OBDPException {
        LOG.debug("Received recovery report: {}", (Object)recoveryReport);
        Host host = this.clusterFsm.getHost(hostname);
        host.setRecoveryReport(recoveryReport);
    }

    public String getOsType(String os, String osRelease) {
        String[] release;
        Object osType = "";
        if (os != null) {
            osType = os;
        }
        if (osRelease != null && (release = DOT_PATTERN.split(osRelease)).length > 0) {
            osType = (String)osType + release[0];
        }
        return ((String)osType).toLowerCase();
    }

    public HeartBeatResponse createRegisterCommand() {
        HeartBeatResponse response = new HeartBeatResponse();
        RegistrationCommand regCmd = new RegistrationCommand();
        response.setResponseId(0L);
        response.setRegistrationCommand(regCmd);
        return response;
    }

    protected HeartBeatResponse createRestartCommand(Long currentResponseId) {
        HeartBeatResponse response = new HeartBeatResponse();
        response.setRestartAgent(true);
        response.setResponseId(currentResponseId);
        return response;
    }

    public RegistrationResponse handleRegistration(Register register) throws InvalidStateTransitionException, OBDPException {
        Host hostObject;
        String hostname = register.getHostname();
        int currentPingPort = register.getCurrentPingPort();
        long now = System.currentTimeMillis();
        String agentVersion = register.getAgentVersion();
        String serverVersion = this.obdpMetaInfo.getServerVersion();
        if (!VersionUtils.areVersionsEqual((String)serverVersion, (String)agentVersion, (boolean)true)) {
            LOG.warn("Received registration request from host with non compatible agent version, hostname=" + hostname + ", agentVersion=" + agentVersion + ", serverVersion=" + serverVersion);
            throw new OBDPException("Cannot register host with non compatible agent version, hostname=" + hostname + ", agentVersion=" + agentVersion + ", serverVersion=" + serverVersion);
        }
        String agentOsType = this.getOsType(register.getHardwareProfile().getOS(), register.getHardwareProfile().getOSRelease());
        LOG.info("agentOsType = " + agentOsType);
        if (!this.obdpMetaInfo.isOsSupported(agentOsType)) {
            LOG.warn("Received registration request from host with not supported os type, hostname=" + hostname + ", serverOsType=" + this.config.getServerOsType() + ", agentOsType=" + agentOsType);
            throw new OBDPException("Cannot register host with not supported os type, hostname=" + hostname + ", serverOsType=" + this.config.getServerOsType() + ", agentOsType=" + agentOsType);
        }
        try {
            hostObject = this.clusterFsm.getHost(hostname);
        }
        catch (HostNotFoundException ex) {
            this.clusterFsm.addHost(hostname);
            hostObject = this.clusterFsm.getHost(hostname);
        }
        hostObject.setStateMachineState(HostState.INIT);
        hostObject.setCurrentPingPort(currentPingPort);
        hostObject.setPrefix(register.getPrefix());
        this.alertHelper.clearStaleAlerts(hostObject.getHostId());
        hostObject.handleEvent(new HostRegistrationRequestEvent(hostname, null != register.getPublicHostname() ? register.getPublicHostname() : hostname, new AgentVersion(register.getAgentVersion()), now, register.getHardwareProfile(), register.getAgentEnv(), register.getAgentStartTime()));
        HostRegisteredEvent event = new HostRegisteredEvent(hostname, hostObject.getHostId());
        this.ambariEventPublisher.publish(event);
        if (this.config.shouldEncryptSensitiveData()) {
            EncryptionKeyUpdateEvent encryptionKeyUpdateEvent = new EncryptionKeyUpdateEvent(this.encryptor.getEncryptionKey());
            this.STOMPUpdatePublisher.publish(encryptionKeyUpdateEvent);
        }
        RegistrationResponse response = new RegistrationResponse();
        Long requestId = 0L;
        this.hostResponseIds.put(hostname, requestId);
        response.setResponseId(requestId);
        return response;
    }

    private void annotateResponse(String hostname, HeartBeatResponse response) throws OBDPException {
        for (Cluster cl : this.clusterFsm.getClustersForHost(hostname)) {
            response.setClusterSize(cl.getClusterSize());
            List<ServiceComponentHost> scHosts = cl.getServiceComponentHosts(hostname);
            if (scHosts == null || scHosts.size() <= 0) continue;
            response.setHasMappedComponents(true);
            break;
        }
    }

    public ComponentsResponse handleComponents(String clusterName) throws OBDPException {
        ComponentsResponse response = new ComponentsResponse();
        Cluster cluster = this.clusterFsm.getCluster(clusterName);
        HashMap<String, Map<String, String>> componentsMap = new HashMap<String, Map<String, String>>();
        for (Service service : cluster.getServices().values()) {
            componentsMap.put(service.getName(), new HashMap());
            for (ServiceComponent component : service.getServiceComponents().values()) {
                StackId stackId = component.getDesiredStackId();
                ComponentInfo componentInfo = this.obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), service.getName(), component.getName());
                ((Map)componentsMap.get(service.getName())).put(component.getName(), componentInfo.getCategory());
            }
        }
        response.setClusterName(clusterName);
        response.setComponents(componentsMap);
        return response;
    }

    public void stop() {
        this.heartbeatMonitor.shutdown();
        this.heartbeatProcessor.stopAsync();
    }
}

