/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.agent.AgentCommand;
import id.onyx.obdp.server.agent.CommandRepository;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeSummary;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.utils.StageUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ExecutionCommand
extends AgentCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionCommand.class);
    @JsonProperty(value="clusterId")
    private String clusterId;
    @SerializedName(value="clusterName")
    @JsonProperty(value="clusterName")
    private String clusterName;
    @SerializedName(value="requestId")
    @JsonProperty(value="requestId")
    private long requestId;
    @SerializedName(value="stageId")
    @JsonIgnore
    private long stageId;
    @SerializedName(value="taskId")
    @JsonProperty(value="taskId")
    private long taskId;
    @SerializedName(value="commandId")
    @JsonProperty(value="commandId")
    private String commandId;
    @SerializedName(value="hostname")
    @JsonIgnore
    private String hostname;
    @SerializedName(value="role")
    @JsonProperty(value="role")
    private String role;
    @SerializedName(value="hostLevelParams")
    @JsonIgnore
    private Map<String, String> hostLevelParams = new HashMap<String, String>();
    @SerializedName(value="clusterLevelParams")
    private Map<String, String> clusterLevelParams = new HashMap<String, String>();
    @SerializedName(value="roleParams")
    @JsonProperty(value="roleParams")
    private Map<String, String> roleParams = null;
    @SerializedName(value="roleCommand")
    @JsonProperty(value="roleCommand")
    private RoleCommand roleCommand;
    @SerializedName(value="clusterHostInfo")
    private Map<String, Set<String>> clusterHostInfo = new HashMap<String, Set<String>>();
    @SerializedName(value="configurations")
    private Map<String, Map<String, String>> configurations;
    @SerializedName(value="forceRefreshConfigTagsBeforeExecution")
    @JsonIgnore
    private boolean overrideConfigs = false;
    @SerializedName(value="commandParams")
    @JsonProperty(value="commandParams")
    private Map<String, String> commandParams = new HashMap<String, String>();
    @SerializedName(value="serviceName")
    @JsonProperty(value="serviceName")
    private String serviceName;
    @SerializedName(value="serviceType")
    @JsonIgnore
    private String serviceType;
    @SerializedName(value="componentName")
    @JsonIgnore
    private String componentName;
    @SerializedName(value="kerberosCommandParams")
    @JsonProperty(value="kerberosCommandParams")
    private List<Map<String, String>> kerberosCommandParams = new ArrayList<Map<String, String>>();
    @SerializedName(value="localComponents")
    @JsonIgnore
    private Set<String> localComponents = new HashSet<String>();
    @SerializedName(value="availableServices")
    @JsonIgnore
    private Map<String, String> availableServices = new HashMap<String, String>();
    @SerializedName(value="credentialStoreEnabled")
    @JsonIgnore
    private String credentialStoreEnabled;
    @SerializedName(value="configuration_credentials")
    @JsonIgnore
    private Map<String, Map<String, String>> configurationCredentials;
    @SerializedName(value="repositoryFile")
    private CommandRepository commandRepository;
    @SerializedName(value="componentVersionMap")
    private Map<String, Map<String, String>> componentVersionMap = new HashMap<String, Map<String, String>>();
    @SerializedName(value="upgradeSummary")
    private UpgradeSummary upgradeSummary;
    @SerializedName(value="roleParameters")
    private Map<String, Object> roleParameters;
    @SerializedName(value="useLatestConfigs")
    private Boolean useLatestConfigs = null;

    public ExecutionCommand() {
        super(AgentCommand.AgentCommandType.EXECUTION_COMMAND);
    }

    public void setConfigurationCredentials(Map<String, Map<String, String>> configurationCredentials) {
        this.configurationCredentials = configurationCredentials;
    }

    public Map<String, Map<String, String>> getConfigurationCredentials() {
        return this.configurationCredentials;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public void setRequestAndStage(long requestId, long stageId) {
        this.requestId = requestId;
        this.stageId = stageId;
        this.commandId = StageUtils.getActionId(requestId, stageId);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ExecutionCommand)) {
            return false;
        }
        ExecutionCommand o = (ExecutionCommand)other;
        return this.commandId.equals(o.commandId) && this.hostname.equals(o.hostname) && this.role.equals(o.role) && this.roleCommand.equals((Object)o.roleCommand);
    }

    @Override
    public String toString() {
        try {
            return StageUtils.jaxbToString(this);
        }
        catch (Exception ex) {
            LOG.warn("Exception in json conversion", (Throwable)ex);
            return "Exception in json conversion";
        }
    }

    public int hashCode() {
        return (this.hostname + this.commandId + this.role).hashCode();
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Map<String, String> getRoleParams() {
        return this.roleParams;
    }

    public void setRoleParams(Map<String, String> roleParams) {
        this.roleParams = roleParams;
    }

    public RoleCommand getRoleCommand() {
        return this.roleCommand;
    }

    public void setRoleCommand(RoleCommand cmd) {
        this.roleCommand = cmd;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public Map<String, String> getHostLevelParams() {
        return this.hostLevelParams;
    }

    public void setHostLevelParams(Map<String, String> params) {
        this.hostLevelParams = params;
    }

    public Map<String, String> getClusterLevelParams() {
        return this.clusterLevelParams;
    }

    public void setClusterLevelParams(Map<String, String> clusterLevelParams) {
        this.clusterLevelParams = clusterLevelParams;
    }

    public Map<String, Set<String>> getClusterHostInfo() {
        return this.clusterHostInfo;
    }

    public void setClusterHostInfo(Map<String, Set<String>> clusterHostInfo) {
        this.clusterHostInfo = clusterHostInfo;
    }

    public Map<String, Map<String, String>> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Map<String, Map<String, String>> configurations) {
        this.configurations = configurations;
    }

    public boolean isOverrideConfigs() {
        return this.overrideConfigs;
    }

    public void setOverrideConfigs(boolean overrideConfigs) {
        this.overrideConfigs = overrideConfigs;
    }

    public Set<String> getLocalComponents() {
        return this.localComponents;
    }

    public void setLocalComponents(Set<String> localComponents) {
        this.localComponents = localComponents;
    }

    public Map<String, String> getCommandParams() {
        return this.commandParams;
    }

    public void setCommandParams(Map<String, String> commandParams) {
        this.commandParams = commandParams;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getCredentialStoreEnabled() {
        return this.credentialStoreEnabled;
    }

    public void setCredentialStoreEnabled(String credentialStoreEnabled) {
        this.credentialStoreEnabled = credentialStoreEnabled;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public List<Map<String, String>> getKerberosCommandParams() {
        return this.kerberosCommandParams;
    }

    public void setKerberosCommandParams(List<Map<String, String>> params) {
        this.kerberosCommandParams = params;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public CommandRepository getRepositoryFile() {
        return this.commandRepository;
    }

    public void setRepositoryFile(CommandRepository repository) {
        this.commandRepository = repository;
    }

    public Map<String, Object> getRoleParameters() {
        return this.roleParameters;
    }

    public void setRoleParameters(Map<String, Object> params) {
        this.roleParameters = params;
    }

    public Boolean getUseLatestConfigs() {
        return this.useLatestConfigs;
    }

    public void setUseLatestConfigs(Boolean useLatestConfigs) {
        this.useLatestConfigs = useLatestConfigs;
    }

    public Map<String, Map<String, String>> getComponentVersionMap() {
        return this.componentVersionMap;
    }

    public void setComponentVersions(Cluster cluster) throws OBDPException {
        this.componentVersionMap = cluster.getComponentVersionMap();
    }

    public void setUpgradeSummary(UpgradeSummary upgradeSummary) {
        this.upgradeSummary = upgradeSummary;
    }

    public UpgradeSummary getUpgradeSummary() {
        return this.upgradeSummary;
    }

    public static interface KeyNames {
        public static final String COMMAND_TIMEOUT = "command_timeout";
        public static final String SCRIPT = "script";
        public static final String SCRIPT_TYPE = "script_type";
        public static final String SERVICE_PACKAGE_FOLDER = "service_package_folder";
        public static final String HOOKS_FOLDER = "hooks_folder";
        public static final String CUSTOM_FOLDER = "custom_folder";
        public static final String STACK_NAME = "stack_name";
        public static final String SERVICE_TYPE = "service_type";
        public static final String STACK_VERSION = "stack_version";
        @Deprecated
        public static final String SERVICE_REPO_INFO = "service_repo_info";
        public static final String PACKAGE_LIST = "package_list";
        public static final String JDK_LOCATION = "jdk_location";
        public static final String JAVA_HOME = "java_home";
        public static final String GPL_LICENSE_ACCEPTED = "gpl_license_accepted";
        public static final String AMBARI_JAVA_HOME = "ambari_java_home";
        public static final String AMBARI_JDK_NAME = "ambari_jdk_name";
        public static final String AMBARI_JCE_NAME = "ambari_jce_name";
        public static final String AMBARI_JAVA_VERSION = "ambari_java_version";
        public static final String JAVA_VERSION = "java_version";
        public static final String JDK_NAME = "jdk_name";
        public static final String JCE_NAME = "jce_name";
        public static final String UNLIMITED_KEY_JCE_REQUIRED = "unlimited_key_jce_required";
        public static final String MYSQL_JDBC_URL = "mysql_jdbc_url";
        public static final String ORACLE_JDBC_URL = "oracle_jdbc_url";
        public static final String DB_DRIVER_FILENAME = "db_driver_filename";
        public static final String CLIENTS_TO_UPDATE_CONFIGS = "clientsToUpdateConfigs";
        public static final String DB_NAME = "db_name";
        public static final String GLOBAL = "global";
        public static final String AMBARI_DB_RCA_URL = "ambari_db_rca_url";
        public static final String AMBARI_DB_RCA_DRIVER = "ambari_db_rca_driver";
        public static final String AMBARI_DB_RCA_USERNAME = "ambari_db_rca_username";
        public static final String AMBARI_DB_RCA_PASSWORD = "ambari_db_rca_password";
        public static final String COMPONENT_CATEGORY = "component_category";
        public static final String USER_LIST = "user_list";
        public static final String GROUP_LIST = "group_list";
        public static final String USER_GROUPS = "user_groups";
        public static final String BLUEPRINT_PROVISIONING_STATE = "blueprint_provisioning_state";
        public static final String NOT_MANAGED_HDFS_PATH_LIST = "not_managed_hdfs_path_list";
        public static final String REFRESH_TOPOLOGY = "refresh_topology";
        public static final String HOST_SYS_PREPPED = "host_sys_prepped";
        public static final String MAX_DURATION_OF_RETRIES = "max_duration_for_retries";
        public static final String COMMAND_RETRY_ENABLED = "command_retry_enabled";
        public static final String AGENT_STACK_RETRY_ON_UNAVAILABILITY = "agent_stack_retry_on_unavailability";
        public static final String AGENT_STACK_RETRY_COUNT = "agent_stack_retry_count";
        public static final String LOG_OUTPUT = "log_output";
        public static final String DFS_TYPE = "dfs_type";
        public static final String OVERRIDE_CONFIGS = "overrideConfigs";
        public static final String OVERRIDE_STACK_NAME = "overrideStackName";
        public static final String SERVICE_CHECK = "SERVICE_CHECK";
        public static final String CUSTOM_COMMAND = "custom_command";
        @Deprecated
        public static final String PACKAGE_VERSION = "package_version";
        public static final String UPGRADE_SUSPENDED = "upgrade_suspended";
        @Deprecated
        public static final String REPO_VERSION_ID = "repository_version_id";
        public static final String CLUSTER_NAME = "cluster_name";
        public static final String VERSION = "version";
        public static final String CLUSTER_VERSION_SUMMARY = "cluster_version_summary";
    }
}

