/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import id.onyx.obdp.server.orm.entities.RepoDefinitionEntity;
import id.onyx.obdp.server.state.RepositoryInfo;
import id.onyx.obdp.server.state.stack.RepoTag;
import id.onyx.obdp.server.utils.URLCredentialsHider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class CommandRepository {
    @SerializedName(value="repositories")
    @JsonProperty(value="repositories")
    private List<Repository> m_repositories = new ArrayList<Repository>();
    @SerializedName(value="repoVersion")
    @JsonProperty(value="repoVersion")
    private String m_repoVersion;
    @SerializedName(value="repoVersionId")
    @JsonProperty(value="repoVersionId")
    private long m_repoVersionId;
    @SerializedName(value="stackName")
    @JsonProperty(value="stackName")
    private String m_stackName;
    @SerializedName(value="repoFileName")
    @JsonProperty(value="repoFileName")
    private String m_repoFileName;
    @SerializedName(value="feature")
    @JsonProperty(value="feature")
    private final CommandRepositoryFeature feature = new CommandRepositoryFeature();
    @SerializedName(value="resolved")
    @JsonProperty(value="resolved")
    private boolean m_resolved;

    public CommandRepositoryFeature getFeature() {
        return this.feature;
    }

    public void setRepoVersion(String version) {
        this.m_repoVersion = version;
    }

    public String getRepoVersion() {
        return this.m_repoVersion;
    }

    public void setRepositoryVersionId(long id) {
        this.m_repoVersionId = id;
    }

    public void setStackName(String name) {
        this.m_stackName = name;
    }

    public void setRepositories(Collection<RepositoryInfo> repositories) {
        this.m_repositories = new ArrayList<Repository>();
        for (RepositoryInfo info : repositories) {
            this.m_repositories.add(new Repository(info));
        }
    }

    public void setRepositories(String osType, Collection<RepoDefinitionEntity> repositories) {
        this.m_repositories = new ArrayList<Repository>();
        for (RepoDefinitionEntity entity : repositories) {
            this.m_repositories.add(new Repository(osType, entity));
        }
    }

    public Collection<Repository> getRepositories() {
        return this.m_repositories;
    }

    public void setUniqueSuffix(String suffix) {
        for (Repository repo : this.m_repositories) {
            repo.m_repoId = repo.m_repoId + suffix;
        }
    }

    public void setNonManaged() {
        for (Repository repo : this.m_repositories) {
            repo.m_baseUrl = null;
            repo.m_mirrorsList = null;
            repo.m_ambariManaged = false;
        }
    }

    public long getRepoVersionId() {
        return this.m_repoVersionId;
    }

    public void setResolved(boolean resolved) {
        this.m_resolved = resolved;
    }

    @Deprecated
    public void setLegacyRepoId(String repoVersion) {
        for (Repository repo : this.m_repositories) {
            repo.m_repoId = String.format("%s-%s", repo.getRepoName(), repoVersion);
        }
    }

    @Deprecated
    public void setLegacyRepoFileName(String stackName, String repoVersion) {
        this.m_repoFileName = String.format("%s-%s", stackName, repoVersion);
    }

    public void setRepoFileName(String stackName, Long repoVersionId) {
        this.m_repoFileName = String.format("ambari-%s-%s", stackName.toLowerCase(), repoVersionId.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandRepository that = (CommandRepository)o;
        return this.m_repoVersionId == that.m_repoVersionId;
    }

    public int hashCode() {
        return (int)(this.m_repoVersionId ^ this.m_repoVersionId >>> 32);
    }

    public static class CommandRepositoryFeature {
        @SerializedName(value="preInstalled")
        @JsonProperty(value="preInstalled")
        private Boolean m_isPreInstalled = false;
        @SerializedName(value="scoped")
        @JsonProperty(value="scoped")
        private boolean m_isScoped = true;

        public void setIsScoped(boolean isScoped) {
            this.m_isScoped = isScoped;
        }

        public void setPreInstalled(String isPreInstalled) {
            this.m_isPreInstalled = isPreInstalled.equalsIgnoreCase("true");
        }
    }

    public static class Repository {
        @SerializedName(value="baseUrl")
        @JsonProperty(value="baseUrl")
        private String m_baseUrl;
        @SerializedName(value="repoId")
        @JsonProperty(value="repoId")
        private String m_repoId;
        @SerializedName(value="ambariManaged")
        @JsonProperty(value="ambariManaged")
        private boolean m_ambariManaged = true;
        @SerializedName(value="repoName")
        @JsonProperty(value="repoName")
        private final String m_repoName;
        @SerializedName(value="distribution")
        @JsonProperty(value="distribution")
        private final String m_distribution;
        @SerializedName(value="components")
        @JsonProperty(value="components")
        private final String m_components;
        @SerializedName(value="mirrorsList")
        @JsonProperty(value="mirrorsList")
        private String m_mirrorsList;
        @SerializedName(value="applicableServices")
        private List<String> m_applicableServices;
        @SerializedName(value="tags")
        @JsonProperty(value="tags")
        private Set<RepoTag> m_tags;
        private transient String m_osType;

        private Repository(RepositoryInfo info) {
            this.m_baseUrl = info.getBaseUrl();
            this.m_osType = info.getOsType();
            this.m_repoId = info.getRepoId();
            this.m_repoName = info.getRepoName();
            this.m_distribution = info.getDistribution();
            this.m_components = info.getComponents();
            this.m_mirrorsList = info.getMirrorsList();
            this.m_applicableServices = info.getApplicableServices();
            this.m_tags = info.getTags();
        }

        private Repository(String osType, RepoDefinitionEntity entity) {
            this.m_baseUrl = entity.getBaseUrl();
            this.m_repoId = entity.getRepoID();
            this.m_repoName = entity.getRepoName();
            this.m_distribution = entity.getDistribution();
            this.m_components = entity.getComponents();
            this.m_mirrorsList = entity.getMirrors();
            this.m_applicableServices = entity.getApplicableServices();
            this.m_osType = osType;
            this.m_tags = entity.getTags();
        }

        public void setRepoId(String repoId) {
            this.m_repoId = repoId;
        }

        public void setBaseUrl(String url) {
            this.m_baseUrl = url;
        }

        public String getRepoName() {
            return this.m_repoName;
        }

        public String getRepoId() {
            return this.m_repoId;
        }

        public String getBaseUrl() {
            return this.m_baseUrl;
        }

        public boolean isAmbariManaged() {
            return this.m_ambariManaged;
        }

        public void setApplicableServices(List<String> applicableServices) {
            this.m_applicableServices = applicableServices;
        }

        public List<String> getApplicableServices() {
            return this.m_applicableServices;
        }

        public String toString() {
            return new ToStringBuilder(null).append("os", (Object)this.m_osType).append("name", (Object)this.m_repoName).append("distribution", (Object)this.m_distribution).append("components", (Object)this.m_components).append("id", (Object)this.m_repoId).append("baseUrl", (Object)URLCredentialsHider.hideCredentials(this.m_baseUrl)).append("applicableServices", (Object)(this.m_applicableServices != null ? StringUtils.join(this.m_applicableServices, (String)",") : "")).toString();
        }
    }
}

