/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.AgentCommand;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import java.util.List;
import java.util.Map;

public class AlertDefinitionCommand
extends AgentCommand {
    @SerializedName(value="clusterName")
    private final String m_clusterName;
    @SerializedName(value="hostName")
    private final String m_hostName;
    @SerializedName(value="publicHostName")
    private final String m_publicHostName;
    @SerializedName(value="hash")
    private final String m_hash;
    @SerializedName(value="alertDefinitions")
    @JsonProperty(value="alertDefinitions")
    private final List<AlertDefinition> m_definitions;
    @SerializedName(value="configurations")
    @JsonProperty(value="configurations")
    private Map<String, Map<String, String>> m_configurations;

    public AlertDefinitionCommand(String clusterName, String hostName, String publicHostName, String hash, List<AlertDefinition> definitions) {
        super(AgentCommand.AgentCommandType.ALERT_DEFINITION_COMMAND);
        this.m_clusterName = clusterName;
        this.m_hostName = hostName;
        this.m_publicHostName = publicHostName;
        this.m_hash = hash;
        this.m_definitions = definitions;
    }

    @Override
    public AgentCommand.AgentCommandType getCommandType() {
        return AgentCommand.AgentCommandType.ALERT_DEFINITION_COMMAND;
    }

    public String getHash() {
        return this.m_hash;
    }

    public List<AlertDefinition> getAlertDefinitions() {
        return this.m_definitions;
    }

    @JsonProperty(value="clusterName")
    public String getClusterName() {
        return this.m_clusterName;
    }

    @JsonProperty(value="hostName")
    public String getHostName() {
        return this.m_hostName;
    }

    public void addConfigs(ConfigHelper configHelper, Cluster cluster) throws OBDPException {
        Map<String, Map<String, String>> configTags = configHelper.getEffectiveDesiredTags(cluster, this.m_hostName);
        Map<String, Map<String, String>> configurations = configHelper.getEffectiveConfigProperties(cluster, configTags);
        this.m_configurations = configurations;
    }
}

