/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent;

import com.google.common.base.Preconditions;
import com.google.inject.Singleton;
import id.onyx.obdp.server.HostNotRegisteredException;
import id.onyx.obdp.server.state.Host;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Singleton
public class AgentSessionManager {
    private final ConcurrentMap<String, Host> registeredHosts = new ConcurrentHashMap<String, Host>();
    private final ConcurrentMap<Long, String> registeredSessionIds = new ConcurrentHashMap<Long, String>();

    public void register(String sessionId, Host host) {
        Preconditions.checkNotNull((Object)sessionId);
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkNotNull((Object)host.getHostId());
        String oldSessionId = this.registeredSessionIds.put(host.getHostId(), sessionId);
        if (oldSessionId != null) {
            this.registeredHosts.remove(oldSessionId);
        }
        this.registeredHosts.put(sessionId, host);
    }

    public boolean isRegistered(String sessionId) {
        return this.registeredHosts.containsKey(sessionId);
    }

    public Host getHost(String sessionId) throws HostNotRegisteredException {
        Preconditions.checkNotNull((Object)sessionId);
        Host host = (Host)this.registeredHosts.get(sessionId);
        if (host != null) {
            return host;
        }
        throw HostNotRegisteredException.forSessionId(sessionId);
    }

    public String getSessionId(Long hostId) throws HostNotRegisteredException {
        Preconditions.checkNotNull((Object)hostId);
        String sessionId = (String)this.registeredSessionIds.get(hostId);
        if (sessionId != null) {
            return sessionId;
        }
        throw HostNotRegisteredException.forHostId(hostId);
    }

    public void unregisterByHost(Long hostId) {
        Preconditions.checkNotNull((Object)hostId);
        String sessionId = (String)this.registeredSessionIds.remove(hostId);
        if (sessionId != null) {
            this.registeredHosts.remove(sessionId);
        }
    }
}

