/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent;

import com.google.inject.Singleton;
import id.onyx.obdp.server.agent.HeartbeatMonitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AgentRequests {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatMonitor.class);
    private final Map<String, Map<String, Boolean>> requiresExecCmdDetails = new HashMap<String, Map<String, Boolean>>();
    private final Object _lock = new Object();

    public void setExecutionDetailsRequest(String host, String component, String requestExecutionCmd) {
        if (StringUtils.isNotBlank((String)requestExecutionCmd)) {
            Map<String, Boolean> perHostRequiresExecCmdDetails = this.getPerHostRequiresExecCmdDetails(host);
            if (Boolean.TRUE.toString().toUpperCase().equals(requestExecutionCmd.toUpperCase())) {
                LOG.info("Setting need for exec command to " + requestExecutionCmd + " for " + component);
                perHostRequiresExecCmdDetails.put(component, Boolean.TRUE);
            } else {
                perHostRequiresExecCmdDetails.put(component, Boolean.FALSE);
            }
        }
    }

    public Boolean shouldSendExecutionDetails(String host, String component) {
        Map<String, Boolean> perHostRequiresExecCmdDetails = this.getPerHostRequiresExecCmdDetails(host);
        if (perHostRequiresExecCmdDetails != null && perHostRequiresExecCmdDetails.containsKey(component)) {
            LOG.debug("Sending exec command details for {}", (Object)component);
            return perHostRequiresExecCmdDetails.get(component);
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Boolean> getPerHostRequiresExecCmdDetails(String host) {
        if (!this.requiresExecCmdDetails.containsKey(host)) {
            Object object = this._lock;
            synchronized (object) {
                if (!this.requiresExecCmdDetails.containsKey(host)) {
                    this.requiresExecCmdDetails.put(host, new HashMap());
                }
            }
        }
        return this.requiresExecCmdDetails.get(host);
    }

    public String toString() {
        return "requiresExecCmdDetails: " + this.requiresExecCmdDetails;
    }
}

