/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.persist.UnitOfWork;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.AgentReport;
import id.onyx.obdp.server.configuration.Configuration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AgentReportsProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AgentReportsProcessor.class);
    private final int poolSize;
    private final List<ExecutorService> executors;
    @Inject
    private UnitOfWork unitOfWork;

    public void addAgentReport(AgentReport agentReport) {
        int hash = agentReport.getHostName().hashCode();
        hash = hash == Integer.MIN_VALUE ? 0 : hash;
        int executorNumber = Math.abs(hash) % this.poolSize;
        this.executors.get(executorNumber).execute(new AgentReportProcessingTask(agentReport));
    }

    @Inject
    public AgentReportsProcessor(Configuration configuration) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("agent-report-processor-%d").build();
        this.poolSize = configuration.getAgentsReportThreadPoolSize();
        this.executors = new ArrayList<ExecutorService>();
        for (int i = 0; i < this.poolSize; ++i) {
            this.executors.add(Executors.newSingleThreadExecutor(threadFactory));
        }
    }

    private class AgentReportProcessingTask
    implements Runnable {
        private final AgentReport agentReport;

        public AgentReportProcessingTask(AgentReport agentReport) {
            this.agentReport = agentReport;
        }

        @Override
        public void run() {
            try {
                AgentReportsProcessor.this.unitOfWork.begin();
                try {
                    this.agentReport.process();
                }
                catch (OBDPException e) {
                    LOG.error("Error processing agent reports", (Throwable)e);
                }
            }
            finally {
                AgentReportsProcessor.this.unitOfWork.end();
            }
        }
    }
}

