/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.OBDPRuntimeException;
import id.onyx.obdp.server.security.SecurePasswordHelper;
import id.onyx.obdp.server.security.credential.Credential;
import id.onyx.obdp.server.security.encryption.CredentialStoreService;
import id.onyx.obdp.server.security.encryption.CredentialStoreType;
import java.util.Arrays;

public class AgentEncryptionKey
implements Credential {
    private static final String ALIAS = "agent.encryption.key";
    private static final SecurePasswordHelper securePasswordHelper = new SecurePasswordHelper();
    private final char[] key;

    public static AgentEncryptionKey random() {
        return new AgentEncryptionKey(securePasswordHelper.createSecurePassword().toCharArray());
    }

    public static AgentEncryptionKey loadFrom(CredentialStoreService credentialStoreService, boolean createIfNotFound) {
        try {
            if (!credentialStoreService.containsCredential(null, ALIAS)) {
                if (createIfNotFound) {
                    AgentEncryptionKey encryptionKey = AgentEncryptionKey.random();
                    encryptionKey.saveToCredentialStore(credentialStoreService);
                    return AgentEncryptionKey.loadKey(credentialStoreService);
                }
                throw new OBDPRuntimeException("AgentEncryptionKey with alias: agent.encryption.key doesn't exist in credential store.");
            }
            return AgentEncryptionKey.loadKey(credentialStoreService);
        }
        catch (OBDPException e) {
            throw new OBDPRuntimeException("Cannot load agent encryption key: " + e.getMessage(), e);
        }
    }

    private static AgentEncryptionKey loadKey(CredentialStoreService credentialStoreService) throws OBDPException {
        return new AgentEncryptionKey(credentialStoreService.getCredential(null, ALIAS).toValue());
    }

    public AgentEncryptionKey(char[] key) {
        this.key = Arrays.copyOf(key, key.length);
    }

    public String toString() {
        return new String(this.key);
    }

    @Override
    public char[] toValue() {
        return this.key;
    }

    public void saveToCredentialStore(CredentialStoreService credentialStoreService) {
        try {
            credentialStoreService.setCredential(null, ALIAS, this, CredentialStoreType.PERSISTED);
        }
        catch (OBDPException e) {
            throw new OBDPRuntimeException("Cannot save agent encryption key: " + e.getMessage(), e);
        }
    }
}

