/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.actionmanager;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.Assisted;
import id.onyx.obdp.server.actionmanager.ActionDBAccessor;
import id.onyx.obdp.server.actionmanager.ExecutionCommandWrapperFactory;
import id.onyx.obdp.server.actionmanager.HostRoleCommandFactory;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.actionmanager.StageFactory;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.entities.StageEntity;
import id.onyx.obdp.server.state.Clusters;

@Singleton
public class StageFactoryImpl
implements StageFactory {
    private Injector injector;

    @Inject
    public StageFactoryImpl(Injector injector) {
        this.injector = injector;
    }

    @Override
    public Stage createNew(long requestId, @Assisted(value="logDir") String logDir, @Assisted(value="clusterName") String clusterName, @Assisted(value="clusterId") long clusterId, @Assisted(value="requestContext") String requestContext, @Assisted(value="commandParamsStage") String commandParamsStage, @Assisted(value="hostParamsStage") String hostParamsStage) {
        return new Stage(requestId, logDir, clusterName, clusterId, requestContext, commandParamsStage, hostParamsStage, (HostRoleCommandFactory)this.injector.getInstance(HostRoleCommandFactory.class), (ExecutionCommandWrapperFactory)this.injector.getInstance(ExecutionCommandWrapperFactory.class));
    }

    @Override
    public Stage createExisting(@Assisted StageEntity stageEntity) {
        return new Stage(stageEntity, (HostRoleCommandDAO)this.injector.getInstance(HostRoleCommandDAO.class), (ActionDBAccessor)this.injector.getInstance(ActionDBAccessor.class), (Clusters)this.injector.getInstance(Clusters.class), (HostRoleCommandFactory)this.injector.getInstance(HostRoleCommandFactory.class), (ExecutionCommandWrapperFactory)this.injector.getInstance(ExecutionCommandWrapperFactory.class));
    }
}

