/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.actionmanager;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.actionmanager.ActionDBAccessor;
import id.onyx.obdp.server.actionmanager.CommandExecutionType;
import id.onyx.obdp.server.actionmanager.ExecutionCommandWrapper;
import id.onyx.obdp.server.actionmanager.ExecutionCommandWrapperFactory;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleCommandFactory;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.actionmanager.ServiceComponentHostEventWrapper;
import id.onyx.obdp.server.agent.AgentCommand;
import id.onyx.obdp.server.agent.ExecutionCommand;
import id.onyx.obdp.server.metadata.RoleCommandPair;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.RoleSuccessCriteriaEntity;
import id.onyx.obdp.server.orm.entities.StageEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.ServiceComponentHostEvent;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostServerActionEvent;
import id.onyx.obdp.server.utils.StageUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class Stage {
    public static final String INTERNAL_HOSTNAME = "_internal_ambari";
    private static final Logger LOG = LoggerFactory.getLogger(Stage.class);
    private final long requestId;
    private String clusterName;
    private long clusterId = -1L;
    private long stageId = -1L;
    private final String logDir;
    private final String requestContext;
    private HostRoleStatus status = HostRoleStatus.PENDING;
    private HostRoleStatus displayStatus = HostRoleStatus.PENDING;
    private String commandParamsStage;
    private String hostParamsStage;
    private CommandExecutionType commandExecutionType = CommandExecutionType.STAGE;
    private boolean skippable;
    private boolean supportsAutoSkipOnFailure;
    private int stageTimeout = -1;
    private volatile boolean wrappersLoaded = false;
    private Map<Role, Float> successFactors = new HashMap<Role, Float>();
    Map<String, Map<String, HostRoleCommand>> hostRoleCommands = new TreeMap<String, Map<String, HostRoleCommand>>();
    private Map<String, List<ExecutionCommandWrapper>> commandsToSend = new TreeMap<String, List<ExecutionCommandWrapper>>();
    @Inject
    private HostRoleCommandFactory hostRoleCommandFactory;
    @Inject
    private ExecutionCommandWrapperFactory ecwFactory;

    @AssistedInject
    public Stage(@Assisted long requestId, @Assisted(value="logDir") String logDir, @Assisted(value="clusterName") @Nullable String clusterName, @Assisted(value="clusterId") long clusterId, @Assisted(value="requestContext") @Nullable String requestContext, @Assisted(value="commandParamsStage") String commandParamsStage, @Assisted(value="hostParamsStage") String hostParamsStage, HostRoleCommandFactory hostRoleCommandFactory, ExecutionCommandWrapperFactory ecwFactory) {
        this.wrappersLoaded = true;
        this.requestId = requestId;
        this.logDir = logDir;
        this.clusterName = clusterName;
        this.clusterId = clusterId;
        this.requestContext = requestContext == null ? "" : requestContext;
        this.commandParamsStage = commandParamsStage;
        this.hostParamsStage = hostParamsStage;
        this.skippable = false;
        this.supportsAutoSkipOnFailure = false;
        this.hostRoleCommandFactory = hostRoleCommandFactory;
        this.ecwFactory = ecwFactory;
    }

    @AssistedInject
    public Stage(@Assisted StageEntity stageEntity, HostRoleCommandDAO hostRoleCommandDAO, ActionDBAccessor dbAccessor, Clusters clusters, HostRoleCommandFactory hostRoleCommandFactory, ExecutionCommandWrapperFactory ecwFactory) {
        this.hostRoleCommandFactory = hostRoleCommandFactory;
        this.ecwFactory = ecwFactory;
        this.requestId = stageEntity.getRequestId();
        this.stageId = stageEntity.getStageId();
        this.skippable = stageEntity.isSkippable();
        this.supportsAutoSkipOnFailure = stageEntity.isAutoSkipOnFailureSupported();
        this.logDir = stageEntity.getLogInfo();
        this.clusterId = stageEntity.getClusterId();
        if (-1L != this.clusterId) {
            try {
                this.clusterName = clusters.getClusterById(this.clusterId).getClusterName();
            }
            catch (Exception e) {
                LOG.debug("Could not load cluster with id {}, the cluster may have been removed for stage {}", (Object)this.clusterId, (Object)this.stageId);
            }
        }
        this.requestContext = stageEntity.getRequestContext();
        this.commandParamsStage = stageEntity.getCommandParamsStage();
        this.hostParamsStage = stageEntity.getHostParamsStage();
        this.commandExecutionType = stageEntity.getCommandExecutionType();
        this.status = stageEntity.getStatus();
        this.displayStatus = stageEntity.getDisplayStatus();
        List<Long> taskIds = hostRoleCommandDAO.findTaskIdsByStage(this.requestId, this.stageId);
        Collection<HostRoleCommand> commands = dbAccessor.getTasks(taskIds);
        for (HostRoleCommand command : commands) {
            String hostname = Stage.getSafeHost(command.getHostName());
            if (!this.hostRoleCommands.containsKey(hostname)) {
                this.hostRoleCommands.put(hostname, new LinkedHashMap());
            }
            this.hostRoleCommands.get(hostname).put(command.getRole().toString(), command);
        }
        for (RoleSuccessCriteriaEntity successCriteriaEntity : stageEntity.getRoleSuccessCriterias()) {
            this.successFactors.put(successCriteriaEntity.getRole(), Float.valueOf(successCriteriaEntity.getSuccessFactor().floatValue()));
        }
    }

    public synchronized StageEntity constructNewPersistenceEntity() {
        StageEntity stageEntity = new StageEntity();
        stageEntity.setRequestId(this.requestId);
        stageEntity.setStageId(this.getStageId());
        stageEntity.setLogInfo(this.logDir);
        stageEntity.setSkippable(this.skippable);
        stageEntity.setAutoSkipFailureSupported(this.supportsAutoSkipOnFailure);
        stageEntity.setRequestContext(this.requestContext);
        stageEntity.setHostRoleCommands(new ArrayList<HostRoleCommandEntity>());
        stageEntity.setRoleSuccessCriterias(new ArrayList<RoleSuccessCriteriaEntity>());
        stageEntity.setCommandParamsStage(this.commandParamsStage);
        if (null != this.hostParamsStage) {
            stageEntity.setHostParamsStage(this.hostParamsStage);
        }
        stageEntity.setCommandExecutionType(this.commandExecutionType);
        stageEntity.setStatus(this.status);
        stageEntity.setDisplayStatus(this.displayStatus);
        for (Role role : this.successFactors.keySet()) {
            RoleSuccessCriteriaEntity roleSuccessCriteriaEntity = new RoleSuccessCriteriaEntity();
            roleSuccessCriteriaEntity.setRole(role);
            roleSuccessCriteriaEntity.setStage(stageEntity);
            roleSuccessCriteriaEntity.setSuccessFactor(this.successFactors.get(role).doubleValue());
            stageEntity.getRoleSuccessCriterias().add(roleSuccessCriteriaEntity);
        }
        return stageEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkWrappersLoaded() {
        if (!this.wrappersLoaded) {
            Stage stage = this;
            synchronized (stage) {
                if (!this.wrappersLoaded) {
                    this.loadExecutionCommandWrappers();
                }
            }
        }
    }

    @Transactional
    void loadExecutionCommandWrappers() {
        for (Map.Entry<String, Map<String, HostRoleCommand>> hostRoleCommandEntry : this.hostRoleCommands.entrySet()) {
            String hostname = hostRoleCommandEntry.getKey();
            ArrayList<ExecutionCommandWrapper> wrappers = new ArrayList<ExecutionCommandWrapper>();
            Map<String, HostRoleCommand> roleCommandMap = hostRoleCommandEntry.getValue();
            for (Map.Entry<String, HostRoleCommand> roleCommandEntry : roleCommandMap.entrySet()) {
                wrappers.add(roleCommandEntry.getValue().getExecutionCommandWrapper());
            }
            this.commandsToSend.put(hostname, wrappers);
        }
    }

    public List<HostRoleCommand> getOrderedHostRoleCommands() {
        ArrayList<HostRoleCommand> commands = new ArrayList<HostRoleCommand>();
        for (Map.Entry<String, Map<String, HostRoleCommand>> hostRoleCommandEntry : this.hostRoleCommands.entrySet()) {
            for (Map.Entry<String, HostRoleCommand> roleCommandEntry : hostRoleCommandEntry.getValue().entrySet()) {
                commands.add(roleCommandEntry.getValue());
            }
        }
        return commands;
    }

    public Set<RoleCommandPair> getHostRolesInProgress() {
        HashSet<RoleCommandPair> commandsToScheduleSet = new HashSet<RoleCommandPair>();
        for (Map.Entry<String, Map<String, HostRoleCommand>> hostRoleCommandEntry : this.hostRoleCommands.entrySet()) {
            for (Map.Entry<String, HostRoleCommand> roleCommandEntry : hostRoleCommandEntry.getValue().entrySet()) {
                if (!HostRoleStatus.IN_PROGRESS_STATUSES.contains((Object)roleCommandEntry.getValue().getStatus())) continue;
                commandsToScheduleSet.add(new RoleCommandPair(roleCommandEntry.getValue().getRole(), roleCommandEntry.getValue().getRoleCommand()));
            }
        }
        return commandsToScheduleSet;
    }

    public String getCommandParamsStage() {
        return this.commandParamsStage;
    }

    public void setCommandParamsStage(String commandParamsStage) {
        this.commandParamsStage = commandParamsStage;
    }

    public String getHostParamsStage() {
        return this.hostParamsStage;
    }

    public void setHostParamsStage(String hostParamsStage) {
        this.hostParamsStage = hostParamsStage;
    }

    public CommandExecutionType getCommandExecutionType() {
        return this.commandExecutionType;
    }

    public void setCommandExecutionType(CommandExecutionType commandExecutionType) {
        this.commandExecutionType = commandExecutionType;
    }

    public HostRoleStatus getStatus() {
        return this.status;
    }

    public void setStatus(HostRoleStatus status) {
        this.status = status;
    }

    public synchronized void setStageId(long stageId) {
        if (this.stageId != -1L) {
            throw new RuntimeException("Attempt to set stageId again! Not allowed.");
        }
        this.stageId = stageId;
        for (String host : this.commandsToSend.keySet()) {
            for (ExecutionCommandWrapper wrapper : this.commandsToSend.get(host)) {
                ExecutionCommand cmd = wrapper.getExecutionCommand();
                cmd.setRequestAndStage(this.requestId, stageId);
            }
        }
    }

    public synchronized long getStageId() {
        return this.stageId;
    }

    public String getActionId() {
        return StageUtils.getActionId(this.requestId, this.getStageId());
    }

    private synchronized ExecutionCommandWrapper addGenericExecutionCommand(String clusterName, String hostName, Role role, RoleCommand command, ServiceComponentHostEvent event, boolean retryAllowed, boolean autoSkipFailure) {
        boolean isHostRoleCommandAutoSkippable = autoSkipFailure && this.supportsAutoSkipOnFailure && this.skippable;
        HostRoleCommand hrc = this.hostRoleCommandFactory.create(hostName, role, event, command, retryAllowed, isHostRoleCommandAutoSkippable);
        return this.addGenericExecutionCommand(clusterName, hostName, role, command, event, hrc);
    }

    private ExecutionCommandWrapper addGenericExecutionCommand(Cluster cluster, Host host, Role role, RoleCommand command, ServiceComponentHostEvent event, boolean retryAllowed, boolean autoSkipFailure) {
        boolean isHostRoleCommandAutoSkippable = autoSkipFailure && this.supportsAutoSkipOnFailure && this.skippable;
        HostRoleCommand hrc = this.hostRoleCommandFactory.create(host, role, event, command, retryAllowed, isHostRoleCommandAutoSkippable);
        return this.addGenericExecutionCommand(cluster.getClusterName(), host.getHostName(), role, command, event, hrc);
    }

    private ExecutionCommandWrapper addGenericExecutionCommand(String clusterName, String hostName, Role role, RoleCommand command, ServiceComponentHostEvent event, HostRoleCommand hrc) {
        ExecutionCommand cmd = new ExecutionCommand();
        ExecutionCommandWrapper wrapper = this.ecwFactory.createFromCommand(cmd);
        hrc.setExecutionCommandWrapper(wrapper);
        cmd.setClusterId(Long.toString(this.clusterId));
        cmd.setHostname(hostName);
        cmd.setClusterName(clusterName);
        cmd.setRequestAndStage(this.requestId, this.stageId);
        cmd.setRole(role.name());
        cmd.setRoleCommand(command);
        cmd.setServiceName("");
        Map<String, HostRoleCommand> hrcMap = this.hostRoleCommands.get(hostName);
        if (hrcMap == null) {
            hrcMap = new LinkedHashMap<String, HostRoleCommand>();
            this.hostRoleCommands.put(hostName, hrcMap);
        }
        if (hrcMap.get(role.toString()) != null) {
            throw new RuntimeException("Setting the host role command second time for same stage: stage=" + this.getActionId() + ", host=" + hostName + ", role=" + role);
        }
        hrcMap.put(role.toString(), hrc);
        List<ExecutionCommandWrapper> execCmdList = this.commandsToSend.get(hostName);
        if (execCmdList == null) {
            execCmdList = new ArrayList<ExecutionCommandWrapper>();
            this.commandsToSend.put(hostName, execCmdList);
        }
        if (execCmdList.contains(wrapper)) {
            throw new RuntimeException("Setting the execution command second time for same stage: stage=" + this.getActionId() + ", host=" + hostName + ", role=" + role + ", event=" + event);
        }
        execCmdList.add(wrapper);
        return wrapper;
    }

    public synchronized void addHostRoleExecutionCommand(String host, Role role, RoleCommand command, ServiceComponentHostEvent event, String clusterName, String serviceName, boolean retryAllowed, boolean autoSkipFailure) {
        boolean isHostRoleCommandAutoSkippable = autoSkipFailure && this.supportsAutoSkipOnFailure && this.skippable;
        ExecutionCommandWrapper commandWrapper = this.addGenericExecutionCommand(clusterName, host, role, command, event, retryAllowed, isHostRoleCommandAutoSkippable);
        commandWrapper.getExecutionCommand().setServiceName(serviceName);
    }

    public synchronized void addHostRoleExecutionCommand(Host host, Role role, RoleCommand command, ServiceComponentHostEvent event, Cluster cluster, String serviceName, boolean retryAllowed, boolean autoSkipFailure) {
        boolean isHostRoleCommandAutoSkippable = autoSkipFailure && this.supportsAutoSkipOnFailure && this.skippable;
        ExecutionCommandWrapper commandWrapper = this.addGenericExecutionCommand(cluster, host, role, command, event, retryAllowed, isHostRoleCommandAutoSkippable);
        commandWrapper.getExecutionCommand().setServiceName(serviceName);
    }

    public synchronized void addServerActionCommand(String actionName, @Nullable String userName, Role role, RoleCommand command, String clusterName, ServiceComponentHostServerActionEvent event, @Nullable Map<String, String> commandParams, @Nullable String commandDetail, @Nullable Map<String, Map<String, String>> configTags, @Nullable Integer timeout, boolean retryAllowed, boolean autoSkipFailure) {
        HostRoleCommand hostRoleCommand;
        boolean isHostRoleCommandAutoSkippable = autoSkipFailure && this.supportsAutoSkipOnFailure && this.skippable;
        ExecutionCommandWrapper commandWrapper = this.addGenericExecutionCommand(clusterName, INTERNAL_HOSTNAME, role, command, (ServiceComponentHostEvent)event, retryAllowed, isHostRoleCommandAutoSkippable);
        ExecutionCommand cmd = commandWrapper.getExecutionCommand();
        HashMap<String, String> cmdParams = new HashMap<String, String>();
        if (commandParams != null) {
            cmdParams.putAll(commandParams);
        }
        if (timeout != null) {
            cmdParams.put("command_timeout", Long.toString(timeout.intValue()));
        }
        cmd.setCommandParams(cmdParams);
        cmd.setConfigurations(new TreeMap<String, Map<String, String>>());
        HashMap<String, String> roleParams = new HashMap<String, String>();
        roleParams.put("ACTION_NAME", actionName);
        if (userName != null) {
            roleParams.put("ACTION_USER_NAME", userName);
        }
        cmd.setRoleParams(roleParams);
        if (commandDetail != null && (hostRoleCommand = this.getHostRoleCommand(INTERNAL_HOSTNAME, role.toString())) != null) {
            hostRoleCommand.setCommandDetail(commandDetail);
            hostRoleCommand.setCustomCommandName(actionName);
        }
    }

    public synchronized void addCancelRequestCommand(List<Long> cancelTargets, String clusterName, String hostName) {
        ExecutionCommandWrapper commandWrapper = this.addGenericExecutionCommand(clusterName, hostName, Role.AMBARI_SERVER_ACTION, RoleCommand.ABORT, null, false, false);
        ExecutionCommand cmd = commandWrapper.getExecutionCommand();
        cmd.setCommandType(AgentCommand.AgentCommandType.CANCEL_COMMAND);
        Assert.notEmpty(cancelTargets, (String)"Provided targets task Id are empty.");
        HashMap<String, String> roleParams = new HashMap<String, String>();
        roleParams.put("cancelTaskIdTargets", StringUtils.join(cancelTargets, (char)','));
        cmd.setRoleParams(roleParams);
    }

    public synchronized List<String> getHosts() {
        return new ArrayList<String>(this.hostRoleCommands.keySet());
    }

    synchronized float getSuccessFactor(Role r) {
        Float f = this.successFactors.get(r);
        if (f == null) {
            if (r.equals(Role.DATANODE) || r.equals(Role.TASKTRACKER) || r.equals(Role.GANGLIA_MONITOR) || r.equals(Role.HBASE_REGIONSERVER)) {
                return 0.5f;
            }
            return 1.0f;
        }
        return f.floatValue();
    }

    public synchronized void setSuccessFactors(Map<Role, Float> suc) {
        this.successFactors = suc;
    }

    public synchronized Map<Role, Float> getSuccessFactors() {
        return this.successFactors;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public long getClusterId() {
        return this.clusterId;
    }

    public String getRequestContext() {
        return this.requestContext;
    }

    public long getLastAttemptTime(String hostname, String role) {
        return this.hostRoleCommands.get(Stage.getSafeHost(hostname)).get(role).getLastAttemptTime();
    }

    public short getAttemptCount(String hostname, String role) {
        return this.hostRoleCommands.get(Stage.getSafeHost(hostname)).get(role).getAttemptCount();
    }

    public void incrementAttemptCount(String hostname, String role) {
        this.hostRoleCommands.get(Stage.getSafeHost(hostname)).get(role).incrementAttemptCount();
    }

    public void setLastAttemptTime(String hostname, String role, long t) {
        this.hostRoleCommands.get(Stage.getSafeHost(hostname)).get(role).setLastAttemptTime(t);
    }

    public ExecutionCommandWrapper getExecutionCommandWrapper(String hostname, String role) {
        HostRoleCommand hrc = this.hostRoleCommands.get(Stage.getSafeHost(hostname)).get(role);
        if (hrc != null) {
            return hrc.getExecutionCommandWrapper();
        }
        return null;
    }

    public List<ExecutionCommandWrapper> getExecutionCommands(String hostname) {
        this.checkWrappersLoaded();
        return this.commandsToSend.get(Stage.getSafeHost(hostname));
    }

    public long getStartTime(String hostname, String role) {
        return this.hostRoleCommands.get(Stage.getSafeHost(hostname)).get(role).getStartTime();
    }

    public void setStartTime(String hostname, String role, long startTime) {
        this.hostRoleCommands.get(Stage.getSafeHost(hostname)).get(role).setStartTime(startTime);
    }

    public HostRoleStatus getHostRoleStatus(String hostname, String role) {
        return this.hostRoleCommands.get(Stage.getSafeHost(hostname)).get(role).getStatus();
    }

    public void setHostRoleStatus(String hostname, String role, HostRoleStatus status) {
        this.hostRoleCommands.get(Stage.getSafeHost(hostname)).get(role).setStatus(status);
    }

    public ServiceComponentHostEventWrapper getFsmEvent(String hostname, String roleStr) {
        return this.hostRoleCommands.get(Stage.getSafeHost(hostname)).get(roleStr).getEvent();
    }

    public void setExitCode(String hostname, String role, int exitCode) {
        this.hostRoleCommands.get(Stage.getSafeHost(hostname)).get(role).setExitCode(exitCode);
    }

    public int getExitCode(String hostname, String role) {
        return this.hostRoleCommands.get(Stage.getSafeHost(hostname)).get(role).getExitCode();
    }

    public void setStderr(String hostname, String role, String stdErr) {
        this.hostRoleCommands.get(Stage.getSafeHost(hostname)).get(role).setStderr(stdErr);
    }

    public void setStdout(String hostname, String role, String stdOut) {
        this.hostRoleCommands.get(Stage.getSafeHost(hostname)).get(role).setStdout(stdOut);
    }

    public synchronized boolean isStageInProgress() {
        for (String host : this.hostRoleCommands.keySet()) {
            for (String role : this.hostRoleCommands.get(host).keySet()) {
                HostRoleCommand hrc = this.hostRoleCommands.get(host).get(role);
                if (hrc == null) {
                    return false;
                }
                if (!hrc.getStatus().equals((Object)HostRoleStatus.PENDING) && !hrc.getStatus().equals((Object)HostRoleStatus.QUEUED) && !hrc.getStatus().equals((Object)HostRoleStatus.IN_PROGRESS)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean doesStageHaveHostRoleStatus(Set<HostRoleStatus> statuses) {
        for (String host : this.hostRoleCommands.keySet()) {
            for (String role : this.hostRoleCommands.get(host).keySet()) {
                HostRoleCommand hrc = this.hostRoleCommands.get(host).get(role);
                if (hrc == null) {
                    return false;
                }
                for (HostRoleStatus status : statuses) {
                    if (!hrc.getStatus().equals((Object)status)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Map<String, List<ExecutionCommandWrapper>> getExecutionCommands() {
        this.checkWrappersLoaded();
        return this.commandsToSend;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public Map<String, Map<String, HostRoleCommand>> getHostRoleCommands() {
        return this.hostRoleCommands;
    }

    public HostRoleCommand getHostRoleCommand(long taskId) {
        for (Map.Entry<String, Map<String, HostRoleCommand>> hostEntry : this.hostRoleCommands.entrySet()) {
            Map<String, HostRoleCommand> hostCommands = hostEntry.getValue();
            for (Map.Entry<String, HostRoleCommand> hostCommand : hostCommands.entrySet()) {
                HostRoleCommand hostRoleCommand = hostCommand.getValue();
                if (null == hostRoleCommand || hostRoleCommand.getTaskId() != taskId) continue;
                return hostRoleCommand;
            }
        }
        return null;
    }

    public synchronized void addExecutionCommandWrapper(Stage origStage, String hostname, Role r) {
        hostname = Stage.getSafeHost(hostname);
        String role = r.toString();
        if (this.commandsToSend.get(hostname) == null) {
            this.commandsToSend.put(hostname, new ArrayList());
        }
        this.commandsToSend.get(hostname).add(origStage.getExecutionCommandWrapper(hostname, role));
        if (this.hostRoleCommands.get(hostname) == null) {
            this.hostRoleCommands.put(hostname, new LinkedHashMap());
        }
        this.hostRoleCommands.get(hostname).put(role, origStage.getHostRoleCommand(hostname, role));
    }

    public HostRoleCommand getHostRoleCommand(String hostname, String role) {
        return this.hostRoleCommands.get(Stage.getSafeHost(hostname)).get(role);
    }

    public synchronized int getStageTimeout() {
        this.checkWrappersLoaded();
        if (this.stageTimeout == -1) {
            for (String host : this.commandsToSend.keySet()) {
                int summaryTaskTimeoutForHost = 0;
                for (ExecutionCommandWrapper command : this.commandsToSend.get(host)) {
                    Map<String, String> commandParams = command.getExecutionCommand().getCommandParams();
                    String timeoutKey = "command_timeout";
                    if (commandParams != null && commandParams.containsKey(timeoutKey)) {
                        String timeoutStr = commandParams.get(timeoutKey);
                        long commandTimeout = Long.parseLong(timeoutStr) * 1000L;
                        summaryTaskTimeoutForHost = (int)((long)summaryTaskTimeoutForHost + commandTimeout);
                        continue;
                    }
                    LOG.error("Execution command has no timeout parameter" + command);
                }
                if (summaryTaskTimeoutForHost <= this.stageTimeout) continue;
                this.stageTimeout = summaryTaskTimeoutForHost;
            }
        }
        return this.stageTimeout;
    }

    public boolean isSkippable() {
        return this.skippable;
    }

    public void setSkippable(boolean skippable) {
        this.skippable = skippable;
    }

    public boolean isAutoSkipOnFailureSupported() {
        return this.supportsAutoSkipOnFailure;
    }

    public void setAutoSkipFailureSupported(boolean supportsAutoSkipOnFailure) {
        this.supportsAutoSkipOnFailure = supportsAutoSkipOnFailure;
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("STAGE DESCRIPTION BEGIN\n");
        builder.append("requestId=").append(this.requestId).append("\n");
        builder.append("stageId=").append(this.stageId).append("\n");
        builder.append("clusterName=").append(this.clusterName).append("\n");
        builder.append("logDir=").append(this.logDir).append("\n");
        builder.append("requestContext=").append(this.requestContext).append("\n");
        builder.append("commandParamsStage=").append(this.commandParamsStage).append("\n");
        builder.append("hostParamsStage=").append(this.hostParamsStage).append("\n");
        builder.append("status=").append((Object)this.status).append("\n");
        builder.append("displayStatus=").append((Object)this.displayStatus).append("\n");
        builder.append("Success Factors:\n");
        for (Role r : this.successFactors.keySet()) {
            builder.append("  role: ").append(r).append(", factor: ").append(this.successFactors.get(r)).append("\n");
        }
        for (HostRoleCommand hostRoleCommand : this.getOrderedHostRoleCommands()) {
            builder.append("HOST: ").append(hostRoleCommand.getHostName()).append(" :\n");
            builder.append(hostRoleCommand.getExecutionCommandWrapper().getJson());
            builder.append("\n");
            builder.append(hostRoleCommand);
            builder.append("\n");
        }
        builder.append("STAGE DESCRIPTION END\n");
        return builder.toString();
    }

    private static String getSafeHost(String hostname) {
        return null == hostname ? INTERNAL_HOSTNAME : hostname;
    }
}

