/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.actionmanager;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.actionmanager.RequestType;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.actionmanager.StageFactory;
import id.onyx.obdp.server.controller.ExecuteActionRequest;
import id.onyx.obdp.server.controller.internal.RequestOperationLevel;
import id.onyx.obdp.server.controller.internal.RequestResourceFilter;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.RequestEntity;
import id.onyx.obdp.server.orm.entities.RequestOperationLevelEntity;
import id.onyx.obdp.server.orm.entities.RequestResourceFilterEntity;
import id.onyx.obdp.server.orm.entities.StageEntity;
import id.onyx.obdp.server.state.Clusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class Request {
    private static final Logger LOG = LoggerFactory.getLogger(Request.class);
    private final long requestId;
    private long clusterId;
    private String clusterName;
    private Long requestScheduleId;
    private String commandName;
    private String requestContext;
    private long createTime;
    private long startTime;
    private long endTime;
    private String clusterHostInfo;
    private String userName;
    private boolean exclusive;
    private HostRoleStatus status = HostRoleStatus.PENDING;
    private HostRoleStatus displayStatus = HostRoleStatus.PENDING;
    private String inputs;
    private List<RequestResourceFilter> resourceFilters;
    private RequestOperationLevel operationLevel;
    private RequestType requestType;
    private Collection<Stage> stages = new ArrayList<Stage>();
    @Inject
    private static HostDAO hostDAO;

    @AssistedInject
    public Request(@Assisted long requestId, @Assisted(value="clusterId") Long clusterId, Clusters clusters) {
        this.requestId = requestId;
        this.clusterId = clusterId;
        this.createTime = System.currentTimeMillis();
        this.startTime = -1L;
        this.endTime = -1L;
        this.exclusive = false;
        this.clusterHostInfo = "{}";
        if (-1L != this.clusterId) {
            try {
                this.clusterName = clusters.getClusterById(this.clusterId).getClusterName();
            }
            catch (OBDPException e) {
                LOG.debug("Could not load cluster with id {}, the cluster may have been removed for request {}", (Object)clusterId, (Object)requestId);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @AssistedInject
    public Request(@Assisted Collection<Stage> stages, @Assisted String clusterHostInfo, Clusters clusters) {
        if (stages != null && !stages.isEmpty()) {
            block3: {
                this.stages.addAll(stages);
                Stage stage = stages.iterator().next();
                this.requestId = stage.getRequestId();
                this.clusterName = stage.getClusterName();
                try {
                    this.clusterId = clusters.getCluster(this.clusterName).getClusterId();
                }
                catch (Exception e) {
                    if (null == this.clusterName) break block3;
                    String message = String.format("Cluster %s not found", this.clusterName);
                    LOG.error(message);
                    throw new RuntimeException(message);
                }
            }
            this.requestContext = stages.iterator().next().getRequestContext();
            this.createTime = System.currentTimeMillis();
            this.startTime = -1L;
            this.endTime = -1L;
            this.clusterHostInfo = clusterHostInfo;
            this.requestType = RequestType.INTERNAL_REQUEST;
            this.exclusive = false;
            return;
        }
        String message = "Attempted to construct request from empty stage collection";
        LOG.error(message);
        throw new RuntimeException(message);
    }

    @AssistedInject
    public Request(@Assisted Collection<Stage> stages, @Assisted String clusterHostInfo, @Assisted ExecuteActionRequest actionRequest, Clusters clusters, Gson gson) throws OBDPException {
        this(stages, clusterHostInfo, clusters);
        if (actionRequest != null) {
            this.resourceFilters = actionRequest.getResourceFilters();
            this.operationLevel = actionRequest.getOperationLevel();
            this.inputs = gson.toJson(actionRequest.getParameters());
            this.requestType = actionRequest.isCommand() != false ? RequestType.COMMAND : RequestType.ACTION;
            this.commandName = actionRequest.isCommand() != false ? actionRequest.getCommandName() : actionRequest.getActionName();
            this.exclusive = actionRequest.isExclusive();
        }
    }

    @AssistedInject
    public Request(@Assisted RequestEntity entity, StageFactory stageFactory, Clusters clusters) {
        Collection<StageEntity> stageEntities;
        if (entity == null) {
            throw new RuntimeException("Request entity cannot be null.");
        }
        this.requestId = entity.getRequestId();
        this.clusterId = entity.getClusterId();
        if (-1L != this.clusterId) {
            try {
                this.clusterName = clusters.getClusterById(this.clusterId).getClusterName();
            }
            catch (OBDPException e) {
                LOG.debug("Could not load cluster with id {}, the cluster may have been removed for request {}", (Object)this.clusterId, (Object)this.requestId);
            }
        }
        this.createTime = entity.getCreateTime();
        this.startTime = entity.getStartTime();
        this.endTime = entity.getEndTime();
        this.exclusive = entity.isExclusive();
        this.requestContext = entity.getRequestContext();
        this.inputs = entity.getInputs();
        this.clusterHostInfo = entity.getClusterHostInfo();
        this.requestType = entity.getRequestType();
        this.commandName = entity.getCommandName();
        this.status = entity.getStatus();
        this.displayStatus = entity.getDisplayStatus();
        if (entity.getRequestScheduleEntity() != null) {
            this.requestScheduleId = entity.getRequestScheduleEntity().getScheduleId();
        }
        if ((stageEntities = entity.getStages()) == null || stageEntities.isEmpty()) {
            this.stages = Collections.emptyList();
        } else {
            this.stages = new ArrayList<Stage>(stageEntities.size());
            for (StageEntity stageEntity : stageEntities) {
                this.stages.add(stageFactory.createExisting(stageEntity));
            }
        }
        this.resourceFilters = Request.filtersFromEntity(entity);
        this.operationLevel = Request.operationLevelFromEntity(entity);
    }

    private static List<String> getHostsList(String hosts) {
        ArrayList<String> hostList = new ArrayList<String>();
        if (hosts != null && !hosts.isEmpty()) {
            for (String host : hosts.split(",")) {
                if (host.trim().isEmpty()) continue;
                hostList.add(host.trim());
            }
        }
        return hostList;
    }

    public Collection<Stage> getStages() {
        return this.stages;
    }

    public void setStages(Collection<Stage> stages) {
        this.stages = stages;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public synchronized RequestEntity constructNewPersistenceEntity() {
        RequestEntity requestEntity = new RequestEntity();
        requestEntity.setRequestId(this.requestId);
        requestEntity.setClusterId(this.clusterId);
        requestEntity.setCreateTime(this.createTime);
        requestEntity.setStartTime(this.startTime);
        requestEntity.setEndTime(this.endTime);
        requestEntity.setExclusive(this.exclusive);
        requestEntity.setRequestContext(this.requestContext);
        requestEntity.setInputs(this.inputs);
        requestEntity.setRequestType(this.requestType);
        requestEntity.setRequestScheduleId(this.requestScheduleId);
        requestEntity.setStatus(this.status);
        requestEntity.setDisplayStatus(this.displayStatus);
        requestEntity.setClusterHostInfo(this.clusterHostInfo);
        requestEntity.setUserName(this.userName);
        if (this.resourceFilters != null) {
            ArrayList<RequestResourceFilterEntity> filterEntities = new ArrayList<RequestResourceFilterEntity>();
            for (RequestResourceFilter resourceFilter : this.resourceFilters) {
                RequestResourceFilterEntity filterEntity = new RequestResourceFilterEntity();
                filterEntity.setServiceName(resourceFilter.getServiceName());
                filterEntity.setComponentName(resourceFilter.getComponentName());
                filterEntity.setHosts(resourceFilter.getHostNames() != null ? StringUtils.join(resourceFilter.getHostNames(), (String)",") : null);
                filterEntity.setRequestEntity(requestEntity);
                filterEntity.setRequestId(this.requestId);
                filterEntities.add(filterEntity);
            }
            requestEntity.setResourceFilterEntities(filterEntities);
        }
        if (this.operationLevel != null) {
            HostEntity hostEntity = hostDAO.findByName(this.operationLevel.getHostName());
            Long hostId = hostEntity != null ? hostEntity.getHostId() : null;
            RequestOperationLevelEntity operationLevelEntity = new RequestOperationLevelEntity();
            operationLevelEntity.setLevel(this.operationLevel.getLevel().toString());
            operationLevelEntity.setClusterName(this.operationLevel.getClusterName());
            operationLevelEntity.setServiceName(this.operationLevel.getServiceName());
            operationLevelEntity.setHostComponentName(this.operationLevel.getHostComponentName());
            operationLevelEntity.setHostId(hostId);
            operationLevelEntity.setRequestEntity(requestEntity);
            operationLevelEntity.setRequestId(this.requestId);
            requestEntity.setRequestOperationLevel(operationLevelEntity);
        }
        return requestEntity;
    }

    public String getClusterHostInfo() {
        return this.clusterHostInfo;
    }

    public void setClusterHostInfo(String clusterHostInfo) {
        this.clusterHostInfo = clusterHostInfo;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(String requestContext) {
        this.requestContext = requestContext;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getInputs() {
        return this.inputs;
    }

    public void setInputs(String inputs) {
        this.inputs = inputs;
    }

    public List<RequestResourceFilter> getResourceFilters() {
        return this.resourceFilters;
    }

    public void setResourceFilters(List<RequestResourceFilter> resourceFilters) {
        this.resourceFilters = resourceFilters;
    }

    public RequestOperationLevel getOperationLevel() {
        return this.operationLevel;
    }

    public void setOperationLevel(RequestOperationLevel operationLevel) {
        this.operationLevel = operationLevel;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    public Long getRequestScheduleId() {
        return this.requestScheduleId;
    }

    public void setRequestScheduleId(Long requestScheduleId) {
        this.requestScheduleId = requestScheduleId;
    }

    public List<HostRoleCommand> getCommands() {
        ArrayList<HostRoleCommand> commands = new ArrayList<HostRoleCommand>();
        for (Stage stage : this.stages) {
            commands.addAll(stage.getOrderedHostRoleCommands());
        }
        return commands;
    }

    public String toString() {
        return "Request{requestId=" + this.requestId + ", clusterId=" + this.clusterId + ", clusterName='" + this.clusterName + "', requestContext='" + this.requestContext + "', createTime=" + this.createTime + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", inputs='" + this.inputs + "', status='" + this.status + "', displayStatus='" + this.displayStatus + "', resourceFilters='" + this.resourceFilters + "', operationLevel='" + this.operationLevel + "', requestType=" + this.requestType + ", stages=" + this.stages + "}";
    }

    public HostRoleStatus getStatus() {
        return this.status;
    }

    public void setStatus(HostRoleStatus status) {
        this.status = status;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean isExclusive) {
        this.exclusive = isExclusive;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public static List<RequestResourceFilter> filtersFromEntity(RequestEntity entity) {
        ArrayList<RequestResourceFilter> resourceFilters = null;
        Collection<RequestResourceFilterEntity> resourceFilterEntities = entity.getResourceFilterEntities();
        if (resourceFilterEntities != null) {
            resourceFilters = new ArrayList<RequestResourceFilter>();
            for (RequestResourceFilterEntity resourceFilterEntity : resourceFilterEntities) {
                RequestResourceFilter resourceFilter = new RequestResourceFilter(resourceFilterEntity.getServiceName(), resourceFilterEntity.getComponentName(), Request.getHostsList(resourceFilterEntity.getHosts()));
                resourceFilters.add(resourceFilter);
            }
        }
        return resourceFilters;
    }

    public static RequestOperationLevel operationLevelFromEntity(RequestEntity entity) {
        RequestOperationLevel level = null;
        RequestOperationLevelEntity operationLevelEntity = entity.getRequestOperationLevel();
        if (operationLevelEntity != null) {
            String hostName = null;
            if (operationLevelEntity.getHostId() != null) {
                HostEntity hostEntity = hostDAO.findById(operationLevelEntity.getHostId());
                hostName = hostEntity.getHostName();
            }
            level = new RequestOperationLevel(Resource.Type.valueOf(operationLevelEntity.getLevel()), operationLevelEntity.getClusterName(), operationLevelEntity.getServiceName(), operationLevelEntity.getHostComponentName(), hostName);
        }
        return level;
    }
}

