/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.actionmanager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public enum HostRoleStatus {
    PENDING,
    QUEUED,
    IN_PROGRESS,
    HOLDING,
    COMPLETED,
    FAILED,
    HOLDING_FAILED,
    TIMEDOUT,
    HOLDING_TIMEDOUT,
    ABORTED,
    SKIPPED_FAILED;

    private static final List<HostRoleStatus> COMPLETED_STATES;
    private static final List<HostRoleStatus> HOLDING_STATES;
    public static final List<HostRoleStatus> SCHEDULED_STATES;
    public static final Set<HostRoleStatus> FAILED_STATUSES;
    public static final Set<HostRoleStatus> NOT_SKIPPABLE_FAILED_STATUSES;
    public static final Set<HostRoleStatus> STACK_UPGRADE_FAILED_STATUSES;
    public static final Set<HostRoleStatus> IN_PROGRESS_STATUSES;
    public static final Set<HostRoleStatus> NOT_COMPLETED_STATUSES;

    public boolean isFailedState() {
        return FAILED_STATUSES.contains((Object)this);
    }

    public boolean isFailedAndNotSkippableState() {
        return NOT_SKIPPABLE_FAILED_STATUSES.contains((Object)this);
    }

    public boolean isCompletedState() {
        return COMPLETED_STATES.contains((Object)this);
    }

    public boolean isHoldingState() {
        return HOLDING_STATES.contains((Object)this);
    }

    public static List<HostRoleStatus> getCompletedStates() {
        return COMPLETED_STATES;
    }

    public boolean isInProgress() {
        return IN_PROGRESS_STATUSES.contains((Object)this);
    }

    static {
        COMPLETED_STATES = ImmutableList.of((Object)((Object)FAILED), (Object)((Object)TIMEDOUT), (Object)((Object)ABORTED), (Object)((Object)COMPLETED), (Object)((Object)SKIPPED_FAILED));
        HOLDING_STATES = ImmutableList.of((Object)((Object)HOLDING), (Object)((Object)HOLDING_FAILED), (Object)((Object)HOLDING_TIMEDOUT));
        SCHEDULED_STATES = ImmutableList.of((Object)((Object)PENDING), (Object)((Object)QUEUED), (Object)((Object)IN_PROGRESS));
        FAILED_STATUSES = Sets.immutableEnumSet((Enum)FAILED, (Enum[])new HostRoleStatus[]{TIMEDOUT, ABORTED, SKIPPED_FAILED});
        NOT_SKIPPABLE_FAILED_STATUSES = Sets.immutableEnumSet((Enum)FAILED, (Enum[])new HostRoleStatus[]{TIMEDOUT, ABORTED});
        STACK_UPGRADE_FAILED_STATUSES = Sets.immutableEnumSet((Enum)FAILED, (Enum[])new HostRoleStatus[]{HOLDING_FAILED, HOLDING_TIMEDOUT});
        IN_PROGRESS_STATUSES = Sets.immutableEnumSet((Enum)QUEUED, (Enum[])new HostRoleStatus[]{IN_PROGRESS, PENDING, HOLDING, HOLDING_FAILED, HOLDING_TIMEDOUT});
        NOT_COMPLETED_STATUSES = ImmutableSet.copyOf(EnumSet.complementOf(EnumSet.of(COMPLETED)));
    }
}

