/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.actionmanager;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.actionmanager.ExecutionCommandWrapperFactory;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleCommandFactory;
import id.onyx.obdp.server.orm.dao.ExecutionCommandDAO;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.ServiceComponentHostEvent;

@Singleton
public class HostRoleCommandFactoryImpl
implements HostRoleCommandFactory {
    private Injector injector;

    @Inject
    public HostRoleCommandFactoryImpl(Injector injector) {
        this.injector = injector;
    }

    @Override
    public HostRoleCommand create(String hostName, Role role, ServiceComponentHostEvent event, RoleCommand command) {
        return new HostRoleCommand(hostName, role, event, command, (HostDAO)this.injector.getInstance(HostDAO.class), (ExecutionCommandDAO)this.injector.getInstance(ExecutionCommandDAO.class), (ExecutionCommandWrapperFactory)this.injector.getInstance(ExecutionCommandWrapperFactory.class));
    }

    @Override
    public HostRoleCommand create(String hostName, Role role, ServiceComponentHostEvent event, RoleCommand command, boolean retryAllowed, boolean autoSkipFailure) {
        return new HostRoleCommand(hostName, role, event, command, retryAllowed, autoSkipFailure, (HostDAO)this.injector.getInstance(HostDAO.class), (ExecutionCommandDAO)this.injector.getInstance(ExecutionCommandDAO.class), (ExecutionCommandWrapperFactory)this.injector.getInstance(ExecutionCommandWrapperFactory.class));
    }

    @Override
    public HostRoleCommand create(Host host, Role role, ServiceComponentHostEvent event, RoleCommand command, boolean retryAllowed, boolean autoSkipFailure) {
        return new HostRoleCommand(host, role, event, command, retryAllowed, autoSkipFailure, (HostDAO)this.injector.getInstance(HostDAO.class), (ExecutionCommandDAO)this.injector.getInstance(ExecutionCommandDAO.class), (ExecutionCommandWrapperFactory)this.injector.getInstance(ExecutionCommandWrapperFactory.class));
    }

    @Override
    public HostRoleCommand createExisting(HostRoleCommandEntity hostRoleCommandEntity) {
        return new HostRoleCommand(hostRoleCommandEntity, (HostDAO)this.injector.getInstance(HostDAO.class), (ExecutionCommandDAO)this.injector.getInstance(ExecutionCommandDAO.class), (ExecutionCommandWrapperFactory)this.injector.getInstance(ExecutionCommandWrapperFactory.class));
    }
}

