/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.actionmanager;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.actionmanager.ExecutionCommandWrapper;
import id.onyx.obdp.server.actionmanager.ExecutionCommandWrapperFactory;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.actionmanager.ServiceComponentHostEventWrapper;
import id.onyx.obdp.server.orm.dao.ExecutionCommandDAO;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.entities.ExecutionCommandEntity;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.ServiceComponentHostEvent;

public class HostRoleCommand {
    private final Role role;
    private final ServiceComponentHostEventWrapper event;
    private long taskId = -1L;
    private long stageId = -1L;
    private long requestId = -1L;
    private long hostId = -1L;
    private String hostName;
    private HostRoleStatus status = HostRoleStatus.PENDING;
    private String stdout = "";
    private String stderr = "";
    public String outputLog = null;
    public String errorLog = null;
    private String structuredOut = "";
    private int exitCode = 999;
    private long startTime = -1L;
    private long originalStartTime = -1L;
    private long endTime = -1L;
    private long lastAttemptTime = -1L;
    private short attemptCount = 0;
    private final boolean retryAllowed;
    private final boolean autoSkipFailure;
    private RoleCommand roleCommand;
    private String commandDetail;
    private String customCommandName;
    private ExecutionCommandWrapper executionCommandWrapper;
    private boolean isBackgroundCommand = false;
    private String opsDisplayName;
    @Inject
    private ExecutionCommandDAO executionCommandDAO;
    @Inject
    private HostDAO hostDAO;
    @Inject
    private ExecutionCommandWrapperFactory ecwFactory;

    @AssistedInject
    public HostRoleCommand(String hostName, Role role, ServiceComponentHostEvent event, RoleCommand command, HostDAO hostDAO, ExecutionCommandDAO executionCommandDAO, ExecutionCommandWrapperFactory ecwFactory) {
        this(hostName, role, event, command, false, false, hostDAO, executionCommandDAO, ecwFactory);
    }

    @AssistedInject
    public HostRoleCommand(String hostName, Role role, ServiceComponentHostEvent event, RoleCommand roleCommand, boolean retryAllowed, boolean autoSkipFailure, HostDAO hostDAO, ExecutionCommandDAO executionCommandDAO, ExecutionCommandWrapperFactory ecwFactory) {
        this.hostDAO = hostDAO;
        this.executionCommandDAO = executionCommandDAO;
        this.ecwFactory = ecwFactory;
        this.role = role;
        this.event = new ServiceComponentHostEventWrapper(event);
        this.roleCommand = roleCommand;
        this.retryAllowed = retryAllowed;
        this.autoSkipFailure = autoSkipFailure;
        this.hostName = hostName;
        HostEntity hostEntity = this.hostDAO.findByName(hostName);
        if (null != hostEntity) {
            this.hostId = hostEntity.getHostId();
        }
    }

    @AssistedInject
    public HostRoleCommand(Host host, Role role, ServiceComponentHostEvent event, RoleCommand roleCommand, boolean retryAllowed, boolean autoSkipFailure, HostDAO hostDAO, ExecutionCommandDAO executionCommandDAO, ExecutionCommandWrapperFactory ecwFactory) {
        this.hostDAO = hostDAO;
        this.executionCommandDAO = executionCommandDAO;
        this.ecwFactory = ecwFactory;
        this.role = role;
        this.event = new ServiceComponentHostEventWrapper(event);
        this.roleCommand = roleCommand;
        this.retryAllowed = retryAllowed;
        this.autoSkipFailure = autoSkipFailure;
        this.hostId = host.getHostId();
        this.hostName = host.getHostName();
    }

    @AssistedInject
    public HostRoleCommand(@Assisted HostRoleCommandEntity hostRoleCommandEntity, HostDAO hostDAO, ExecutionCommandDAO executionCommandDAO, ExecutionCommandWrapperFactory ecwFactory) {
        this.hostDAO = hostDAO;
        this.executionCommandDAO = executionCommandDAO;
        this.ecwFactory = ecwFactory;
        this.taskId = hostRoleCommandEntity.getTaskId();
        this.stageId = null != hostRoleCommandEntity.getStageId() ? hostRoleCommandEntity.getStageId() : hostRoleCommandEntity.getStage().getStageId();
        this.requestId = null != hostRoleCommandEntity.getRequestId() ? hostRoleCommandEntity.getRequestId() : hostRoleCommandEntity.getStage().getRequestId();
        if (null != hostRoleCommandEntity.getHostEntity()) {
            this.hostId = hostRoleCommandEntity.getHostId();
        }
        this.hostName = hostRoleCommandEntity.getHostName();
        this.role = hostRoleCommandEntity.getRole();
        this.status = hostRoleCommandEntity.getStatus();
        this.stdout = hostRoleCommandEntity.getStdOut() != null ? new String(hostRoleCommandEntity.getStdOut()) : "";
        this.stderr = hostRoleCommandEntity.getStdError() != null ? new String(hostRoleCommandEntity.getStdError()) : "";
        this.outputLog = hostRoleCommandEntity.getOutputLog();
        this.errorLog = hostRoleCommandEntity.getErrorLog();
        this.structuredOut = hostRoleCommandEntity.getStructuredOut() != null ? new String(hostRoleCommandEntity.getStructuredOut()) : "";
        this.exitCode = hostRoleCommandEntity.getExitcode();
        this.startTime = hostRoleCommandEntity.getStartTime() != null ? hostRoleCommandEntity.getStartTime() : -1L;
        this.originalStartTime = hostRoleCommandEntity.getOriginalStartTime() != null ? hostRoleCommandEntity.getOriginalStartTime() : -1L;
        this.endTime = hostRoleCommandEntity.getEndTime() != null ? hostRoleCommandEntity.getEndTime() : -1L;
        this.lastAttemptTime = hostRoleCommandEntity.getLastAttemptTime() != null ? hostRoleCommandEntity.getLastAttemptTime() : -1L;
        this.attemptCount = hostRoleCommandEntity.getAttemptCount();
        this.retryAllowed = hostRoleCommandEntity.isRetryAllowed();
        this.autoSkipFailure = hostRoleCommandEntity.isFailureAutoSkipped();
        this.roleCommand = hostRoleCommandEntity.getRoleCommand();
        this.event = new ServiceComponentHostEventWrapper(hostRoleCommandEntity.getEvent());
        this.commandDetail = hostRoleCommandEntity.getCommandDetail();
        this.opsDisplayName = hostRoleCommandEntity.getOpsDisplayName();
        this.customCommandName = hostRoleCommandEntity.getCustomCommandName();
        this.isBackgroundCommand = hostRoleCommandEntity.isBackgroundCommand();
    }

    public HostRoleCommandEntity constructNewPersistenceEntity() {
        HostRoleCommandEntity hostRoleCommandEntity = new HostRoleCommandEntity();
        hostRoleCommandEntity.setRole(this.role);
        hostRoleCommandEntity.setStatus(this.status);
        hostRoleCommandEntity.setStdError(this.stderr.getBytes());
        hostRoleCommandEntity.setExitcode(this.exitCode);
        hostRoleCommandEntity.setStdOut(this.stdout.getBytes());
        hostRoleCommandEntity.setStructuredOut(this.structuredOut.getBytes());
        hostRoleCommandEntity.setStartTime(this.startTime);
        hostRoleCommandEntity.setOriginalStartTime(this.originalStartTime);
        hostRoleCommandEntity.setEndTime(this.endTime);
        hostRoleCommandEntity.setLastAttemptTime(this.lastAttemptTime);
        hostRoleCommandEntity.setAttemptCount(this.attemptCount);
        hostRoleCommandEntity.setRetryAllowed(this.retryAllowed);
        hostRoleCommandEntity.setAutoSkipOnFailure(this.autoSkipFailure);
        hostRoleCommandEntity.setRoleCommand(this.roleCommand);
        hostRoleCommandEntity.setCommandDetail(this.commandDetail);
        hostRoleCommandEntity.setOpsDisplayName(this.opsDisplayName);
        hostRoleCommandEntity.setCustomCommandName(this.customCommandName);
        hostRoleCommandEntity.setBackgroundCommand(this.isBackgroundCommand);
        HostEntity hostEntity = this.hostDAO.findById(this.hostId);
        if (null != hostEntity) {
            hostRoleCommandEntity.setHostEntity(hostEntity);
        }
        hostRoleCommandEntity.setEvent(this.event.getEventJson());
        if (this.requestId >= 0L) {
            hostRoleCommandEntity.setRequestId(this.requestId);
        }
        if (this.stageId >= 0L) {
            hostRoleCommandEntity.setStageId(this.stageId);
        }
        if (this.taskId >= 0L) {
            hostRoleCommandEntity.setTaskId(this.taskId);
        }
        return hostRoleCommandEntity;
    }

    ExecutionCommandEntity constructExecutionCommandEntity() {
        ExecutionCommandEntity executionCommandEntity = new ExecutionCommandEntity();
        executionCommandEntity.setCommand(this.executionCommandWrapper.getJson().getBytes());
        return executionCommandEntity;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setRequestId(long requestId) {
        this.requestId = requestId;
    }

    public void setStageId(long stageId) {
        this.stageId = stageId;
    }

    public void setTaskId(long taskId) {
        if (this.taskId != -1L) {
            throw new RuntimeException("Attempt to set taskId again, not allowed");
        }
        this.taskId = taskId;
        if (this.executionCommandWrapper != null) {
            this.executionCommandWrapper.getExecutionCommand().setTaskId(taskId);
            this.executionCommandWrapper.invalidateJson();
        }
    }

    public void setHost(long hostId, String hostName) {
        this.hostId = hostId;
        this.hostName = hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public long getHostId() {
        return this.hostId;
    }

    public Role getRole() {
        return this.role;
    }

    public String getCommandDetail() {
        return this.commandDetail;
    }

    public void setCommandDetail(String commandDetail) {
        this.commandDetail = commandDetail;
    }

    public String getOpsDisplayName() {
        return this.opsDisplayName;
    }

    public void setOpsDisplayName(String opsDisplayName) {
        this.opsDisplayName = opsDisplayName;
    }

    public String getCustomCommandName() {
        return this.customCommandName;
    }

    public void setCustomCommandName(String customCommandName) {
        this.customCommandName = customCommandName;
    }

    public HostRoleStatus getStatus() {
        return this.status;
    }

    public void setStatus(HostRoleStatus status) {
        this.status = status;
    }

    public ServiceComponentHostEventWrapper getEvent() {
        return this.event;
    }

    public String getStdout() {
        return this.stdout;
    }

    public void setStdout(String stdout) {
        this.stdout = stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public void setStderr(String stderr) {
        this.stderr = stderr;
    }

    public String getOutputLog() {
        return this.outputLog;
    }

    public void setOutputLog(String outputLog) {
        this.outputLog = outputLog;
    }

    public String getErrorLog() {
        return this.errorLog;
    }

    public void setErrorLog(String errorLog) {
        this.errorLog = errorLog;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getOriginalStartTime() {
        return this.originalStartTime;
    }

    public void setOriginalStartTime(long originalStartTime) {
        this.originalStartTime = originalStartTime;
    }

    public long getLastAttemptTime() {
        return this.lastAttemptTime;
    }

    public void setLastAttemptTime(long lastAttemptTime) {
        this.lastAttemptTime = lastAttemptTime;
    }

    public short getAttemptCount() {
        return this.attemptCount;
    }

    public void incrementAttemptCount() {
        this.attemptCount = (short)(this.attemptCount + 1);
    }

    public boolean isRetryAllowed() {
        return this.retryAllowed;
    }

    public String getStructuredOut() {
        return this.structuredOut;
    }

    public void setStructuredOut(String structuredOut) {
        this.structuredOut = structuredOut;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public ExecutionCommandWrapper getExecutionCommandWrapper() {
        if (this.taskId != -1L && this.executionCommandWrapper == null) {
            ExecutionCommandEntity commandEntity = this.executionCommandDAO.findByPK(this.taskId);
            if (commandEntity == null) {
                throw new RuntimeException("Invalid DB state, broken one-to-one relation for taskId=" + this.taskId);
            }
            this.executionCommandWrapper = this.ecwFactory.createFromJson(new String(commandEntity.getCommand()));
        }
        return this.executionCommandWrapper;
    }

    public void setExecutionCommandWrapper(ExecutionCommandWrapper executionCommandWrapper) {
        this.executionCommandWrapper = executionCommandWrapper;
    }

    public RoleCommand getRoleCommand() {
        return this.roleCommand;
    }

    public void setRoleCommand(RoleCommand roleCommand) {
        this.roleCommand = roleCommand;
    }

    public long getStageId() {
        return this.stageId;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public boolean isBackgroundCommand() {
        return this.isBackgroundCommand;
    }

    public void setBackgroundCommand(boolean isBackgroundCommand) {
        this.isBackgroundCommand = isBackgroundCommand;
    }

    public boolean isFailureAutoSkipped() {
        return this.autoSkipFailure;
    }

    public int hashCode() {
        return Long.valueOf(this.taskId).hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof HostRoleCommand)) {
            return false;
        }
        HostRoleCommand o = (HostRoleCommand)other;
        return this.hashCode() == o.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HostRoleCommand State:\n");
        builder.append("  TaskId: ").append(this.taskId).append("\n");
        builder.append("  Role: ").append(this.role).append("\n");
        builder.append("  Status: ").append((Object)this.status).append("\n");
        builder.append("  Event: ").append(this.event).append("\n");
        builder.append("  RetryAllowed: ").append(this.retryAllowed).append("\n");
        builder.append("  AutoSkipFailure: ").append(this.autoSkipFailure).append("\n");
        builder.append("  Output log: ").append(this.outputLog).append("\n");
        builder.append("  Error log: ").append(this.errorLog).append("\n");
        builder.append("  stdout: ").append(this.stdout).append("\n");
        builder.append("  stderr: ").append(this.stderr).append("\n");
        builder.append("  exitcode: ").append(this.exitCode).append("\n");
        builder.append("  Start time: ").append(this.startTime).append("\n");
        builder.append("  Original Start time: ").append(this.originalStartTime).append("\n");
        builder.append("  Last attempt time: ").append(this.lastAttemptTime).append("\n");
        builder.append("  attempt count: ").append(this.attemptCount).append("\n");
        return builder.toString();
    }
}

