/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.actionmanager;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.ClusterNotFoundException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.ServiceNotFoundException;
import id.onyx.obdp.server.agent.AgentCommand;
import id.onyx.obdp.server.agent.CommandRepository;
import id.onyx.obdp.server.agent.ExecutionCommand;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import id.onyx.obdp.server.stack.upgrade.RepositoryVersionHelper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContextFactory;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeSummary;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionCommandWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionCommandWrapper.class);
    String jsonExecutionCommand = null;
    ExecutionCommand executionCommand = null;
    @Inject
    Clusters clusters;
    @Inject
    HostRoleCommandDAO hostRoleCommandDAO;
    @Inject
    ConfigHelper configHelper;
    @Inject
    private Gson gson;
    @Inject
    private UpgradeContextFactory upgradeContextFactory;
    @Inject
    private RepositoryVersionHelper repoVersionHelper;
    @Inject
    private Configuration configuration;

    @AssistedInject
    public ExecutionCommandWrapper(@Assisted String jsonExecutionCommand) {
        this.jsonExecutionCommand = jsonExecutionCommand;
    }

    @AssistedInject
    public ExecutionCommandWrapper(@Assisted ExecutionCommand executionCommand) {
        this.executionCommand = executionCommand;
    }

    public ExecutionCommand getExecutionCommand() {
        if (this.executionCommand != null) {
            return this.executionCommand;
        }
        if (null == this.jsonExecutionCommand) {
            throw new RuntimeException("Invalid ExecutionCommandWrapper, both object and string representations are null");
        }
        try {
            UpgradeEntity upgrade;
            this.executionCommand = (ExecutionCommand)this.gson.fromJson(this.jsonExecutionCommand, ExecutionCommand.class);
            if (null == this.executionCommand.getConfigurations()) {
                this.executionCommand.setConfigurations(new TreeMap<String, Map<String, String>>());
            }
            Map<String, Map<String, String>> configurations = this.executionCommand.getConfigurations();
            Long clusterId = this.hostRoleCommandDAO.findByPK(this.executionCommand.getTaskId()).getStage().getClusterId();
            Cluster cluster = this.clusters.getClusterById(clusterId);
            boolean overrideConfigs = this.executionCommand.isOverrideConfigs();
            if (overrideConfigs) {
                Map<String, DesiredConfig> desiredConfigs = cluster.getDesiredConfigs();
                Map<String, Map<String, String>> configurationTags = this.configHelper.getEffectiveDesiredTags(cluster, this.executionCommand.getHostname(), desiredConfigs);
                LOG.debug("While scheduling task {} on cluster {}, configurations are being refreshed using desired configurations of {}", new Object[]{this.executionCommand.getTaskId(), cluster.getClusterName(), desiredConfigs});
                configurations = this.configHelper.getEffectiveConfigProperties(cluster, configurationTags);
                this.executionCommand.setConfigurations(configurations);
            }
            if (null != (upgrade = cluster.getUpgradeInProgress())) {
                UpgradeContext upgradeContext = this.upgradeContextFactory.create(cluster, upgrade);
                UpgradeSummary upgradeSummary = upgradeContext.getUpgradeSummary();
                this.executionCommand.setUpgradeSummary(upgradeSummary);
            }
            Host host = cluster.getHost(this.executionCommand.getHostname());
            String serviceName = this.executionCommand.getServiceName();
            CommandRepository commandRepository = this.executionCommand.getRepositoryFile();
            if (null == commandRepository && null != host && null != serviceName) {
                commandRepository = this.repoVersionHelper.getCommandRepository(cluster, cluster.getService(serviceName), host, this.executionCommand.getComponentName());
            }
            this.setVersions(cluster, commandRepository);
            this.executionCommand.setRepositoryFile(commandRepository);
        }
        catch (ClusterNotFoundException cnfe) {
            LOG.warn("Unable to lookup the cluster by ID; assuming that there is no cluster and therefore no configs for this execution command: {}", (Object)cnfe.getMessage());
            return this.executionCommand;
        }
        catch (OBDPException e) {
            throw new RuntimeException(e);
        }
        return this.executionCommand;
    }

    public void setVersions(Cluster cluster, CommandRepository commandRepository) {
        String serviceName = this.executionCommand.getServiceName();
        try {
            Service service;
            RepositoryVersionEntity repositoryVersion = null;
            if (!StringUtils.isEmpty((String)serviceName) && null != (service = cluster.getService(serviceName))) {
                ServiceComponent serviceComponent;
                repositoryVersion = service.getDesiredRepositoryVersion();
                String componentName = this.executionCommand.getComponentName();
                if (!StringUtils.isEmpty((String)componentName) && null != (serviceComponent = service.getServiceComponent(componentName))) {
                    repositoryVersion = serviceComponent.getDesiredRepositoryVersion();
                }
            }
            Map<String, String> commandParams = this.executionCommand.getCommandParams();
            if (null != repositoryVersion) {
                if (!commandParams.containsKey("version") && repositoryVersion.isResolved() && this.executionCommand.getRoleCommand() != RoleCommand.INSTALL) {
                    commandParams.put("version", repositoryVersion.getVersion());
                }
                if (null != commandRepository && repositoryVersion.isResolved() && !repositoryVersion.getVersion().equals(commandRepository.getRepoVersion())) {
                    commandRepository.setRepoVersion(repositoryVersion.getVersion());
                    commandRepository.setResolved(true);
                }
                if (!commandParams.containsKey("hooks_folder")) {
                    commandParams.put("hooks_folder", this.configuration.getProperty(Configuration.HOOKS_FOLDER));
                }
            }
            this.executionCommand.setComponentVersions(cluster);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            LOG.warn("The service {} is not installed in the cluster. No repository version will be sent for this command.", (Object)serviceName);
        }
        catch (OBDPException e) {
            throw new RuntimeException(e);
        }
    }

    public AgentCommand.AgentCommandType getCommandType() {
        if (this.executionCommand != null) {
            return this.executionCommand.getCommandType();
        }
        if (null == this.jsonExecutionCommand) {
            throw new RuntimeException("Invalid ExecutionCommandWrapper, both object and string representations are null");
        }
        return ((ExecutionCommand)this.gson.fromJson(this.jsonExecutionCommand, ExecutionCommand.class)).getCommandType();
    }

    public String getJson() {
        if (this.jsonExecutionCommand != null) {
            return this.jsonExecutionCommand;
        }
        if (this.executionCommand != null) {
            this.jsonExecutionCommand = this.gson.toJson((Object)this.executionCommand);
            return this.jsonExecutionCommand;
        }
        throw new RuntimeException("Invalid ExecutionCommandWrapper, both object and string representations are null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionCommandWrapper wrapper = (ExecutionCommandWrapper)o;
        if (this.executionCommand != null && wrapper.executionCommand != null) {
            return this.executionCommand.equals(wrapper.executionCommand);
        }
        return this.getJson().equals(wrapper.getJson());
    }

    public int hashCode() {
        if (this.executionCommand != null) {
            return this.executionCommand.hashCode();
        }
        if (this.jsonExecutionCommand != null) {
            return this.jsonExecutionCommand.hashCode();
        }
        throw new RuntimeException("Invalid Wrapper object");
    }

    void invalidateJson() {
        if (this.executionCommand == null) {
            throw new RuntimeException("Invalid Wrapper object");
        }
        this.jsonExecutionCommand = null;
    }
}

