/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.actionmanager;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.Subscribe;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.persist.UnitOfWork;
import id.onyx.obdp.server.ClusterNotFoundException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.ServiceComponentHostNotFoundException;
import id.onyx.obdp.server.ServiceComponentNotFoundException;
import id.onyx.obdp.server.actionmanager.ActionDBAccessor;
import id.onyx.obdp.server.actionmanager.CommandExecutionType;
import id.onyx.obdp.server.actionmanager.ExecutionCommandWrapper;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleCommandFactory;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.agent.AgentCommand;
import id.onyx.obdp.server.agent.CancelCommand;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.agent.ExecutionCommand;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.HostsMap;
import id.onyx.obdp.server.events.ActionFinalReportReceivedEvent;
import id.onyx.obdp.server.events.jpa.EntityManagerCacheInvalidationEvent;
import id.onyx.obdp.server.events.publishers.AgentCommandsPublisher;
import id.onyx.obdp.server.events.publishers.JPAEventPublisher;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.metadata.RoleCommandOrder;
import id.onyx.obdp.server.metadata.RoleCommandOrderProvider;
import id.onyx.obdp.server.metadata.RoleCommandPair;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.RequestEntity;
import id.onyx.obdp.server.serveraction.ServerActionExecutor;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.HostState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.ServiceComponentHostEvent;
import id.onyx.obdp.server.state.fsm.InvalidStateTransitionException;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostOpFailedEvent;
import id.onyx.obdp.server.utils.StageUtils;
import jakarta.persistence.EntityManager;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class ActionScheduler
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ActionScheduler.class);
    public static final String FAILED_TASK_ABORT_REASONING = "Server considered task failed and automatically aborted it";
    @Inject
    private RoleCommandOrderProvider roleCommandOrderProvider;
    @Inject
    private UnitOfWork unitOfWork;
    @Inject
    private Clusters clusters;
    @Inject
    private OBDPEventPublisher ambariEventPublisher;
    @Inject
    private HostsMap hostsMap;
    @Inject
    private Configuration configuration;
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    private HostRoleCommandFactory hostRoleCommandFactory;
    @Inject
    private HostRoleCommandDAO hostRoleCommandDAO;
    @Inject
    private AgentCommandsPublisher agentCommandsPublisher;
    volatile EntityManager threadEntityManager;
    private final long actionTimeout;
    private final long sleepTime;
    private volatile boolean shouldRun = true;
    private Thread schedulerThread = null;
    private final ActionDBAccessor db;
    private short maxAttempts = (short)2;
    private final JPAEventPublisher jpaPublisher;
    private boolean taskTimeoutAdjustment = true;
    private final Object wakeupSyncObject = new Object();
    private final ServerActionExecutor serverActionExecutor;
    private final Set<Long> requestsInProgress = new HashSet<Long>();
    private final Set<Long> requestsToBeCancelled = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Long, String> requestCancelReasons = new HashMap<Long, String>();
    private boolean activeAwakeRequest = false;
    private AtomicBoolean taskStatusLoaded = new AtomicBoolean();
    private Cache<String, Map<String, Set<String>>> clusterHostInfoCache;
    private Cache<String, Map<String, String>> commandParamsStageCache;
    private Cache<String, Map<String, String>> hostParamsStageCache;

    @Inject
    public ActionScheduler(@Named(value="schedulerSleeptime") long sleepTime, @Named(value="actionTimeout") long actionTimeout, ActionDBAccessor db, JPAEventPublisher jpaPublisher) {
        this.sleepTime = sleepTime;
        this.actionTimeout = actionTimeout;
        this.db = db;
        this.jpaPublisher = jpaPublisher;
        this.jpaPublisher.register(this);
        this.serverActionExecutor = new ServerActionExecutor(db, sleepTime);
        this.initializeCaches();
    }

    protected ActionScheduler(long sleepTimeMilliSec, long actionTimeoutMilliSec, ActionDBAccessor db, Clusters fsmObject, int maxAttempts, HostsMap hostsMap, UnitOfWork unitOfWork, OBDPEventPublisher ambariEventPublisher, Configuration configuration, Provider<EntityManager> entityManagerProvider, HostRoleCommandDAO hostRoleCommandDAO, HostRoleCommandFactory hostRoleCommandFactory, RoleCommandOrderProvider roleCommandOrderProvider, AgentCommandsPublisher agentCommandsPublisher) {
        this.sleepTime = sleepTimeMilliSec;
        this.actionTimeout = actionTimeoutMilliSec;
        this.db = db;
        this.clusters = fsmObject;
        this.maxAttempts = (short)maxAttempts;
        this.hostsMap = hostsMap;
        this.unitOfWork = unitOfWork;
        this.ambariEventPublisher = ambariEventPublisher;
        this.configuration = configuration;
        this.entityManagerProvider = entityManagerProvider;
        this.hostRoleCommandDAO = hostRoleCommandDAO;
        this.hostRoleCommandFactory = hostRoleCommandFactory;
        this.jpaPublisher = null;
        this.roleCommandOrderProvider = roleCommandOrderProvider;
        this.agentCommandsPublisher = agentCommandsPublisher;
        this.serverActionExecutor = new ServerActionExecutor(db, this.sleepTime);
        this.initializeCaches();
    }

    protected ActionScheduler(long sleepTimeMilliSec, long actionTimeoutMilliSec, ActionDBAccessor db, Clusters fsmObject, int maxAttempts, HostsMap hostsMap, UnitOfWork unitOfWork, OBDPEventPublisher ambariEventPublisher, Configuration configuration, Provider<EntityManager> entityManagerProvider, HostRoleCommandDAO hostRoleCommandDAO, HostRoleCommandFactory hostRoleCommandFactory, AgentCommandsPublisher agentCommandsPublisher) {
        this(sleepTimeMilliSec, actionTimeoutMilliSec, db, fsmObject, maxAttempts, hostsMap, unitOfWork, ambariEventPublisher, configuration, entityManagerProvider, hostRoleCommandDAO, hostRoleCommandFactory, null, agentCommandsPublisher);
    }

    private void initializeCaches() {
        this.clusterHostInfoCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
        this.commandParamsStageCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
        this.hostParamsStageCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    }

    public void start() {
        this.schedulerThread = new Thread((Runnable)this, "obdp-action-scheduler");
        this.schedulerThread.start();
        this.serverActionExecutor.start();
    }

    public void stop() {
        this.shouldRun = false;
        this.schedulerThread.interrupt();
        this.serverActionExecutor.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awake() {
        Object object = this.wakeupSyncObject;
        synchronized (object) {
            this.activeAwakeRequest = true;
            this.wakeupSyncObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.shouldRun) {
            try {
                Object object = this.wakeupSyncObject;
                synchronized (object) {
                    if (!this.activeAwakeRequest) {
                        this.wakeupSyncObject.wait(this.sleepTime);
                    }
                    this.activeAwakeRequest = false;
                }
                this.doWork();
            }
            catch (InterruptedException ex) {
                LOG.warn("Scheduler thread is interrupted going to stop", (Throwable)ex);
                this.shouldRun = false;
            }
            catch (Exception ex) {
                LOG.warn("Exception received", (Throwable)ex);
                this.requestsInProgress.clear();
            }
            catch (Throwable t) {
                LOG.warn("ERROR", t);
                this.requestsInProgress.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() throws OBDPException {
        try {
            this.unitOfWork.begin();
            this.threadEntityManager = (EntityManager)this.entityManagerProvider.get();
            this.processCancelledRequestsList();
            if (this.db.getCommandsInProgressCount() == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("There are no stages currently in progress.");
                }
                return;
            }
            HashSet<Long> runningRequestIds = new HashSet<Long>();
            List<Stage> firstStageInProgressPerRequest = this.db.getFirstStageInProgressPerRequest();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduler wakes up");
                LOG.debug("Processing {} in progress stages", (Object)firstStageInProgressPerRequest.size());
            }
            this.publishInProgressTasks(firstStageInProgressPerRequest);
            if (firstStageInProgressPerRequest.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("There are no stages currently in progress.");
                }
                return;
            }
            int i_stage = 0;
            List<Stage> stages = this.filterParallelPerHostStages(firstStageInProgressPerRequest);
            boolean exclusiveRequestIsGoing = false;
            for (Stage stage : stages) {
                long requestId = stage.getRequestId();
                LOG.debug("==> STAGE_i = {}(requestId={},StageId={})", new Object[]{++i_stage, requestId, stage.getStageId()});
                RequestEntity request = this.db.getRequestEntity(requestId);
                if (request.isExclusive().booleanValue()) {
                    if (runningRequestIds.size() > 0) {
                        LOG.debug("Stage requires exclusive execution, but other requests are already executing. Stopping for now");
                        break;
                    }
                    exclusiveRequestIsGoing = true;
                }
                if (runningRequestIds.contains(requestId)) {
                    LOG.debug("==> We don't want to process different stages from the same request in parallel");
                    continue;
                }
                runningRequestIds.add(requestId);
                if (!this.requestsInProgress.contains(requestId)) {
                    this.requestsInProgress.add(requestId);
                    this.db.startRequest(requestId);
                }
                ArrayList<ExecutionCommand> commandsToSchedule = new ArrayList<ExecutionCommand>();
                ArrayListMultimap commandsToEnqueue = ArrayListMultimap.create();
                Map<String, RoleStats> roleStats = this.processInProgressStage(stage, commandsToSchedule, (Multimap<Long, AgentCommand>)commandsToEnqueue);
                boolean failed = false;
                for (Map.Entry<String, RoleStats> entry : roleStats.entrySet()) {
                    String role = entry.getKey();
                    RoleStats stats = entry.getValue();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Stats for role: {}, stats={}", (Object)role, (Object)stats);
                    }
                    if (!stats.isRoleFailed() || stage.isSkippable()) continue;
                    LOG.warn("{} failed, request {} will be aborted", (Object)role, (Object)request.getRequestId());
                    failed = true;
                    break;
                }
                if (!failed) {
                    failed = this.hasPreviousStageFailed(stage);
                }
                if (failed) {
                    LOG.error("Operation completely failed, aborting request id: {}", (Object)stage.getRequestId());
                    this.cancelHostRoleCommands(stage.getOrderedHostRoleCommands(), FAILED_TASK_ABORT_REASONING);
                    this.abortOperationsForStage(stage);
                    return;
                }
                ArrayList<ExecutionCommand> commandsToStart = new ArrayList<ExecutionCommand>();
                ArrayList<ExecutionCommand> commandsToUpdate = new ArrayList<ExecutionCommand>();
                for (ExecutionCommand cmd : commandsToSchedule) {
                    this.processHostRole(request, stage, cmd, commandsToStart, commandsToUpdate);
                }
                LOG.debug("==> Commands to start: {}", (Object)commandsToStart.size());
                LOG.debug("==> Commands to update: {}", (Object)commandsToUpdate.size());
                ListMultimap<String, ServiceComponentHostEvent> eventMap = this.formEventMap(stage, commandsToStart);
                HashMap<ExecutionCommand, String> commandsToAbort = new HashMap<ExecutionCommand, String>();
                if (!eventMap.isEmpty()) {
                    LOG.debug("==> processing {} serviceComponentHostEvents...", (Object)eventMap.size());
                    Cluster cluster = this.clusters.getCluster(stage.getClusterName());
                    if (cluster != null) {
                        Map<ServiceComponentHostEvent, String> failedEvents = cluster.processServiceComponentHostEvents(eventMap);
                        if (failedEvents.size() > 0) {
                            LOG.error("==> {} events failed.", (Object)failedEvents.size());
                        }
                        Iterator iterator = commandsToUpdate.iterator();
                        block10: while (iterator.hasNext()) {
                            ExecutionCommand cmd = (ExecutionCommand)iterator.next();
                            for (ServiceComponentHostEvent event : failedEvents.keySet()) {
                                if (!StringUtils.equals((String)event.getHostName(), (String)cmd.getHostname()) || !StringUtils.equals((String)event.getServiceComponentName(), (String)cmd.getRole())) continue;
                                iterator.remove();
                                commandsToAbort.put(cmd, (String)failedEvents.get(event));
                                continue block10;
                            }
                        }
                    } else {
                        LOG.warn("There was events to process but cluster {} not found", (Object)stage.getClusterName());
                    }
                }
                LOG.debug("==> Scheduling {} tasks...", (Object)commandsToUpdate.size());
                this.db.bulkHostRoleScheduled(stage, commandsToUpdate);
                if (commandsToAbort.size() > 0) {
                    LOG.debug("==> Aborting {} tasks...", (Object)commandsToAbort.size());
                    ArrayList<Long> taskIds = new ArrayList<Long>();
                    for (ExecutionCommand command : commandsToAbort.keySet()) {
                        taskIds.add(command.getTaskId());
                    }
                    Collection<HostRoleCommand> hostRoleCommands = this.db.getTasks(taskIds);
                    this.cancelHostRoleCommands(hostRoleCommands, FAILED_TASK_ABORT_REASONING);
                    this.db.bulkAbortHostRole(stage, commandsToAbort);
                }
                LOG.debug("==> Adding {} tasks to queue...", (Object)commandsToUpdate.size());
                for (ExecutionCommand cmd : commandsToUpdate) {
                    if (Role.AMBARI_SERVER_ACTION.name().equals(cmd.getRole())) {
                        this.serverActionExecutor.awake();
                        continue;
                    }
                    commandsToEnqueue.put((Object)this.clusters.getHost(cmd.getHostname()).getHostId(), (Object)cmd);
                }
                if (!commandsToEnqueue.isEmpty()) {
                    this.agentCommandsPublisher.sendAgentCommand((Multimap<Long, AgentCommand>)commandsToEnqueue);
                }
                LOG.debug("==> Finished.");
                if (!this.configuration.getParallelStageExecution()) {
                    return;
                }
                if (!exclusiveRequestIsGoing) continue;
                LOG.debug("Stage requires exclusive execution, skipping all executing any further stages");
                break;
            }
            this.requestsInProgress.retainAll(runningRequestIds);
        }
        finally {
            LOG.debug("Scheduler finished work.");
            this.unitOfWork.end();
        }
    }

    private void publishInProgressTasks(List<Stage> stages) {
        if (this.taskStatusLoaded.compareAndSet(false, true) && !stages.isEmpty()) {
            Function<Stage, Long> transform = new Function<Stage, Long>(){

                public Long apply(Stage stage) {
                    return stage.getRequestId();
                }
            };
            ImmutableSet runningRequestID = ImmutableSet.copyOf((Collection)Lists.transform(stages, (Function)transform));
            List<HostRoleCommand> hostRoleCommands = this.db.getAllTasksByRequestIds((Collection<Long>)runningRequestID);
            this.hostRoleCommandDAO.publishTaskCreateEvent(hostRoleCommands);
        }
    }

    private List<Stage> filterParallelPerHostStages(List<Stage> firstStageInProgressPerRequest) {
        if (firstStageInProgressPerRequest.size() == 1) {
            return firstStageInProgressPerRequest;
        }
        ArrayList<Stage> retVal = new ArrayList<Stage>();
        long lowerRequestIdInclusive = firstStageInProgressPerRequest.get(0).getRequestId();
        for (Stage stage : firstStageInProgressPerRequest) {
            long requestId = stage.getRequestId();
            if (LOG.isTraceEnabled()) {
                LOG.trace("==> Processing stage: {}/{} ({}) for {}", new Object[]{requestId, stage.getStageId(), stage.getRequestContext()});
            }
            boolean addStage = true;
            HashSet<String> hostsInProgressForEarlierRequests = new HashSet<String>(this.hostRoleCommandDAO.getBlockingHostsForRequest(lowerRequestIdInclusive, requestId));
            for (String host : stage.getHosts()) {
                LOG.trace("===> Processing Host {}", (Object)host);
                if (!hostsInProgressForEarlierRequests.contains(host)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("===>  Skipping stage since it utilizes at least one host that a previous stage requires: {}/{} ({})", new Object[]{stage.getRequestId(), stage.getStageId(), stage.getRequestContext()});
                }
                addStage = false;
                break;
            }
            if (!addStage) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("===>  Adding stage to return value: {}/{} ({})", new Object[]{stage.getRequestId(), stage.getStageId(), stage.getRequestContext()});
            }
            retVal.add(stage);
        }
        return retVal;
    }

    private boolean hasPreviousStageFailed(Stage stage) {
        boolean failed = false;
        long prevStageId = stage.getStageId() - 1L;
        if (prevStageId >= 0L) {
            String actionId = StageUtils.getActionId(stage.getRequestId(), prevStageId);
            Stage prevStage = this.db.getStage(actionId);
            if (prevStage == null || prevStage.isSkippable()) {
                return false;
            }
            HashMap<Role, Integer> hostCountsForRoles = new HashMap<Role, Integer>();
            HashMap<Role, Integer> failedHostCountsForRoles = new HashMap<Role, Integer>();
            for (String host : prevStage.getHostRoleCommands().keySet()) {
                Map<String, HostRoleCommand> roleCommandMap = prevStage.getHostRoleCommands().get(host);
                for (String role : roleCommandMap.keySet()) {
                    HostRoleCommand c = roleCommandMap.get(role);
                    if (hostCountsForRoles.get(c.getRole()) == null) {
                        hostCountsForRoles.put(c.getRole(), 0);
                        failedHostCountsForRoles.put(c.getRole(), 0);
                    }
                    int hostCount = (Integer)hostCountsForRoles.get(c.getRole());
                    hostCountsForRoles.put(c.getRole(), hostCount + 1);
                    if (!c.getStatus().isFailedAndNotSkippableState()) continue;
                    int failedHostCount = (Integer)failedHostCountsForRoles.get(c.getRole());
                    failedHostCountsForRoles.put(c.getRole(), failedHostCount + 1);
                }
            }
            for (Role role : hostCountsForRoles.keySet()) {
                float failedHosts = ((Integer)failedHostCountsForRoles.get(role)).intValue();
                float totalHosts = ((Integer)hostCountsForRoles.get(role)).intValue();
                if (!((totalHosts - failedHosts) / totalHosts < prevStage.getSuccessFactor(role))) continue;
                failed = true;
            }
        }
        return failed;
    }

    protected Map<String, RoleStats> processInProgressStage(Stage s, List<ExecutionCommand> commandsToSchedule, Multimap<Long, AgentCommand> commandsToEnqueue) throws OBDPException {
        LOG.debug("==> Collecting commands to schedule...");
        Map<String, RoleStats> roleStats = this.initRoleStats(s);
        long now = System.currentTimeMillis();
        Set<RoleCommandPair> rolesCommandsInProgress = s.getHostRolesInProgress();
        Cluster cluster = null;
        if (null != s.getClusterName()) {
            cluster = this.clusters.getCluster(s.getClusterName());
        }
        for (String host : s.getHosts()) {
            List<ExecutionCommandWrapper> commandWrappers = s.getExecutionCommands(host);
            Host hostObj = null;
            try {
                hostObj = this.clusters.getHost(host);
            }
            catch (OBDPException e) {
                LOG.debug("Host {} not found, stage is likely a server side action", (Object)host);
            }
            int i_my = 0;
            LOG.trace("===>host={}", (Object)host);
            for (ExecutionCommandWrapper wrapper : commandWrappers) {
                ExecutionCommand c = wrapper.getExecutionCommand();
                String roleStr = c.getRole();
                HostRoleStatus status = s.getHostRoleStatus(host, roleStr);
                ++i_my;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Host task {}) id = {} status = {} (role={}), roleCommand = {}", new Object[]{i_my, c.getTaskId(), status, roleStr, c.getRoleCommand()});
                }
                boolean hostDeleted = false;
                if (null != cluster) {
                    Service svc = null;
                    if (c.getServiceName() != null && !c.getServiceName().isEmpty()) {
                        svc = cluster.getService(c.getServiceName());
                    }
                    ServiceComponent svcComp = null;
                    Map<String, ServiceComponentHost> scHosts = null;
                    try {
                        if (svc != null) {
                            svcComp = svc.getServiceComponent(roleStr);
                            scHosts = svcComp.getServiceComponentHosts();
                        }
                    }
                    catch (ServiceComponentNotFoundException scnex) {
                        String msg = String.format("%s is not not a service component, assuming its an action", roleStr);
                        LOG.debug(msg);
                    }
                    boolean bl = hostDeleted = scHosts != null && !scHosts.containsKey(host);
                    if (hostDeleted) {
                        String message = String.format("Host component information has not been found.  Details:cluster=%s; host=%s; service=%s; component=%s; ", c.getClusterName(), host, svcComp == null ? "null" : svcComp.getServiceName(), svcComp == null ? "null" : svcComp.getName());
                        LOG.warn(message);
                    }
                }
                long commandTimeout = this.actionTimeout;
                if (this.taskTimeoutAdjustment) {
                    Map<String, String> commandParams = c.getCommandParams();
                    String timeoutKey = "command_timeout";
                    if (commandParams != null && commandParams.containsKey(timeoutKey)) {
                        String timeoutStr = commandParams.get(timeoutKey);
                        commandTimeout += Long.parseLong(timeoutStr) * 1000L;
                    } else {
                        LOG.error("Execution command has no timeout parameter" + c);
                    }
                }
                boolean isHostStateUnknown = false;
                if (hostDeleted) {
                    String message = String.format("Host not found when trying to schedule an execution command. The most probable reason for that is that host or host component has been deleted recently. The command has been aborted and dequeued.Execution command details: cmdId: %s; taskId: %s; roleCommand: %s", new Object[]{c.getCommandId(), c.getTaskId(), c.getRoleCommand()});
                    LOG.warn("Host {} has been detected as non-available. {}", (Object)host, (Object)message);
                    this.db.abortHostRole(host, s.getRequestId(), s.getStageId(), c.getRole(), message);
                    if (c.getRoleCommand().equals((Object)RoleCommand.ACTIONEXECUTE)) {
                        this.processActionDeath(cluster.getClusterName(), c.getHostname(), roleStr);
                    }
                    status = HostRoleStatus.ABORTED;
                } else if (this.timeOutActionNeeded(status, s, hostObj, roleStr, now, commandTimeout) || (isHostStateUnknown = this.isHostStateUnknown(s, hostObj, roleStr))) {
                    if (s.getAttemptCount(host, roleStr) >= this.maxAttempts || isHostStateUnknown) {
                        LOG.warn("Host: {}, role: {}, actionId: {} expired and will be failed", new Object[]{host, roleStr, s.getActionId()});
                        boolean isSkipSupported = s.isAutoSkipOnFailureSupported();
                        HostRoleCommand hostRoleCommand = s.getHostRoleCommand(c.getTaskId());
                        if (isSkipSupported && null != hostRoleCommand) {
                            isSkipSupported = hostRoleCommand.isFailureAutoSkipped();
                        }
                        this.db.timeoutHostRole(host, s.getRequestId(), s.getStageId(), c.getRole(), isSkipSupported, isHostStateUnknown);
                        status = s.getHostRoleStatus(host, roleStr);
                        if (null != cluster) {
                            if (!(RoleCommand.CUSTOM_COMMAND.equals((Object)c.getRoleCommand()) || RoleCommand.SERVICE_CHECK.equals((Object)c.getRoleCommand()) || RoleCommand.ACTIONEXECUTE.equals((Object)c.getRoleCommand()))) {
                                this.transitionToFailedState(cluster.getClusterName(), c.getServiceName(), roleStr, host, now, false);
                            }
                            if (c.getRoleCommand().equals((Object)RoleCommand.ACTIONEXECUTE)) {
                                this.processActionDeath(cluster.getClusterName(), c.getHostname(), roleStr);
                            }
                        }
                        LOG.info("Removing command from queue, host={}, commandId={} ", (Object)host, (Object)c.getCommandId());
                    } else {
                        this.cancelCommandOnTimeout(Collections.singletonList(s.getHostRoleCommand(host, roleStr)), commandsToEnqueue);
                        LOG.info("Host: {}, role: {}, actionId: {} timed out and will be rescheduled", new Object[]{host, roleStr, s.getActionId()});
                        commandsToSchedule.add(c);
                        LOG.trace("===> commandsToSchedule(reschedule)={}", (Object)commandsToSchedule.size());
                    }
                } else if (status.equals((Object)HostRoleStatus.PENDING) && (CommandExecutionType.STAGE == s.getCommandExecutionType() || CommandExecutionType.DEPENDENCY_ORDERED == s.getCommandExecutionType() && CommandExecutionType.DEPENDENCY_ORDERED == this.configuration.getStageExecutionType() && this.areCommandDependenciesFinished(c, s, rolesCommandsInProgress))) {
                    commandsToSchedule.add(c);
                    LOG.trace("===>commandsToSchedule(first_time)={}", (Object)commandsToSchedule.size());
                }
                this.updateRoleStats(status, roleStats.get(roleStr));
                if (status != HostRoleStatus.FAILED) continue;
                LOG.info("Role {} on host {} was failed", (Object)roleStr, (Object)host);
            }
        }
        LOG.debug("Collected {} commands to schedule in this wakeup.", (Object)commandsToSchedule.size());
        return roleStats;
    }

    private boolean areCommandDependenciesFinished(ExecutionCommand command, Stage stage, Set<RoleCommandPair> rolesCommandsInProgress) {
        boolean areCommandDependenciesFinished = true;
        RoleCommandOrder rco = this.roleCommandOrderProvider.getRoleCommandOrder(stage.getClusterId());
        if (rco != null) {
            RoleCommandPair roleCommand = new RoleCommandPair(Role.valueOf(command.getRole()), command.getRoleCommand());
            Set<RoleCommandPair> roleCommandDependencies = rco.getDependencies().get(roleCommand);
            if (roleCommandDependencies != null) {
                roleCommandDependencies.remove(roleCommand);
                if (CollectionUtils.containsAny(rolesCommandsInProgress, roleCommandDependencies)) {
                    areCommandDependenciesFinished = false;
                }
            }
        }
        return areCommandDependenciesFinished;
    }

    private void abortOperationsForStage(Stage stage) {
        long now = System.currentTimeMillis();
        for (String hostName : stage.getHosts()) {
            List<ExecutionCommandWrapper> commandWrappers = stage.getExecutionCommands(hostName);
            for (ExecutionCommandWrapper wrapper : commandWrappers) {
                ExecutionCommand c = wrapper.getExecutionCommand();
                this.transitionToFailedState(stage.getClusterName(), c.getServiceName(), c.getRole(), hostName, now, true);
            }
        }
        Collection<HostRoleCommandEntity> abortedOperations = this.db.abortOperation(stage.getRequestId());
        for (HostRoleCommandEntity command : abortedOperations) {
            if (!command.getRoleCommand().equals((Object)RoleCommand.ACTIONEXECUTE)) continue;
            String clusterName = stage.getClusterName();
            this.processActionDeath(clusterName, command.getHostName(), command.getRole().name());
        }
    }

    private void transitionToFailedState(String clusterName, String serviceName, String componentName, String hostname, long timestamp, boolean ignoreTransitionException) {
        try {
            Cluster cluster = this.clusters.getCluster(clusterName);
            ServiceComponentHostOpFailedEvent failedEvent = new ServiceComponentHostOpFailedEvent(componentName, hostname, timestamp);
            if (serviceName != null && !serviceName.isEmpty() && componentName != null && !componentName.isEmpty()) {
                Service svc = cluster.getService(serviceName);
                ServiceComponent svcComp = svc.getServiceComponent(componentName);
                ServiceComponentHost svcCompHost = svcComp.getServiceComponentHost(hostname);
                svcCompHost.handleEvent(failedEvent);
            } else {
                LOG.info("Service name is " + serviceName + ", component name is " + componentName + "skipping sending ServiceComponentHostOpFailedEvent for " + componentName);
            }
        }
        catch (ServiceComponentNotFoundException scnex) {
            LOG.debug("{} associated with service {} is not a service component, assuming it's an action.", (Object)componentName, (Object)serviceName);
        }
        catch (ServiceComponentHostNotFoundException e) {
            String msg = String.format("Service component host %s not found, unable to transition to failed state.", componentName);
            LOG.warn(msg, (Throwable)((Object)e));
        }
        catch (InvalidStateTransitionException e) {
            if (ignoreTransitionException) {
                LOG.debug("Unable to transition to failed state.", (Throwable)e);
            } else {
                LOG.warn("Unable to transition to failed state.", (Throwable)e);
            }
        }
        catch (OBDPException e) {
            LOG.warn("Unable to transition to failed state.", (Throwable)e);
        }
    }

    private Map<String, RoleStats> initRoleStats(Stage s) {
        HashMap<Role, Integer> hostCountsForRoles = new HashMap<Role, Integer>();
        TreeMap<String, RoleStats> roleStats = new TreeMap<String, RoleStats>();
        for (String host : s.getHostRoleCommands().keySet()) {
            Map<String, HostRoleCommand> roleCommandMap = s.getHostRoleCommands().get(host);
            for (String role : roleCommandMap.keySet()) {
                HostRoleCommand c = roleCommandMap.get(role);
                if (hostCountsForRoles.get(c.getRole()) == null) {
                    hostCountsForRoles.put(c.getRole(), 0);
                }
                int val = (Integer)hostCountsForRoles.get(c.getRole());
                hostCountsForRoles.put(c.getRole(), val + 1);
            }
        }
        for (Role r : hostCountsForRoles.keySet()) {
            RoleStats stats = new RoleStats((Integer)hostCountsForRoles.get(r), s.getSuccessFactor(r));
            roleStats.put(r.name(), stats);
        }
        return roleStats;
    }

    protected boolean wasAgentRestartedDuringOperation(Host host, Stage stage, String role) {
        String hostName = host.getHostName();
        long taskStartTime = stage.getHostRoleCommand(hostName, role).getStartTime();
        long lastAgentStartTime = host.getLastAgentStartTime();
        return taskStartTime > 0L && lastAgentStartTime > 0L && taskStartTime <= lastAgentStartTime;
    }

    protected boolean timeOutActionNeeded(HostRoleStatus status, Stage stage, Host host, String role, long currentTime, long taskTimeout) throws OBDPException {
        String hostName;
        if (!status.equals((Object)HostRoleStatus.QUEUED) && !status.equals((Object)HostRoleStatus.IN_PROGRESS)) {
            return false;
        }
        String string = hostName = null == host ? null : host.getHostName();
        if (this.hasCommandInProgress(stage, hostName) && !status.equals((Object)HostRoleStatus.IN_PROGRESS)) {
            return false;
        }
        return currentTime >= stage.getLastAttemptTime(hostName, role) + taskTimeout;
    }

    private boolean isHostStateUnknown(Stage stage, Host host, String role) {
        if (null != host && (host.getState().equals((Object)HostState.HEARTBEAT_LOST) || this.wasAgentRestartedDuringOperation(host, stage, role))) {
            LOG.debug("Abort action since agent is not heartbeating or agent was restarted.");
            return true;
        }
        return false;
    }

    private boolean hasCommandInProgress(Stage stage, String host) {
        List<ExecutionCommandWrapper> commandWrappers = stage.getExecutionCommands(host);
        for (ExecutionCommandWrapper wrapper : commandWrappers) {
            ExecutionCommand c = wrapper.getExecutionCommand();
            String roleStr = c.getRole();
            HostRoleStatus status = stage.getHostRoleStatus(host, roleStr);
            if (status != HostRoleStatus.IN_PROGRESS) continue;
            return true;
        }
        return false;
    }

    private ListMultimap<String, ServiceComponentHostEvent> formEventMap(Stage s, List<ExecutionCommand> commands) {
        ArrayListMultimap serviceEventMap = ArrayListMultimap.create();
        for (ExecutionCommand cmd : commands) {
            String hostname = cmd.getHostname();
            String roleStr = cmd.getRole();
            if (RoleCommand.ACTIONEXECUTE == cmd.getRoleCommand()) continue;
            serviceEventMap.put((Object)cmd.getServiceName(), (Object)s.getFsmEvent(hostname, roleStr).getEvent());
        }
        return serviceEventMap;
    }

    private void processHostRole(RequestEntity r, Stage s, ExecutionCommand cmd, List<ExecutionCommand> commandsToStart, List<ExecutionCommand> commandsToUpdate) throws OBDPException {
        Map hostParams;
        long now = System.currentTimeMillis();
        String roleStr = cmd.getRole();
        String hostname = cmd.getHostname();
        if (s.getStartTime(hostname, roleStr) < 0L) {
            commandsToStart.add(cmd);
            s.setStartTime(hostname, roleStr, now);
            s.setHostRoleStatus(hostname, roleStr, HostRoleStatus.QUEUED);
        }
        s.setLastAttemptTime(hostname, roleStr, now);
        s.incrementAttemptCount(hostname, roleStr);
        String requestPK = r.getRequestId().toString();
        String stagePk = s.getStageId() + "-" + s.getRequestId();
        Map clusterHostInfo = (Map)this.clusterHostInfoCache.getIfPresent((Object)requestPK);
        if (clusterHostInfo == null) {
            Type type = new TypeToken<Map<String, Set<String>>>(){}.getType();
            clusterHostInfo = (Map)StageUtils.getGson().fromJson(r.getClusterHostInfo(), type);
            this.clusterHostInfoCache.put((Object)requestPK, (Object)clusterHostInfo);
        }
        cmd.setClusterHostInfo(clusterHostInfo);
        Map commandParams = (Map)this.commandParamsStageCache.getIfPresent((Object)stagePk);
        if (commandParams == null) {
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            commandParams = (Map)StageUtils.getGson().fromJson(s.getCommandParamsStage(), type);
            this.commandParamsStageCache.put((Object)stagePk, (Object)commandParams);
        }
        Map<String, String> commandParamsCmd = cmd.getCommandParams();
        commandParamsCmd.putAll(commandParams);
        cmd.setCommandParams(commandParamsCmd);
        try {
            Cluster cluster = this.clusters.getCluster(s.getClusterName());
            if (null != cluster) {
                for (ServiceComponentHost sch : cluster.getServiceComponentHosts(hostname)) {
                    cmd.getLocalComponents().add(sch.getServiceComponentName());
                }
            }
        }
        catch (ClusterNotFoundException cluster) {
            // empty catch block
        }
        if ((hostParams = (Map)this.hostParamsStageCache.getIfPresent((Object)stagePk)) == null) {
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            hostParams = (Map)StageUtils.getGson().fromJson(s.getHostParamsStage(), type);
            this.hostParamsStageCache.put((Object)stagePk, (Object)hostParams);
        }
        Map<String, String> hostParamsCmd = cmd.getHostLevelParams();
        hostParamsCmd.putAll(hostParams);
        cmd.setHostLevelParams(hostParamsCmd);
        cmd.setHostname(this.hostsMap.getHostMap(hostname));
        commandsToUpdate.add(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleCancellingRequest(long requestId, String reason) {
        Set<Long> set = this.requestsToBeCancelled;
        synchronized (set) {
            this.requestsToBeCancelled.add(requestId);
            this.requestCancelReasons.put(requestId, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCancelledRequestsList() throws OBDPException {
        Set<Long> set = this.requestsToBeCancelled;
        synchronized (set) {
            for (Long requestId : this.requestsToBeCancelled) {
                List<HostRoleCommandEntity> entitiesToDequeue = this.hostRoleCommandDAO.findByRequestIdAndStatuses(requestId, HostRoleStatus.NOT_COMPLETED_STATUSES);
                if (!entitiesToDequeue.isEmpty()) {
                    ArrayList<HostRoleCommand> tasksToDequeue = new ArrayList<HostRoleCommand>(entitiesToDequeue.size());
                    for (HostRoleCommandEntity hrcEntity : entitiesToDequeue) {
                        HostRoleCommand task = this.hostRoleCommandFactory.createExisting(hrcEntity);
                        tasksToDequeue.add(task);
                    }
                    String reason = this.requestCancelReasons.get(requestId);
                    this.cancelHostRoleCommands(tasksToDequeue, reason);
                }
                List<Stage> stagesInProgress = this.db.getStagesInProgressForRequest(requestId);
                for (Stage stageInProgress : stagesInProgress) {
                    this.abortOperationsForStage(stageInProgress);
                }
            }
            this.requestsToBeCancelled.clear();
            this.requestCancelReasons.clear();
        }
    }

    void cancelHostRoleCommands(Collection<HostRoleCommand> hostRoleCommands, String reason) throws OBDPException {
        for (HostRoleCommand hostRoleCommand : hostRoleCommands) {
            if (!(Role.AMBARI_SERVER_ACTION.equals(hostRoleCommand.getRole()) || hostRoleCommand.getStatus() != HostRoleStatus.QUEUED && hostRoleCommand.getStatus() != HostRoleStatus.IN_PROGRESS)) {
                CancelCommand cancelCommand = new CancelCommand();
                cancelCommand.setTargetTaskId(hostRoleCommand.getTaskId());
                cancelCommand.setReason(reason);
                this.agentCommandsPublisher.sendAgentCommand(hostRoleCommand.getHostId(), cancelCommand);
            }
            if (hostRoleCommand.getStatus().isHoldingState()) {
                this.db.abortHostRole(hostRoleCommand.getHostName(), hostRoleCommand.getRequestId(), hostRoleCommand.getStageId(), hostRoleCommand.getRole().name());
            }
            if (!hostRoleCommand.getRoleCommand().equals((Object)RoleCommand.ACTIONEXECUTE)) continue;
            String clusterName = hostRoleCommand.getExecutionCommandWrapper().getExecutionCommand().getClusterName();
            this.processActionDeath(clusterName, hostRoleCommand.getHostName(), hostRoleCommand.getRole().name());
        }
    }

    void cancelCommandOnTimeout(Collection<HostRoleCommand> hostRoleCommands, Multimap<Long, AgentCommand> commandsToEnqueue) {
        for (HostRoleCommand hostRoleCommand : hostRoleCommands) {
            if (Role.AMBARI_SERVER_ACTION.equals(hostRoleCommand.getRole()) || hostRoleCommand.getStatus() != HostRoleStatus.QUEUED && hostRoleCommand.getStatus() != HostRoleStatus.IN_PROGRESS) continue;
            CancelCommand cancelCommand = new CancelCommand();
            cancelCommand.setTargetTaskId(hostRoleCommand.getTaskId());
            cancelCommand.setReason("Stage timeout");
            commandsToEnqueue.put((Object)hostRoleCommand.getHostId(), (Object)cancelCommand);
        }
    }

    private void processActionDeath(String clusterName, String hostname, String role) {
        try {
            Long clusterId = clusterName != null ? Long.valueOf(this.clusters.getCluster(clusterName).getClusterId()) : null;
            CommandReport report = new CommandReport();
            report.setRole(role);
            report.setStdOut("Action is dead");
            report.setStdErr("Action is dead");
            report.setStructuredOut("{}");
            report.setExitCode(1);
            report.setStatus(HostRoleStatus.ABORTED.toString());
            ActionFinalReportReceivedEvent event = new ActionFinalReportReceivedEvent(clusterId, hostname, report, true);
            this.ambariEventPublisher.publish(event);
        }
        catch (OBDPException e) {
            LOG.error(String.format("Can not get cluster %s", clusterName), (Throwable)e);
        }
    }

    private void updateRoleStats(HostRoleStatus status, RoleStats rs) {
        switch (status) {
            case COMPLETED: {
                ++rs.numSucceeded;
                break;
            }
            case FAILED: {
                ++rs.numFailed;
                break;
            }
            case QUEUED: {
                ++rs.numQueued;
                break;
            }
            case PENDING: {
                ++rs.numPending;
                break;
            }
            case TIMEDOUT: {
                ++rs.numTimedOut;
                break;
            }
            case ABORTED: {
                ++rs.numAborted;
                break;
            }
            case IN_PROGRESS: {
                ++rs.numInProgress;
                break;
            }
            case HOLDING: 
            case HOLDING_FAILED: 
            case HOLDING_TIMEDOUT: {
                ++rs.numHolding;
                break;
            }
            case SKIPPED_FAILED: {
                ++rs.numSkipped;
                break;
            }
            default: {
                LOG.error("Unknown status " + status.name());
            }
        }
    }

    public void setTaskTimeoutAdjustment(boolean val) {
        this.taskTimeoutAdjustment = val;
    }

    ServerActionExecutor getServerActionExecutor() {
        return this.serverActionExecutor;
    }

    @Subscribe
    public void onEvent(EntityManagerCacheInvalidationEvent event) {
        try {
            if (null != this.threadEntityManager && this.threadEntityManager.isOpen()) {
                this.threadEntityManager.clear();
            }
        }
        catch (Throwable throwable) {
            LOG.error("Unable to clear the EntityManager for the scheduler thread", throwable);
        }
    }

    static class RoleStats {
        int numInProgress;
        int numQueued = 0;
        int numSucceeded = 0;
        int numFailed = 0;
        int numTimedOut = 0;
        int numPending = 0;
        int numAborted = 0;
        int numHolding = 0;
        int numSkipped = 0;
        final int totalHosts;
        final float successFactor;

        RoleStats(int total, float successFactor) {
            this.totalHosts = total;
            this.successFactor = successFactor;
        }

        boolean isSuccessFactorMet() {
            int minSuccessNeeded = (int)Math.ceil(this.successFactor * (float)this.totalHosts);
            return minSuccessNeeded <= this.numSucceeded;
        }

        private boolean isRoleInProgress() {
            return this.numPending + this.numQueued + this.numInProgress + this.numHolding > 0;
        }

        boolean isRoleFailed() {
            return !this.isRoleInProgress() && !this.isSuccessFactorMet();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("numQueued=").append(this.numQueued);
            builder.append(", numInProgress=").append(this.numInProgress);
            builder.append(", numSucceeded=").append(this.numSucceeded);
            builder.append(", numFailed=").append(this.numFailed);
            builder.append(", numTimedOut=").append(this.numTimedOut);
            builder.append(", numPending=").append(this.numPending);
            builder.append(", numAborted=").append(this.numAborted);
            builder.append(", numSkipped=").append(this.numSkipped);
            builder.append(", totalHosts=").append(this.totalHosts);
            builder.append(", successFactor=").append(this.successFactor);
            return builder.toString();
        }
    }
}

