/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.actionmanager;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.ActionDBAccessor;
import id.onyx.obdp.server.actionmanager.ActionScheduler;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.actionmanager.Request;
import id.onyx.obdp.server.actionmanager.RequestFactory;
import id.onyx.obdp.server.actionmanager.RequestStatus;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.controller.ExecuteActionRequest;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.topology.TopologyManager;
import id.onyx.obdp.server.utils.CommandUtils;
import id.onyx.obdp.server.utils.StageUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ActionManager {
    private static final Logger LOG = LoggerFactory.getLogger(ActionManager.class);
    private final ActionScheduler scheduler;
    private final ActionDBAccessor db;
    private final AtomicLong requestCounter;
    private final RequestFactory requestFactory;
    private static TopologyManager topologyManager;

    @Inject
    public ActionManager(ActionDBAccessor db, RequestFactory requestFactory, ActionScheduler scheduler) {
        this.db = db;
        this.requestFactory = requestFactory;
        this.scheduler = scheduler;
        this.requestCounter = new AtomicLong(db.getLastPersistedRequestIdWhenInitialized());
    }

    public void start() {
        LOG.info("Starting scheduler thread");
        this.scheduler.start();
    }

    public void shutdown() {
        this.scheduler.stop();
    }

    public void sendActions(List<Stage> stages, String clusterHostInfo, ExecuteActionRequest actionRequest) throws OBDPException {
        Request request = this.requestFactory.createNewFromStages(stages, clusterHostInfo, actionRequest);
        request.setUserName(AuthorizationHelper.getAuthenticatedName());
        this.sendActions(request, actionRequest);
    }

    public void sendActions(Request request, ExecuteActionRequest executeActionRequest) throws OBDPException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Persisting Request into DB: {}", (Object)request);
            if (executeActionRequest != null) {
                LOG.debug("In response to request: {}", (Object)request);
            }
        }
        this.db.persistActions(request);
        this.scheduler.awake();
    }

    public List<Request> getRequests(Collection<Long> requestIds) {
        List<Request> requests = this.db.getRequests(requestIds);
        requests.addAll(topologyManager.getRequests(requestIds));
        return requests;
    }

    public List<Stage> getRequestStatus(long requestId) {
        return this.db.getAllStages(requestId);
    }

    public Stage getAction(long requestId, long stageId) {
        return this.db.getStage(StageUtils.getActionId(requestId, stageId));
    }

    public List<Stage> getActions(long requestId) {
        return this.db.getAllStages(requestId);
    }

    public HostRoleCommand getTaskById(long taskId) {
        return this.db.getTask(taskId);
    }

    public void processTaskResponse(String hostname, List<CommandReport> reports, Map<Long, HostRoleCommand> commands) {
        if (reports == null) {
            return;
        }
        Collections.sort(reports, new Comparator<CommandReport>(){

            @Override
            public int compare(CommandReport o1, CommandReport o2) {
                return (int)(o1.getTaskId() - o2.getTaskId());
            }
        });
        ArrayList<CommandReport> reportsToProcess = new ArrayList<CommandReport>();
        for (CommandReport report : reports) {
            HostRoleCommand command = commands.get(report.getTaskId());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing command report : {}", (Object)report);
            }
            if (command == null) {
                LOG.warn("The task " + report.getTaskId() + " is invalid");
                continue;
            }
            if (!(command.getStatus().equals((Object)HostRoleStatus.IN_PROGRESS) || command.getStatus().equals((Object)HostRoleStatus.QUEUED) || command.getStatus().equals((Object)HostRoleStatus.ABORTED))) {
                LOG.warn("The task " + command.getTaskId() + " is not in progress, ignoring update");
                continue;
            }
            reportsToProcess.add(report);
        }
        this.db.updateHostRoleStates(reportsToProcess);
    }

    public boolean isInProgressCommand(CommandReport report) {
        HostRoleCommand command = this.db.getTask(report.getTaskId());
        if (command == null) {
            LOG.warn("The task " + report.getTaskId() + " is invalid");
            return false;
        }
        return command.getStatus().equals((Object)HostRoleStatus.IN_PROGRESS) || command.getStatus().equals((Object)HostRoleStatus.QUEUED);
    }

    public void handleLostHost(String host) {
    }

    public long getNextRequestId() {
        return this.requestCounter.incrementAndGet();
    }

    public List<HostRoleCommand> getRequestTasks(long requestId) {
        return this.db.getRequestTasks(requestId);
    }

    public List<HostRoleCommand> getAllTasksByRequestIds(Collection<Long> requestIds) {
        return this.db.getAllTasksByRequestIds(requestIds);
    }

    public Collection<HostRoleCommand> getTasks(Collection<Long> taskIds) {
        return this.db.getTasks(taskIds);
    }

    public Map<Long, HostRoleCommand> getTasksMap(Collection<Long> taskIds) {
        return CommandUtils.convertToTaskIdCommandMap(this.getTasks(taskIds));
    }

    public List<Long> getRequestsByStatus(RequestStatus status, int maxResults, boolean ascOrder) {
        List<Long> requests = this.db.getRequestsByStatus(status, maxResults, ascOrder);
        for (Request request : topologyManager.getRequests(Collections.emptySet())) {
            HostRoleStatus logicalRequestStatus = request.getStatus();
            if (status != null && (logicalRequestStatus == null || !request.getStatus().name().equals(status.name()))) continue;
            requests.add(request.getRequestId());
        }
        return requests;
    }

    public Map<Long, String> getRequestContext(List<Long> requestIds) {
        return this.db.getRequestContext(requestIds);
    }

    public String getRequestContext(long requestId) {
        return this.db.getRequestContext(requestId);
    }

    public void cancelRequest(long requestId, String reason) {
        this.scheduler.scheduleCancellingRequest(requestId, reason);
        this.scheduler.awake();
    }

    public static void setTopologyManager(TopologyManager topologyManager) {
        ActionManager.topologyManager = topologyManager;
    }

    public void resubmitTasks(List<Long> taskIds) {
        this.db.resubmitTasks(taskIds);
    }
}

