/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.actionmanager;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.annotations.TransactionalLock;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.actionmanager.ActionDBAccessor;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleCommandFactory;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.actionmanager.Request;
import id.onyx.obdp.server.actionmanager.RequestFactory;
import id.onyx.obdp.server.actionmanager.RequestStatus;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.actionmanager.StageFactory;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.agent.ExecutionCommand;
import id.onyx.obdp.server.audit.AuditLogger;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.audit.event.OperationStatusAuditEvent;
import id.onyx.obdp.server.audit.event.TaskStatusAuditEvent;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.internal.CalculatedStatus;
import id.onyx.obdp.server.events.HostsRemovedEvent;
import id.onyx.obdp.server.events.RequestFinishedEvent;
import id.onyx.obdp.server.events.RequestUpdateEvent;
import id.onyx.obdp.server.events.TaskCreateEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.events.publishers.TaskEventPublisher;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.dao.ExecutionCommandDAO;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.dao.RequestDAO;
import id.onyx.obdp.server.orm.dao.RequestScheduleDAO;
import id.onyx.obdp.server.orm.dao.RoleSuccessCriteriaDAO;
import id.onyx.obdp.server.orm.dao.StageDAO;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.ExecutionCommandEntity;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.RequestEntity;
import id.onyx.obdp.server.orm.entities.RequestScheduleEntity;
import id.onyx.obdp.server.orm.entities.RoleSuccessCriteriaEntity;
import id.onyx.obdp.server.orm.entities.StageEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.topology.TopologyManager;
import id.onyx.obdp.server.utils.StageUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ActionDBAccessorImpl
implements ActionDBAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(ActionDBAccessorImpl.class);
    private long requestId;
    @Inject
    ClusterDAO clusterDAO;
    @Inject
    HostDAO hostDAO;
    @Inject
    RequestDAO requestDAO;
    @Inject
    StageDAO stageDAO;
    @Inject
    HostRoleCommandDAO hostRoleCommandDAO;
    @Inject
    ExecutionCommandDAO executionCommandDAO;
    @Inject
    RoleSuccessCriteriaDAO roleSuccessCriteriaDAO;
    @Inject
    StageFactory stageFactory;
    @Inject
    RequestFactory requestFactory;
    @Inject
    HostRoleCommandFactory hostRoleCommandFactory;
    @Inject
    Clusters clusters;
    @Inject
    RequestScheduleDAO requestScheduleDAO;
    @Inject
    Configuration configuration;
    @Inject
    OBDPEventPublisher ambariEventPublisher;
    @Inject
    TaskEventPublisher taskEventPublisher;
    @Inject
    AuditLogger auditLogger;
    @Inject
    STOMPUpdatePublisher STOMPUpdatePublisher;
    @Inject
    TopologyManager topologyManager;
    private Cache<Long, RequestDetails> auditlogRequestCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).concurrencyLevel(4).build();
    private Cache<Long, HostRoleCommand> hostRoleCommandCache;
    private long cacheLimit;
    private final ReadWriteLock hrcOperationsLock = new ReentrantReadWriteLock();

    @Inject
    public ActionDBAccessorImpl(@Named(value="executionCommandCacheSize") long cacheLimit, OBDPEventPublisher eventPublisher) {
        this.cacheLimit = cacheLimit;
        this.hostRoleCommandCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
        eventPublisher.register(this);
    }

    @Inject
    void init() {
        this.requestId = this.stageDAO.getLastRequestId();
    }

    @Override
    public Stage getStage(String actionId) {
        StageEntity stageEntity = this.stageDAO.findByActionId(actionId);
        return stageEntity == null ? null : this.stageFactory.createExisting(stageEntity);
    }

    @Override
    public List<Stage> getAllStages(long requestId) {
        List<StageEntity> stageEntities = this.stageDAO.findByRequestId(requestId);
        ArrayList<Stage> stages = new ArrayList<Stage>(stageEntities.size());
        for (StageEntity stageEntity : stageEntities) {
            stages.add(this.stageFactory.createExisting(stageEntity));
        }
        return stages;
    }

    @Override
    public RequestEntity getRequestEntity(long requestId) {
        return this.requestDAO.findByPK(requestId);
    }

    @Override
    public Request getRequest(long requestId) {
        RequestEntity requestEntity = this.getRequestEntity(requestId);
        if (requestEntity != null) {
            return this.requestFactory.createExisting(requestEntity);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<HostRoleCommandEntity> abortOperation(long requestId) {
        try {
            this.hrcOperationsLock.writeLock().lock();
            ArrayList<HostRoleCommandEntity> abortedHostRoleCommands = new ArrayList<HostRoleCommandEntity>();
            long now = System.currentTimeMillis();
            List<HostRoleCommandEntity> commands = this.hostRoleCommandDAO.findByRequestIdAndStatuses(requestId, HostRoleStatus.SCHEDULED_STATES);
            for (HostRoleCommandEntity command : commands) {
                command.setStatus(HostRoleStatus.ABORTED);
                command.setEndTime(now);
                abortedHostRoleCommands.add(this.hostRoleCommandDAO.merge(command));
                LOG.info("Aborted command. Hostname " + command.getHostName() + " role " + command.getRole() + " requestId " + command.getRequestId() + " taskId " + command.getTaskId() + " stageId " + command.getStageId());
                this.auditLog(command, requestId);
                this.cacheHostRoleCommand(this.hostRoleCommandFactory.createExisting(command));
            }
            this.endRequest(requestId);
            ArrayList<HostRoleCommandEntity> arrayList = abortedHostRoleCommands;
            return arrayList;
        }
        finally {
            this.hrcOperationsLock.writeLock().unlock();
        }
    }

    @Override
    public void timeoutHostRole(String host, long requestId, long stageId, String role) {
        this.timeoutHostRole(host, requestId, stageId, role, false, false);
    }

    @Override
    public void timeoutHostRole(String host, long requestId, long stageId, String role, boolean skipSupported, boolean hostUnknownState) {
        long now = System.currentTimeMillis();
        List<HostRoleCommandEntity> commands = this.hostRoleCommandDAO.findByHostRole(host, requestId, stageId, role);
        for (HostRoleCommandEntity command : commands) {
            if (skipSupported) {
                command.setStatus(HostRoleStatus.SKIPPED_FAILED);
            } else {
                command.setStatus(command.isRetryAllowed() ? HostRoleStatus.HOLDING_TIMEDOUT : (hostUnknownState ? HostRoleStatus.ABORTED : HostRoleStatus.TIMEDOUT));
            }
            command.setEndTime(now);
            this.auditLog(command, requestId);
        }
        if (!commands.isEmpty()) {
            this.hostRoleCommandDAO.mergeAll(commands);
        }
        this.endRequestIfCompleted(requestId);
    }

    @Override
    public List<Stage> getStagesInProgressForRequest(Long requestId) {
        List<StageEntity> stageEntities = this.stageDAO.findByRequestIdAndCommandStatuses(requestId, HostRoleStatus.IN_PROGRESS_STATUSES);
        return this.getStagesForEntities(stageEntities);
    }

    @Override
    public List<Stage> getFirstStageInProgressPerRequest() {
        List<StageEntity> stageEntities = this.stageDAO.findFirstStageByStatus(HostRoleStatus.IN_PROGRESS_STATUSES);
        ArrayList<Stage> stages = new ArrayList<Stage>(stageEntities.size());
        for (StageEntity stageEntity : stageEntities) {
            stages.add(this.stageFactory.createExisting(stageEntity));
        }
        return stages;
    }

    private List<Stage> getStagesForEntities(List<StageEntity> stageEntities) {
        ArrayList<Stage> stages = new ArrayList<Stage>(stageEntities.size());
        for (StageEntity stageEntity : stageEntities) {
            stages.add(this.stageFactory.createExisting(stageEntity));
        }
        return stages;
    }

    @Override
    public int getCommandsInProgressCount() {
        Number count = this.hostRoleCommandDAO.getCountByStatus(HostRoleStatus.IN_PROGRESS_STATUSES);
        if (null == count) {
            return 0;
        }
        return count.intValue();
    }

    @Override
    @Transactional
    @TransactionalLock(lockArea=TransactionalLock.LockArea.HRC_STATUS_CACHE, lockType=TransactionalLock.LockType.WRITE)
    public void persistActions(Request request) throws OBDPException {
        RequestEntity requestEntity = request.constructNewPersistenceEntity();
        Long clusterId = -1L;
        String clusterName = null;
        Long requestId = requestEntity.getRequestId();
        ClusterEntity clusterEntity = this.clusterDAO.findById(request.getClusterId());
        if (clusterEntity != null) {
            clusterId = clusterEntity.getClusterId();
            clusterName = clusterEntity.getClusterName();
        }
        requestEntity.setClusterId(clusterId);
        this.requestDAO.create(requestEntity);
        ArrayList<StageEntity> stageEntities = new ArrayList<StageEntity>(request.getStages().size());
        this.addRequestToAuditlogCache(request);
        ArrayList<HostRoleCommand> hostRoleCommands = new ArrayList<HostRoleCommand>();
        for (Stage stage : request.getStages()) {
            StageEntity stageEntity = stage.constructNewPersistenceEntity();
            Long stageId = stageEntity.getStageId();
            stageEntities.add(stageEntity);
            stageEntity.setClusterId(clusterId);
            stageEntity.setRequest(requestEntity);
            this.stageDAO.create(stageEntity);
            List<HostRoleCommand> orderedHostRoleCommands = stage.getOrderedHostRoleCommands();
            ArrayList<HostRoleCommandEntity> hostRoleCommandEntities = new ArrayList<HostRoleCommandEntity>();
            for (HostRoleCommand hostRoleCommand : orderedHostRoleCommands) {
                hostRoleCommand.setRequestId(requestId);
                hostRoleCommand.setStageId(stageId);
                HostRoleCommandEntity hostRoleCommandEntity = hostRoleCommand.constructNewPersistenceEntity();
                hostRoleCommandEntity.setStage(stageEntity);
                this.hostRoleCommandDAO.create(hostRoleCommandEntity);
                hostRoleCommandEntities.add(hostRoleCommandEntity);
                hostRoleCommand.setTaskId(hostRoleCommandEntity.getTaskId());
                Object prefix = "";
                String output = "output-" + hostRoleCommandEntity.getTaskId() + ".txt";
                String error = "errors-" + hostRoleCommandEntity.getTaskId() + ".txt";
                HostEntity hostEntity = null;
                if (null != hostRoleCommandEntity.getHostId()) {
                    hostEntity = this.hostDAO.findById(hostRoleCommandEntity.getHostId());
                    if (hostEntity == null) {
                        String msg = String.format("Host %s doesn't exist in database", hostRoleCommandEntity.getHostName());
                        LOG.error(msg);
                        throw new OBDPException(msg);
                    }
                    hostRoleCommandEntity.setHostEntity(hostEntity);
                    try {
                        Host hostObject = this.clusters.getHost(hostEntity.getHostName());
                        if (!StringUtils.isBlank((String)hostObject.getPrefix()) && !((String)(prefix = hostObject.getPrefix())).endsWith("/")) {
                            prefix = (String)prefix + "/";
                        }
                    }
                    catch (OBDPException e) {
                        LOG.warn("Exception in getting prefix for host and setting output and error log files.  Using no prefix");
                    }
                }
                hostRoleCommand.setOutputLog((String)prefix + output);
                hostRoleCommand.setErrorLog((String)prefix + error);
                hostRoleCommandEntity.setOutputLog(hostRoleCommand.getOutputLog());
                hostRoleCommandEntity.setErrorLog(hostRoleCommand.getErrorLog());
                ExecutionCommandEntity executionCommandEntity = hostRoleCommand.constructExecutionCommandEntity();
                executionCommandEntity.setHostRoleCommand(hostRoleCommandEntity);
                executionCommandEntity.setTaskId(hostRoleCommandEntity.getTaskId());
                hostRoleCommandEntity.setExecutionCommand(executionCommandEntity);
                this.executionCommandDAO.create(hostRoleCommandEntity.getExecutionCommand());
                hostRoleCommandEntity = this.hostRoleCommandDAO.mergeWithoutPublishEvent(hostRoleCommandEntity);
                if (null != hostEntity) {
                    hostEntity = this.hostDAO.merge(hostEntity);
                }
                hostRoleCommands.add(hostRoleCommand);
            }
            for (RoleSuccessCriteriaEntity roleSuccessCriteriaEntity : stageEntity.getRoleSuccessCriterias()) {
                this.roleSuccessCriteriaDAO.create(roleSuccessCriteriaEntity);
            }
            stageEntity.setHostRoleCommands(hostRoleCommandEntities);
            stageEntity = this.stageDAO.merge(stageEntity);
        }
        requestEntity.setStages(stageEntities);
        this.requestDAO.merge(requestEntity);
        TaskCreateEvent taskCreateEvent = new TaskCreateEvent(hostRoleCommands);
        this.taskEventPublisher.publish(taskCreateEvent);
        List<HostRoleCommandEntity> hostRoleCommandEntities = this.hostRoleCommandDAO.findByRequest(requestEntity.getRequestId());
        if (clusterName != null) {
            this.STOMPUpdatePublisher.publish(new RequestUpdateEvent(requestEntity, this.hostRoleCommandDAO, this.topologyManager, clusterName, hostRoleCommandEntities));
        } else {
            LOG.debug("No STOMP request update event was fired for new request due no cluster related, request id: {}, command name: {}", (Object)requestEntity.getRequestId(), (Object)requestEntity.getCommandName());
        }
    }

    @Override
    @Transactional
    public void startRequest(long requestId) {
        RequestEntity requestEntity = this.getRequestEntity(requestId);
        if (requestEntity != null && requestEntity.getStartTime() == -1L) {
            requestEntity.setStartTime(System.currentTimeMillis());
            this.requestDAO.merge(requestEntity);
        }
    }

    @Override
    @Transactional
    public void endRequest(long requestId) {
        RequestEntity requestEntity = this.getRequestEntity(requestId);
        if (requestEntity != null && requestEntity.getEndTime() == -1L) {
            requestEntity.setEndTime(System.currentTimeMillis());
            this.requestDAO.merge(requestEntity);
            this.ambariEventPublisher.publish(new RequestFinishedEvent(requestEntity.getClusterId(), requestId));
        }
    }

    public void endRequestIfCompleted(long requestId) {
        if (this.requestDAO.isAllTasksCompleted(requestId)) {
            this.endRequest(requestId);
        }
    }

    @Override
    @Transactional
    public void setSourceScheduleForRequest(long requestId, long scheduleId) {
        RequestScheduleEntity scheduleEntity;
        RequestEntity requestEntity = this.requestDAO.findByPK(requestId);
        if (requestEntity != null) {
            scheduleEntity = this.requestScheduleDAO.findById(scheduleId);
            if (scheduleEntity == null) {
                String message = String.format("Request Schedule with id=%s not found", scheduleId);
                LOG.error(message);
                throw new RuntimeException(message);
            }
        } else {
            String message = String.format("Request with id=%s not found", scheduleId);
            LOG.error(message);
            throw new RuntimeException(message);
        }
        requestEntity.setRequestScheduleEntity(scheduleEntity);
        scheduleEntity.getRequestEntities().add(requestEntity);
        this.requestDAO.merge(requestEntity);
        this.requestScheduleDAO.merge(scheduleEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateHostRoleStates(Collection<CommandReport> reports) {
        List<HostRoleCommandEntity> commandEntities;
        HashMap<Long, CommandReport> taskReports = new HashMap<Long, CommandReport>();
        for (CommandReport report : reports) {
            taskReports.put(report.getTaskId(), report);
        }
        long now = System.currentTimeMillis();
        ArrayList<Long> requestsToCheck = new ArrayList<Long>();
        try {
            this.hrcOperationsLock.readLock().lock();
            commandEntities = this.hostRoleCommandDAO.findByPKs(taskReports.keySet());
        }
        finally {
            this.hrcOperationsLock.readLock().unlock();
        }
        for (HostRoleCommandEntity commandEntity : commandEntities) {
            CommandReport report = (CommandReport)taskReports.get(commandEntity.getTaskId());
            HostRoleStatus existingTaskStatus = commandEntity.getStatus();
            HostRoleStatus reportedTaskStatus = HostRoleStatus.valueOf(report.getStatus());
            if (!existingTaskStatus.isCompletedState()) {
                // empty if block
            }
            if (!existingTaskStatus.isCompletedState() || existingTaskStatus == HostRoleStatus.ABORTED) {
                if (reportedTaskStatus == HostRoleStatus.FAILED && commandEntity.isRetryAllowed()) {
                    reportedTaskStatus = HostRoleStatus.HOLDING_FAILED;
                    if (commandEntity.isFailureAutoSkipped()) {
                        reportedTaskStatus = HostRoleStatus.SKIPPED_FAILED;
                    }
                }
                if (reportedTaskStatus == HostRoleStatus.TIMEDOUT && commandEntity.isRetryAllowed()) {
                    reportedTaskStatus = HostRoleStatus.HOLDING_TIMEDOUT;
                }
                if (!existingTaskStatus.isCompletedState()) {
                    LOG.debug("Setting status from {} to {} for {}", new Object[]{existingTaskStatus, reportedTaskStatus, commandEntity.getTaskId()});
                    commandEntity.setStatus(reportedTaskStatus);
                }
                commandEntity.setStdOut(report.getStdOut() == null ? null : report.getStdOut().getBytes());
                commandEntity.setStdError(report.getStdErr() == null ? null : report.getStdErr().getBytes());
                commandEntity.setStructuredOut(report.getStructuredOut() == null ? null : report.getStructuredOut().getBytes());
                commandEntity.setExitcode(report.getExitCode());
                if (commandEntity.getStatus().isCompletedState()) {
                    commandEntity.setEndTime(now);
                }
                try {
                    this.hrcOperationsLock.writeLock().lock();
                    this.hostRoleCommandDAO.merge(commandEntity);
                }
                finally {
                    this.hrcOperationsLock.writeLock().unlock();
                }
                if (!commandEntity.getStatus().isCompletedState()) continue;
                String actionId = report.getActionId();
                long[] requestStageIds = StageUtils.getRequestStage(actionId);
                long requestId = requestStageIds[0];
                long stageId = requestStageIds[1];
                this.auditLog(commandEntity, requestId);
                if (!this.requestDAO.getLastStageId(requestId).equals(stageId)) continue;
                requestsToCheck.add(requestId);
                continue;
            }
            LOG.warn(String.format("Request for invalid transition of host role command status received for task id %d from agent: %s -> %s", new Object[]{commandEntity.getTaskId(), existingTaskStatus, reportedTaskStatus}));
        }
        for (Long requestId : requestsToCheck) {
            this.endRequestIfCompleted(requestId);
        }
    }

    @Override
    public void updateHostRoleState(String hostname, long requestId, long stageId, String role, CommandReport report) {
        boolean checkRequest = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Update HostRoleState: HostName {} requestId {} stageId {} role {} report {}", new Object[]{hostname, requestId, stageId, role, report});
        }
        long now = System.currentTimeMillis();
        List<HostRoleCommandEntity> commands = this.hostRoleCommandDAO.findByHostRole(hostname, requestId, stageId, role);
        for (HostRoleCommandEntity command : commands) {
            HostRoleStatus status = HostRoleStatus.valueOf(report.getStatus());
            if (status == HostRoleStatus.FAILED && command.isRetryAllowed()) {
                status = HostRoleStatus.HOLDING_FAILED;
                if (command.isFailureAutoSkipped()) {
                    status = HostRoleStatus.SKIPPED_FAILED;
                }
            }
            if (status == HostRoleStatus.TIMEDOUT && command.isRetryAllowed()) {
                status = HostRoleStatus.HOLDING_TIMEDOUT;
            }
            command.setStatus(status);
            command.setStdOut(report.getStdOut().getBytes());
            command.setStdError(report.getStdErr().getBytes());
            command.setStructuredOut(report.getStructuredOut() == null ? null : report.getStructuredOut().getBytes());
            if (HostRoleStatus.getCompletedStates().contains((Object)command.getStatus())) {
                command.setEndTime(now);
                if (this.requestDAO.getLastStageId(requestId).equals(stageId)) {
                    checkRequest = true;
                }
            }
            command.setExitcode(report.getExitCode());
            this.auditLog(command, requestId);
        }
        if (!commands.isEmpty()) {
            this.hostRoleCommandDAO.mergeAll(commands);
        }
        if (checkRequest) {
            this.endRequestIfCompleted(requestId);
        }
    }

    @Override
    public void abortHostRole(String host, long requestId, long stageId, String role) {
        String reason = String.format("On host %s role %s in invalid state.", host, role);
        this.abortHostRole(host, requestId, stageId, role, reason);
    }

    @Override
    public void abortHostRole(String host, long requestId, long stageId, String role, String reason) {
        CommandReport report = new CommandReport();
        report.setExitCode(999);
        report.setStdErr(reason);
        report.setStdOut("");
        report.setStatus("ABORTED");
        this.updateHostRoleState(host, requestId, stageId, role, report);
    }

    @Override
    public long getLastPersistedRequestIdWhenInitialized() {
        return this.requestId;
    }

    @Override
    @Transactional
    public void bulkHostRoleScheduled(Stage s, List<ExecutionCommand> commands) {
        for (ExecutionCommand command : commands) {
            this.hostRoleScheduled(s, command.getHostname(), command.getRole());
        }
    }

    @Override
    @Transactional
    public void bulkAbortHostRole(Stage s, Map<ExecutionCommand, String> commands) {
        for (ExecutionCommand command : commands.keySet()) {
            String reason = String.format("On host %s role %s in invalid state.\n%s", command.getHostname(), command.getRole(), commands.get(command));
            this.abortHostRole(command.getHostname(), s.getRequestId(), s.getStageId(), command.getRole(), reason);
        }
    }

    @Override
    @Transactional
    public void hostRoleScheduled(Stage s, String hostname, String roleStr) {
        HostRoleCommand hostRoleCommand = s.getHostRoleCommand(hostname, roleStr);
        HostRoleCommandEntity entity = this.hostRoleCommandDAO.findByPK(hostRoleCommand.getTaskId());
        if (entity != null) {
            entity.setStartTime(hostRoleCommand.getStartTime());
            if (entity.getOriginalStartTime() == null || entity.getOriginalStartTime() == -1L) {
                entity.setOriginalStartTime(System.currentTimeMillis());
            }
        } else {
            throw new RuntimeException("HostRoleCommand is not persisted, cannot update:\n" + hostRoleCommand);
        }
        entity.setLastAttemptTime(hostRoleCommand.getLastAttemptTime());
        entity.setStatus(hostRoleCommand.getStatus());
        entity.setAttemptCount(hostRoleCommand.getAttemptCount());
        this.auditLog(entity, s.getRequestId());
        this.hostRoleCommandDAO.merge(entity);
    }

    @Override
    public List<HostRoleCommand> getRequestTasks(long requestId) {
        return this.getTasks(this.hostRoleCommandDAO.findTaskIdsByRequest(requestId));
    }

    @Override
    public List<HostRoleCommand> getAllTasksByRequestIds(Collection<Long> requestIds) {
        if (requestIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getTasks(this.hostRoleCommandDAO.findTaskIdsByRequestIds(requestIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HostRoleCommand> getTasks(Collection<Long> taskIds) {
        ArrayList<HostRoleCommand> commands;
        if (taskIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            this.hrcOperationsLock.readLock().lock();
            ImmutableMap cached = this.hostRoleCommandCache.getAllPresent(taskIds);
            commands = new ArrayList<HostRoleCommand>(cached.values());
            ArrayList<Long> absent = new ArrayList<Long>(taskIds);
            absent.removeAll(cached.keySet());
            if (!absent.isEmpty()) {
                for (HostRoleCommandEntity commandEntity : this.hostRoleCommandDAO.findByPKs(absent)) {
                    HostRoleCommand hostRoleCommand = this.hostRoleCommandFactory.createExisting(commandEntity);
                    commands.add(hostRoleCommand);
                    this.cacheHostRoleCommand(hostRoleCommand);
                }
            }
            commands.sort((o1, o2) -> (int)(o1.getTaskId() - o2.getTaskId()));
        }
        finally {
            this.hrcOperationsLock.readLock().unlock();
        }
        return commands;
    }

    private void cacheHostRoleCommand(HostRoleCommand hostRoleCommand) {
        if (this.hostRoleCommandCache.size() <= this.cacheLimit) {
            switch (hostRoleCommand.getStatus()) {
                case ABORTED: 
                case COMPLETED: 
                case TIMEDOUT: 
                case FAILED: {
                    this.hostRoleCommandCache.put((Object)hostRoleCommand.getTaskId(), (Object)hostRoleCommand);
                    break;
                }
            }
        }
    }

    @Override
    public List<HostRoleCommand> getTasksByHostRoleAndStatus(String hostname, String role, HostRoleStatus status) {
        return this.getTasks(this.hostRoleCommandDAO.findTaskIdsByHostRoleAndStatus(hostname, role, status));
    }

    @Override
    public List<HostRoleCommand> getTasksByRoleAndStatus(String role, HostRoleStatus status) {
        return this.getTasks(this.hostRoleCommandDAO.findTaskIdsByRoleAndStatus(role, status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostRoleCommand getTask(long taskId) {
        try {
            this.hrcOperationsLock.readLock().lock();
            HostRoleCommandEntity commandEntity = this.hostRoleCommandDAO.findByPK(taskId);
            if (commandEntity == null) {
                HostRoleCommand hostRoleCommand = null;
                return hostRoleCommand;
            }
            HostRoleCommand hostRoleCommand = this.hostRoleCommandFactory.createExisting(commandEntity);
            return hostRoleCommand;
        }
        finally {
            this.hrcOperationsLock.readLock().unlock();
        }
    }

    @Override
    public List<Long> getRequestsByStatus(RequestStatus status, int maxResults, boolean ascOrder) {
        if (null == status) {
            return this.requestDAO.findAllRequestIds(maxResults, ascOrder);
        }
        Set<HostRoleStatus> taskStatuses = null;
        switch (status) {
            case IN_PROGRESS: {
                taskStatuses = HostRoleStatus.IN_PROGRESS_STATUSES;
                break;
            }
            case FAILED: {
                taskStatuses = HostRoleStatus.FAILED_STATUSES;
                break;
            }
            case COMPLETED: {
                return this.hostRoleCommandDAO.getCompletedRequests(maxResults, ascOrder);
            }
        }
        return this.hostRoleCommandDAO.getRequestsByTaskStatus(taskStatuses, maxResults, ascOrder);
    }

    @Override
    public Map<Long, String> getRequestContext(List<Long> requestIds) {
        return this.stageDAO.findRequestContext(requestIds);
    }

    @Override
    public String getRequestContext(long requestId) {
        return this.stageDAO.findRequestContext(requestId);
    }

    @Override
    public List<Request> getRequests(Collection<Long> requestIds) {
        List<RequestEntity> requestEntities = this.requestDAO.findByPks(requestIds);
        ArrayList<Request> requests = new ArrayList<Request>(requestEntities.size());
        for (RequestEntity requestEntity : requestEntities) {
            requests.add(this.requestFactory.createExisting(requestEntity));
        }
        return requests;
    }

    @Override
    public void resubmitTasks(List<Long> taskIds) {
        List<HostRoleCommandEntity> tasks = this.hostRoleCommandDAO.findByPKs(taskIds);
        HashSet<RequestEntity> requestEntities = new HashSet<RequestEntity>();
        HashSet<StageEntity> stageEntities = new HashSet<StageEntity>();
        for (HostRoleCommandEntity task : tasks) {
            StageEntity stage = task.getStage();
            stage.setStatus(HostRoleStatus.PENDING);
            stageEntities.add(stage);
            RequestEntity request = stage.getRequest();
            request.setStatus(HostRoleStatus.IN_PROGRESS);
            requestEntities.add(request);
            task.setStatus(HostRoleStatus.PENDING);
            task.setStartTime(-1L);
            task.setEndTime(-1L);
            this.auditLog(task, task.getRequestId());
        }
        for (StageEntity stageEntity : stageEntities) {
            this.stageDAO.merge(stageEntity);
        }
        for (RequestEntity requestEntity : requestEntities) {
            this.requestDAO.merge(requestEntity);
        }
        if (!tasks.isEmpty()) {
            this.hostRoleCommandDAO.mergeAll(tasks);
        }
        this.hostRoleCommandCache.invalidateAll(taskIds);
    }

    @Subscribe
    public void invalidateCommandCacheOnHostRemove(HostsRemovedEvent event) {
        LOG.info("Invalidating HRC cache after receiveing {}", (Object)event);
        this.hostRoleCommandCache.invalidateAll();
    }

    private HostRoleStatus updateAuditlogCache(HostRoleCommandEntity commandEntity, Long requestId) {
        RequestDetails details = (RequestDetails)this.auditlogRequestCache.getIfPresent((Object)requestId);
        if (details == null) {
            return null;
        }
        RequestDetails.Component component = new RequestDetails.Component(commandEntity.getRole(), commandEntity.getHostName());
        HostRoleStatus lastTaskStatus = null;
        if (details.getTasks().containsKey(component)) {
            lastTaskStatus = details.getTasks().get(component);
        }
        details.getTasks().put(component, commandEntity.getStatus());
        return lastTaskStatus;
    }

    private void addRequestToAuditlogCache(Request request) {
        if (!this.auditLogger.isEnabled()) {
            return;
        }
        if (this.auditlogRequestCache.getIfPresent((Object)request.getRequestId()) == null) {
            int numberOfTasks = 0;
            for (Stage stage : request.getStages()) {
                numberOfTasks += stage.getOrderedHostRoleCommands().size();
            }
            RequestDetails requestDetails = new RequestDetails();
            requestDetails.setNumberOfTasks(numberOfTasks);
            requestDetails.setUserName(AuthorizationHelper.getAuthenticatedName());
            requestDetails.setProxyUserName(AuthorizationHelper.getProxyUserName());
            this.auditlogRequestCache.put((Object)request.getRequestId(), (Object)requestDetails);
        }
    }

    private void auditLog(HostRoleCommandEntity commandEntity, Long requestId) {
        if (!this.auditLogger.isEnabled()) {
            return;
        }
        if (requestId != null) {
            HostRoleStatus lastTaskStatus = this.updateAuditlogCache(commandEntity, requestId);
            RequestDetails details = (RequestDetails)this.auditlogRequestCache.getIfPresent((Object)requestId);
            if (details != null) {
                HostRoleStatus calculatedStatus = this.calculateStatus(requestId, details.getNumberOfTasks());
                if (details.getLastStatus() != calculatedStatus) {
                    RequestEntity request = this.requestDAO.findByPK(requestId);
                    String context = request != null ? request.getRequestContext() : null;
                    AuditEvent auditEvent = ((OperationStatusAuditEvent.OperationStatusAuditEventBuilder)((OperationStatusAuditEvent.OperationStatusAuditEventBuilder)((OperationStatusAuditEvent.OperationStatusAuditEventBuilder)OperationStatusAuditEvent.builder().withRequestId(String.valueOf(requestId)).withStatus(String.valueOf((Object)calculatedStatus)).withRequestContext(context).withUserName(details.getUserName())).withProxyUserName(details.getProxyUserName())).withTimestamp(System.currentTimeMillis())).build();
                    this.auditLogger.log(auditEvent);
                    details.setLastStatus(calculatedStatus);
                }
            }
            this.logTask(commandEntity, requestId, lastTaskStatus);
        }
    }

    private HostRoleStatus calculateStatus(Long requestId, int numberOfTasks) {
        RequestDetails details = (RequestDetails)this.auditlogRequestCache.getIfPresent((Object)requestId);
        if (details == null) {
            return HostRoleStatus.QUEUED;
        }
        Collection<HostRoleStatus> taskStatuses = details.getTaskStatuses();
        return CalculatedStatus.calculateSummaryStatus(CalculatedStatus.calculateStatusCounts(taskStatuses), numberOfTasks, false);
    }

    private void logTask(HostRoleCommandEntity commandEntity, Long requestId, HostRoleStatus lastTaskStatus) {
        RequestDetails.Component component = new RequestDetails.Component(commandEntity.getRole(), commandEntity.getHostName());
        RequestDetails details = (RequestDetails)this.auditlogRequestCache.getIfPresent((Object)requestId);
        if (details == null) {
            return;
        }
        HostRoleStatus cachedStatus = details.getTasks().get(component);
        if (lastTaskStatus == null || cachedStatus != lastTaskStatus) {
            AuditEvent taskEvent = ((TaskStatusAuditEvent.TaskStatusAuditEventBuilder)((TaskStatusAuditEvent.TaskStatusAuditEventBuilder)((TaskStatusAuditEvent.TaskStatusAuditEventBuilder)TaskStatusAuditEvent.builder().withTaskId(String.valueOf(commandEntity.getTaskId())).withHostName(commandEntity.getHostName()).withUserName(details.getUserName())).withProxyUserName(details.getProxyUserName())).withOperation(commandEntity.getRoleCommand() + " " + commandEntity.getRole()).withDetails(commandEntity.getCommandDetail()).withStatus(commandEntity.getStatus().toString()).withRequestId(String.valueOf(requestId)).withTimestamp(System.currentTimeMillis())).build();
            this.auditLogger.log(taskEvent);
        }
    }

    private static class RequestDetails {
        HostRoleStatus lastStatus = null;
        int numberOfTasks = 0;
        String userName;
        Map<Component, HostRoleStatus> tasks = new HashMap<Component, HostRoleStatus>();
        private String proxyUserName;

        private RequestDetails() {
        }

        public HostRoleStatus getLastStatus() {
            return this.lastStatus;
        }

        public void setLastStatus(HostRoleStatus lastStatus) {
            this.lastStatus = lastStatus;
        }

        public int getNumberOfTasks() {
            return this.numberOfTasks;
        }

        public void setNumberOfTasks(int numberOfTasks) {
            this.numberOfTasks = numberOfTasks;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public Map<Component, HostRoleStatus> getTasks() {
            return this.tasks;
        }

        public Collection<HostRoleStatus> getTaskStatuses() {
            return this.getTasks().values();
        }

        public String getProxyUserName() {
            return this.proxyUserName;
        }

        public void setProxyUserName(String proxyUserName) {
            this.proxyUserName = proxyUserName;
        }

        static class Component {
            private final Role role;
            private final String hostName;

            Component(Role role, String hostName) {
                this.role = role;
                this.hostName = hostName;
            }

            public Role getRole() {
                return this.role;
            }

            public String getHostName() {
                return this.hostName;
            }

            public final int hashCode() {
                int hash = 7;
                String roleStr = this.role == null ? "null" : this.role.toString();
                String hostNameStr = this.hostName == null ? "null" : this.hostName;
                String str = roleStr.concat(hostNameStr);
                for (int i = 0; i < str.length(); ++i) {
                    hash = hash * 31 + str.charAt(i);
                }
                return hash;
            }

            public final boolean equals(Object other) {
                if (other instanceof Component) {
                    Component comp = (Component)other;
                    return Objects.equals(comp.role, this.role) && Objects.equals(comp.hostName, this.hostName);
                }
                return false;
            }
        }
    }
}

