/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server;

import com.google.inject.Inject;
import id.onyx.obdp.server.orm.dao.HostVersionDAO;
import id.onyx.obdp.server.orm.dao.ServiceComponentDesiredStateDAO;
import id.onyx.obdp.server.orm.entities.HostVersionEntity;
import id.onyx.obdp.server.orm.entities.ServiceComponentDesiredStateEntity;
import id.onyx.obdp.server.state.RepositoryVersionState;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateRecoveryManager {
    private static final Logger LOG = LoggerFactory.getLogger(StateRecoveryManager.class);
    @Inject
    private HostVersionDAO hostVersionDAO;
    @Inject
    private ServiceComponentDesiredStateDAO serviceComponentDAO;

    public void doWork() {
        this.checkHostAndClusterVersions();
    }

    void checkHostAndClusterVersions() {
        List hostVersions = this.hostVersionDAO.findAll();
        for (HostVersionEntity hostVersion : hostVersions) {
            if (!hostVersion.getState().equals((Object)RepositoryVersionState.INSTALLING)) continue;
            hostVersion.setState(RepositoryVersionState.INSTALL_FAILED);
            String msg = String.format("Recovered state of host version %s on host %s from %s to %s", new Object[]{hostVersion.getRepositoryVersion().getDisplayName(), hostVersion.getHostName(), RepositoryVersionState.INSTALLING, RepositoryVersionState.INSTALL_FAILED});
            LOG.warn(msg);
            this.hostVersionDAO.merge(hostVersion);
        }
        List<ServiceComponentDesiredStateEntity> components = this.serviceComponentDAO.findAll();
        for (ServiceComponentDesiredStateEntity component : components) {
            if (RepositoryVersionState.INSTALLING != component.getRepositoryState()) continue;
            component.setRepositoryState(RepositoryVersionState.INSTALL_FAILED);
            this.serviceComponentDAO.merge(component);
            String msg = String.format("Recovered state of cluster %s of component %s/%s for version %s from %s to %s", new Object[]{component.getClusterId(), component.getServiceName(), component.getComponentName(), component.getDesiredRepositoryVersion().getDisplayName(), RepositoryVersionState.INSTALLING, RepositoryVersionState.INSTALL_FAILED});
            LOG.warn(msg);
        }
    }
}

