/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.configuration.Configuration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.kerberos.client.KdcConfig;
import org.apache.directory.kerberos.client.KdcConnection;
import org.apache.directory.shared.kerberos.KerberosMessageType;
import org.apache.directory.shared.kerberos.exceptions.ErrorType;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;
import org.apache.directory.shared.kerberos.messages.KrbError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KdcServerConnectionVerification {
    private static final Logger LOG = LoggerFactory.getLogger(KdcServerConnectionVerification.class);
    private Configuration config;
    private int connectionTimeout = 10;

    @Inject
    public KdcServerConnectionVerification(Configuration config) {
        this.config = config;
    }

    public boolean isKdcReachable(String kdcHost) {
        try {
            if (kdcHost == null || kdcHost.isEmpty()) {
                throw new IllegalArgumentException("Invalid hostname for KDC server");
            }
            String[] kdcDetails = kdcHost.split(":");
            if (kdcDetails.length == 1) {
                return this.isKdcReachable(kdcDetails[0], this.parsePort(this.config.getDefaultKdcPort()));
            }
            return this.isKdcReachable(kdcDetails[0], this.parsePort(kdcDetails[1]));
        }
        catch (Exception e) {
            LOG.error("Exception while checking KDC reachability: " + e);
            return false;
        }
    }

    public boolean isKdcReachable(String server, int port) {
        boolean success;
        boolean bl = success = this.isKdcReachable(server, port, ConnectionProtocol.TCP) || this.isKdcReachable(server, port, ConnectionProtocol.UDP);
        if (!success) {
            LOG.error("Failed to connect to the KDC at {}:{} using either TCP or UDP", (Object)server, (Object)port);
        }
        return success;
    }

    public boolean isKdcReachable(final String server, final int port, final ConnectionProtocol connectionProtocol) {
        Boolean result;
        int timeoutMillis = this.connectionTimeout * 1000;
        final KdcConfig config = KdcConfig.getDefaultConfig();
        config.setHostName(server);
        config.setKdcPort(port);
        config.setUseUdp(ConnectionProtocol.UDP == connectionProtocol);
        config.setTimeout(timeoutMillis);
        FutureTask<Boolean> future = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Boolean success;
                try {
                    KdcConnection connection = KdcServerConnectionVerification.this.getKdcConnection(config);
                    connection.getTgt("noUser@noRealm", "noPassword");
                    LOG.info(String.format("Encountered no Exceptions while testing connectivity to the KDC:\n**** Host: %s:%d (%s)", server, port, connectionProtocol.name()));
                    success = true;
                }
                catch (KerberosException e) {
                    int errorCodeCode;
                    String errorCodeMessage;
                    KrbError error = e.getError();
                    ErrorType errorCode = error.getErrorCode();
                    if (errorCode != null) {
                        errorCodeMessage = errorCode.getMessage();
                        errorCodeCode = errorCode.getValue();
                    } else {
                        errorCodeMessage = "<Not Specified>";
                        errorCodeCode = -1;
                    }
                    success = errorCodeCode != ErrorType.KRB_ERR_GENERIC.getValue() || !errorCodeMessage.contains("TimeOut");
                    if (!success.booleanValue() || LOG.isDebugEnabled()) {
                        int messageTypeCode;
                        String messageTypeMessage;
                        KerberosMessageType messageType = error.getMessageType();
                        if (messageType != null) {
                            messageTypeMessage = messageType.getMessage();
                            messageTypeCode = messageType.getValue();
                        } else {
                            messageTypeMessage = "<Not Specified>";
                            messageTypeCode = -1;
                        }
                        String message = String.format("Received KerberosException while testing connectivity to the KDC: %s\n**** Host:    %s:%d (%s)\n**** Error:   %s\n**** Code:    %d (%s)\n**** Message: %d (%s)", e.getLocalizedMessage(), server, port, connectionProtocol.name(), error.getEText(), errorCodeCode, errorCodeMessage, messageTypeCode, messageTypeMessage);
                        if (LOG.isDebugEnabled()) {
                            LOG.info(message, (Throwable)e);
                        } else {
                            LOG.info(message);
                        }
                    }
                }
                catch (Throwable e) {
                    LOG.info(String.format("Received Exception while testing connectivity to the KDC: %s\n**** Host: %s:%d (%s)", e.getLocalizedMessage(), server, port, connectionProtocol.name()), e);
                    throw new RuntimeException(e);
                }
                return success;
            }
        });
        new Thread(future, "ambari-kdc-verify").start();
        try {
            result = future.get(timeoutMillis, TimeUnit.MILLISECONDS);
            if (result.booleanValue()) {
                LOG.info(String.format("Successfully connected to the KDC server at %s:%d over %s", server, port, connectionProtocol.name()));
            } else {
                LOG.warn(String.format("Failed to connect to the KDC server at %s:%d over %s", server, port, connectionProtocol.name()));
            }
        }
        catch (InterruptedException e) {
            String message = String.format("Interrupted while trying to communicate with KDC server at %s:%d over %s", server, port, connectionProtocol.name());
            if (LOG.isDebugEnabled()) {
                LOG.warn(message, (Throwable)e);
            } else {
                LOG.warn(message);
            }
            result = false;
            future.cancel(true);
        }
        catch (ExecutionException e) {
            String message = String.format("An unexpected exception occurred while attempting to communicate with the KDC server at %s:%d over %s", server, port, connectionProtocol.name());
            if (LOG.isDebugEnabled()) {
                LOG.warn(message, (Throwable)e);
            } else {
                LOG.warn(message);
            }
            result = false;
        }
        catch (TimeoutException e) {
            String message = String.format("Timeout occurred while attempting to to communicate with KDC server at %s:%d over %s", server, port, connectionProtocol.name());
            if (LOG.isDebugEnabled()) {
                LOG.warn(message, (Throwable)e);
            } else {
                LOG.warn(message);
            }
            result = false;
            future.cancel(true);
        }
        return result;
    }

    protected KdcConnection getKdcConnection(KdcConfig config) {
        return new KdcConnection(config);
    }

    public void setConnectionTimeout(int timeoutSeconds) {
        this.connectionTimeout = timeoutSeconds < 1 ? 1 : timeoutSeconds;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    protected int parsePort(String port) {
        if (StringUtils.isEmpty((String)port)) {
            throw new IllegalArgumentException("Port number must be non-empty, non-null positive integer");
        }
        return Integer.parseInt(port);
    }

    public static enum ConnectionProtocol {
        TCP,
        UDP;

    }
}

