/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.annotations;

import id.onyx.obdp.server.configuration.Configuration;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface TransactionalLock {
    public LockArea lockArea();

    public LockType lockType();

    public static enum LockType {
        READ,
        WRITE;

    }

    public static enum LockArea {
        HRC_STATUS_CACHE(Configuration.SERVER_HRC_STATUS_SUMMARY_CACHE_ENABLED.getKey());

        private static final Logger LOG;
        private String m_configurationProperty;
        private Boolean m_enabled = null;

        private LockArea(String configurationProperty) {
            this.m_configurationProperty = configurationProperty;
        }

        public boolean isEnabled(Configuration configuration) {
            if (null != this.m_enabled) {
                return this.m_enabled;
            }
            this.m_enabled = Boolean.TRUE;
            String property = configuration.getProperty(this.m_configurationProperty);
            if (null != property) {
                try {
                    this.m_enabled = Boolean.valueOf(property);
                }
                catch (Exception exception) {
                    LOG.error("Unable to determine if the lock area {} is enabled, defaulting to TRUE", (Object)this.m_configurationProperty, (Object)exception);
                }
            }
            LOG.info("LockArea {} is {}", (Object)this.name(), (Object)(this.m_enabled != false ? "enabled" : "disabled"));
            return this.m_enabled;
        }

        void clearEnabled() {
            this.m_enabled = null;
        }

        static {
            LOG = LoggerFactory.getLogger(LockArea.class);
        }
    }
}

