/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.persist.jpa;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.persist.PersistModule;
import com.google.inject.persist.PersistService;
import com.google.inject.persist.UnitOfWork;
import com.google.inject.persist.finder.DynamicFinder;
import com.google.inject.persist.finder.Finder;
import com.google.inject.persist.jpa.Jpa;
import com.google.inject.persist.jpa.JpaFinderProxy;
import com.google.inject.persist.jpa.JpaPersistOptions;
import com.google.inject.persist.jpa.JpaPersistService;
import com.google.inject.persist.jpa.OBDPJpaPersistService;
import id.onyx.obdp.server.orm.OBDPJpaLocalTxnInterceptor;
import id.onyx.obdp.server.orm.OBDPLocalSessionInterceptor;
import id.onyx.obdp.server.orm.RequiresSession;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class OBDPJpaPersistModule
extends PersistModule {
    private final String jpaUnit;
    private Map<?, ?> properties;
    private MethodInterceptor transactionInterceptor;
    private final List<Class<?>> dynamicFinders = Lists.newArrayList();

    public OBDPJpaPersistModule(String jpaUnit) {
        if (null == jpaUnit || jpaUnit.length() <= 0) {
            throw new IllegalArgumentException("jpaUnit should not be null");
        }
        this.jpaUnit = jpaUnit;
    }

    protected void configurePersistence() {
        this.bindConstant().annotatedWith(Jpa.class).to(this.jpaUnit);
        this.bind(OBDPJpaPersistService.class).in(Singleton.class);
        this.bind(JpaPersistOptions.class).annotatedWith(Jpa.class).toInstance((Object)JpaPersistOptions.builder().setAutoBeginWorkOnEntityManagerCreation(true).build());
        this.bind(PersistService.class).to(OBDPJpaPersistService.class);
        this.bind(UnitOfWork.class).to(OBDPJpaPersistService.class);
        this.bind(EntityManager.class).toProvider(OBDPJpaPersistService.class);
        this.bind(EntityManagerFactory.class).toProvider(JpaPersistService.EntityManagerFactoryProvider.class);
        this.transactionInterceptor = new OBDPJpaLocalTxnInterceptor();
        this.requestInjection(this.transactionInterceptor);
        OBDPLocalSessionInterceptor sessionInterceptor = new OBDPLocalSessionInterceptor();
        this.requestInjection(sessionInterceptor);
        for (Class<?> finder : this.dynamicFinders) {
            this.bindFinder(finder);
        }
        this.bindInterceptor(Matchers.annotatedWith(RequiresSession.class), Matchers.any(), new MethodInterceptor[]{sessionInterceptor});
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(RequiresSession.class), new MethodInterceptor[]{sessionInterceptor});
    }

    protected MethodInterceptor getTransactionInterceptor() {
        return this.transactionInterceptor;
    }

    @Provides
    @Jpa
    Map<?, ?> provideProperties() {
        return this.properties;
    }

    public OBDPJpaPersistModule properties(Map<?, ?> properties) {
        this.properties = properties;
        return this;
    }

    public <T> OBDPJpaPersistModule addFinder(Class<T> iface) {
        this.dynamicFinders.add(iface);
        return this;
    }

    private <T> void bindFinder(Class<T> iface) {
        if (!this.isDynamicFinderValid(iface)) {
            return;
        }
        InvocationHandler finderInvoker = new InvocationHandler(){
            @Inject
            JpaFinderProxy finderProxy;

            @Override
            public Object invoke(final Object thisObject, final Method method, final Object[] args) throws Throwable {
                if (!method.isAnnotationPresent(Finder.class)) {
                    return method.invoke((Object)this, args);
                }
                return this.finderProxy.invoke(new MethodInvocation(){

                    public Method getMethod() {
                        return method;
                    }

                    public Object[] getArguments() {
                        return null == args ? new Object[]{} : args;
                    }

                    public Object proceed() throws Throwable {
                        return method.invoke(thisObject, args);
                    }

                    public Object getThis() {
                        throw new UnsupportedOperationException("Bottomless proxies don't expose a this.");
                    }

                    public AccessibleObject getStaticPart() {
                        throw new UnsupportedOperationException();
                    }
                });
            }
        };
        this.requestInjection(finderInvoker);
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{iface}, finderInvoker);
        this.bind(iface).toInstance(proxy);
    }

    private boolean isDynamicFinderValid(Class<?> iface) {
        boolean valid = true;
        if (!iface.isInterface()) {
            this.addError(iface + " is not an interface. Dynamic Finders must be interfaces.", new Object[0]);
            valid = false;
        }
        for (Method method : iface.getMethods()) {
            DynamicFinder finder = DynamicFinder.from((Method)method);
            if (null != finder) continue;
            this.addError("Dynamic Finder methods must be annotated with @Finder, but " + iface + "." + method.getName() + " was not", new Object[0]);
            valid = false;
        }
        return valid;
    }

    private class LocalTypeLiteral<T>
    extends TypeLiteral<T> {
        private LocalTypeLiteral() {
        }
    }
}

