/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.tools.zk;

import id.onyx.obdp.tools.zk.ZkAcl;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;

public class ZkPathPattern {
    private final List<Segment> segments;

    public static ZkPathPattern fromString(String pattern) {
        if (!(pattern = pattern.trim()).startsWith("/")) {
            throw new IllegalArgumentException("ZkPath must start with: '/'. Invalid path: " + pattern);
        }
        if ("/".equals(pattern)) {
            return new ZkPathPattern(Collections.singletonList(new Segment("*")));
        }
        ArrayList<Segment> segments = new ArrayList<Segment>();
        for (String segment : pattern.substring(1).split("/")) {
            if (segment.isEmpty()) {
                throw new IllegalArgumentException("Invalid ZkPath: " + pattern);
            }
            segments.add(new Segment(segment));
        }
        if (segments.isEmpty()) {
            throw new IllegalArgumentException("Empty ZkPath: " + pattern);
        }
        return new ZkPathPattern(segments);
    }

    private ZkPathPattern(List<Segment> segments) {
        this.segments = segments;
    }

    public List<String> findMatchingPaths(ZooKeeper zkClient, String basePath) throws KeeperException, InterruptedException {
        ArrayList<String> result = new ArrayList<String>();
        this.collectMatching(zkClient, basePath, result);
        return result;
    }

    private void collectMatching(ZooKeeper zkClient, String basePath, List<String> result) throws KeeperException, InterruptedException {
        for (String child : zkClient.getChildren(basePath, null)) {
            if (!this.first().matches(child)) continue;
            if (this.rest() == null) {
                result.add(ZkAcl.append(basePath, child));
                continue;
            }
            this.rest().collectMatching(zkClient, ZkAcl.append(basePath, child), result);
        }
    }

    private Segment first() {
        return this.segments.get(0);
    }

    private ZkPathPattern rest() {
        List<Segment> tail = this.segments.subList(1, this.segments.size());
        return tail.isEmpty() ? null : new ZkPathPattern(tail);
    }

    public static class Segment {
        private final PathMatcher glob;

        public Segment(String segment) {
            this.glob = FileSystems.getDefault().getPathMatcher("glob:" + segment);
        }

        public boolean matches(String node) {
            return this.glob.matches(Paths.get(node, new String[0]));
        }
    }
}

