/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.tools.zk;

import id.onyx.obdp.tools.zk.ZkAcl;
import id.onyx.obdp.tools.zk.ZkConnection;
import id.onyx.obdp.tools.zk.ZkPathPattern;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;

public class ZkMigrator {
    private static final int SESSION_TIMEOUT_MILLIS = 5000;
    private static final int CONNECTION_TIMEOUT_MILLIS = 30000;

    public static void main(String[] args) throws Exception {
        CommandLine cli = new DefaultParser().parse(ZkMigrator.options(), args);
        if (cli.hasOption("connection-string") && cli.hasOption("znode")) {
            if (cli.hasOption("acl") && !cli.hasOption("delete")) {
                ZkMigrator.setAcls(cli.getOptionValue("connection-string"), cli.getOptionValue("znode"), ZkAcl.parse(cli.getOptionValue("acl")));
            } else if (cli.hasOption("delete") && !cli.hasOption("acl")) {
                ZkMigrator.deleteZnodeRecursively(cli.getOptionValue("connection-string"), cli.getOptionValue("znode"));
            } else {
                ZkMigrator.printHelp();
            }
        } else {
            ZkMigrator.printHelp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteZnodeRecursively(String connectionString, String znode) throws IOException, InterruptedException, KeeperException {
        try (ZooKeeper client = ZkConnection.open(connectionString, 5000, 30000);){
            ZkPathPattern paths = ZkPathPattern.fromString(znode);
            for (String path : paths.findMatchingPaths(client, "/")) {
                System.out.println("Recursively deleting znodes with matching path " + path);
                ZkMigrator.deleteZnodeRecursively(client, path);
            }
        }
    }

    private static void deleteZnodeRecursively(ZooKeeper zkClient, String baseNode) throws KeeperException, InterruptedException {
        for (String child : zkClient.getChildren(baseNode, null)) {
            ZkMigrator.deleteZnodeRecursively(zkClient, ZkAcl.append(baseNode, child));
        }
        System.out.println("Deleting znode " + baseNode);
        zkClient.delete(baseNode, -1);
    }

    private static Options options() {
        return new Options().addOption(Option.builder((String)"h").longOpt("help").desc("print help").build()).addOption(Option.builder((String)"c").longOpt("connection-string").desc("zookeeper connection string").hasArg().argName("connection-string").build()).addOption(Option.builder((String)"a").longOpt("acl").desc("ACL of a znode in the following format <scheme:id:permission>").hasArg().argName("acl").build()).addOption(Option.builder((String)"z").longOpt("znode").desc("znode path").hasArg().argName("znode").build()).addOption(Option.builder((String)"d").longOpt("delete").desc("delete specified znode and all it's children recursively").argName("delete").build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setAcls(String connectionString, String znode, ZkAcl acl) throws IOException, InterruptedException, KeeperException {
        try (ZooKeeper client = ZkConnection.open(connectionString, 5000, 30000);){
            acl.setRecursivelyOn(client, ZkPathPattern.fromString(znode));
        }
    }

    private static void printHelp() {
        System.out.println("Usage zkmigrator -connection-string <host:port> -acl <scheme:id:permission> -znode /path/to/znode\n              OR -connection-string <host:port> -znode /path/to/znode -delete");
        System.exit(1);
    }
}

