/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.tools.zk;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class ZkConnection {
    public static ZooKeeper open(String serverAddress, int sessionTimeoutMillis, int connectionTimeoutMillis) throws IOException, InterruptedException, IllegalStateException {
        final CountDownLatch connSignal = new CountDownLatch(1);
        ZooKeeper zooKeeper = new ZooKeeper(serverAddress, sessionTimeoutMillis, new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    connSignal.countDown();
                }
            }
        });
        connSignal.await(connectionTimeoutMillis, TimeUnit.MILLISECONDS);
        return zooKeeper;
    }
}

