/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.tools.zk;

import id.onyx.obdp.tools.zk.ZkPathPattern;
import java.util.Collections;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;

public class ZkAcl {
    private static final int ANY_NODE_VER = -1;
    private final AclScheme scheme;
    private final String id;
    private final Permission permission;

    public static ZkAcl parse(String acl) {
        String[] parts = acl.split(":");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid ACL: " + acl + " must be <scheme:id:permission>");
        }
        return new ZkAcl(AclScheme.parse(parts[0]), parts[1], Permission.parse(parts[2]));
    }

    private ZkAcl(AclScheme scheme, String id, Permission permission) {
        this.scheme = scheme;
        this.id = id;
        this.permission = permission;
    }

    public void setRecursivelyOn(ZooKeeper zkClient, ZkPathPattern pattern) throws KeeperException, InterruptedException {
        for (String each : pattern.findMatchingPaths(zkClient, "/")) {
            System.out.println("Set ACL " + this.asZkAcl() + " recursively on " + each);
            this.setRecursivelyOnSingle(zkClient, each);
        }
    }

    public void setRecursivelyOnSingle(ZooKeeper zkClient, String baseNode) throws KeeperException, InterruptedException {
        zkClient.setACL(baseNode, Collections.singletonList(this.asZkAcl()), -1);
        for (String child : zkClient.getChildren(baseNode, null)) {
            this.setRecursivelyOnSingle(zkClient, ZkAcl.append(baseNode, child));
        }
    }

    private ACL asZkAcl() {
        return new ACL(this.permission.code, new Id(this.scheme.value, this.id));
    }

    public static String append(String node, String child) {
        return node.endsWith("/") ? node + child : node + "/" + child;
    }

    static class AclScheme {
        final String value;

        public static AclScheme parse(String scheme) {
            if (scheme.toLowerCase().equals("world") || scheme.toLowerCase().equals("ip")) {
                return new AclScheme(scheme);
            }
            throw new IllegalArgumentException("Unsupported scheme: " + scheme);
        }

        private AclScheme(String value) {
            this.value = value;
        }
    }

    static class Permission {
        final int code;

        public static Permission parse(String permission) {
            int permissionCode = 0;
            block7: for (char each : permission.toLowerCase().toCharArray()) {
                switch (each) {
                    case 'r': {
                        permissionCode |= 1;
                        continue block7;
                    }
                    case 'w': {
                        permissionCode |= 2;
                        continue block7;
                    }
                    case 'c': {
                        permissionCode |= 4;
                        continue block7;
                    }
                    case 'd': {
                        permissionCode |= 8;
                        continue block7;
                    }
                    case 'a': {
                        permissionCode |= 0x10;
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported permission: " + permission);
                    }
                }
            }
            return new Permission(permissionCode);
        }

        private Permission(int code) {
            this.code = code;
        }
    }
}

