/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.tools.jce;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.UnrecognizedOptionException;

public class JcePolicyInfo {
    public static void main(String[] args) throws Exception {
        try {
            boolean showHelp = true;
            CommandLine cli = new DefaultParser().parse(JcePolicyInfo.options(), args);
            if (cli.hasOption("lc")) {
                JcePolicyInfo.listCiphers();
                showHelp = false;
            }
            if (cli.hasOption("tu")) {
                JcePolicyInfo.testUnlimitedKeyJCEPolicy();
                showHelp = false;
            }
            if (showHelp) {
                JcePolicyInfo.printHelp(null);
            }
        }
        catch (UnrecognizedOptionException e) {
            JcePolicyInfo.printHelp(e);
        }
    }

    private static void printHelp(UnrecognizedOptionException exception) {
        HelpFormatter helpFormatter = new HelpFormatter();
        if (exception == null) {
            helpFormatter.printHelp("jcepolicyinfo [options]", JcePolicyInfo.options());
        } else {
            helpFormatter.printHelp("jcepolicyinfo [options]", exception.getLocalizedMessage(), JcePolicyInfo.options(), null);
        }
        System.exit(1);
    }

    private static Options options() {
        return new Options().addOption(Option.builder((String)"h").longOpt("help").desc("print help").build()).addOption(Option.builder((String)"tu").longOpt("test_unlimited").desc("Test's the policy for unlimited key encryption").hasArg(false).argName("tu").build()).addOption(Option.builder((String)"lc").longOpt("list_ciphers").desc("List the ciphers allowed by the policy").hasArg(false).argName("lc").build());
    }

    private static void testUnlimitedKeyJCEPolicy() {
        System.out.print("Unlimited Key JCE Policy: ");
        try {
            boolean unlimited = Cipher.getMaxAllowedKeyLength("RC5") >= 256;
            System.out.println(unlimited);
            System.exit(unlimited ? 0 : 1);
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("unknown [error]");
            System.exit(-1);
        }
    }

    private static void listCiphers() {
        System.out.println("Available ciphers:");
        for (Provider provider : Security.getProviders()) {
            String providerName = provider.getName();
            for (Provider.Service service : provider.getServices()) {
                String algorithmName = service.getAlgorithm();
                if (!"Cipher".equalsIgnoreCase(service.getType())) continue;
                try {
                    long keylength = Cipher.getMaxAllowedKeyLength(algorithmName);
                    System.out.print('\t');
                    System.out.print(providerName.toLowerCase());
                    System.out.print('.');
                    System.out.print(algorithmName.toLowerCase());
                    System.out.print(": ");
                    System.out.println(keylength);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            }
        }
    }
}

