/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.view.utils.hdfs;

import id.onyx.obdp.view.ViewContext;
import id.onyx.obdp.view.utils.hdfs.AuthConfigurationBuilder;
import id.onyx.obdp.view.utils.hdfs.ConfigurationBuilder;
import id.onyx.obdp.view.utils.hdfs.HdfsApi;
import id.onyx.obdp.view.utils.hdfs.HdfsApiException;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putStringToFile(final HdfsApi hdfs, final String filePath, final String content) throws HdfsApiException {
        try {
            HdfsApi hdfsApi = hdfs;
            synchronized (hdfsApi) {
                hdfs.execute(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        FSDataOutputStream stream = hdfs.create(filePath, true);
                        stream.write(content.getBytes());
                        stream.close();
                        return null;
                    }
                }, true);
            }
        }
        catch (IOException e) {
            throw new HdfsApiException("HDFS020 Could not write file " + filePath, e);
        }
        catch (InterruptedException e) {
            throw new HdfsApiException("HDFS021 Could not write file " + filePath, e);
        }
    }

    public static String readFile(HdfsApi hdfs, String filePath) throws HdfsApiException {
        try {
            FSDataInputStream stream = hdfs.open(filePath);
            return IOUtils.toString((InputStream)stream);
        }
        catch (IOException e) {
            throw new HdfsApiException("HDFS060 Could not read file " + filePath, e);
        }
        catch (InterruptedException e) {
            throw new HdfsApiException("HDFS061 Could not read file " + filePath, e);
        }
    }

    public static String findUnallocatedFileName(HdfsApi hdfs, String fullPathAndFilename, String extension) throws HdfsApiException {
        String newFilePath;
        int triesCount = 0;
        try {
            boolean isUnallocatedFilenameFound;
            do {
                newFilePath = String.format(fullPathAndFilename + "%s" + extension, triesCount == 0 ? "" : "_" + triesCount);
                LOG.debug("Trying to find free filename " + newFilePath);
                boolean bl = isUnallocatedFilenameFound = !hdfs.exists(newFilePath);
                if (isUnallocatedFilenameFound) {
                    LOG.debug("File created successfully!");
                }
                if (++triesCount <= 1000) continue;
                throw new HdfsApiException("HDFS100 Can't find unallocated file name " + fullPathAndFilename + "...");
            } while (!isUnallocatedFilenameFound);
        }
        catch (IOException e) {
            throw new HdfsApiException("HDFS030 Error in creation " + fullPathAndFilename + "...", e);
        }
        catch (InterruptedException e) {
            throw new HdfsApiException("HDFS031 Error in creation " + fullPathAndFilename + "...", e);
        }
        return newFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized HdfsApi connectToHDFSApi(ViewContext context, Map<String, String> customViewProperties) throws HdfsApiException {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(HdfsUtil.class.getClassLoader());
        try {
            ConfigurationBuilder configurationBuilder = new ConfigurationBuilder(context, customViewProperties);
            HdfsApi hdfsApi = HdfsUtil.getHdfsApi(context, configurationBuilder);
            return hdfsApi;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized HdfsApi connectToHDFSApi(ViewContext context) throws HdfsApiException {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(HdfsUtil.class.getClassLoader());
        try {
            ConfigurationBuilder configurationBuilder = new ConfigurationBuilder(context);
            HdfsApi hdfsApi = HdfsUtil.getHdfsApi(context, configurationBuilder);
            return hdfsApi;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private static HdfsApi getHdfsApi(ViewContext context, ConfigurationBuilder configurationBuilder) throws HdfsApiException {
        HdfsApi api = null;
        AuthConfigurationBuilder authConfigurationBuilder = new AuthConfigurationBuilder(context);
        Map<String, String> authParams = authConfigurationBuilder.build();
        configurationBuilder.setAuthParams(authParams);
        try {
            api = new HdfsApi(configurationBuilder, HdfsUtil.getHdfsUsername(context));
            LOG.info("HdfsApi connected OK");
        }
        catch (IOException e) {
            LOG.error("exception occurred while creating hdfsApi objcet : {}", (Object)e.getMessage(), (Object)e);
            String message = "HDFS040 Couldn't open connection to HDFS";
            LOG.error(message);
            throw new HdfsApiException(message, e);
        }
        catch (InterruptedException e) {
            LOG.error("exception occurred while creating hdfsApi objcet : {}", (Object)e.getMessage(), (Object)e);
            String message = "HDFS041 Couldn't open connection to HDFS";
            LOG.error(message);
            throw new HdfsApiException(message, e);
        }
        return api;
    }

    public static String getHdfsUsername(ViewContext context) {
        String userName = (String)context.getProperties().get("webhdfs.username");
        if (userName == null || userName.compareTo("null") == 0 || userName.compareTo("") == 0) {
            userName = context.getUsername();
        }
        return userName;
    }
}

