/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.view.utils.hdfs;

import com.google.common.base.Strings;
import id.onyx.obdp.view.ViewContext;
import id.onyx.obdp.view.utils.ambari.NoClusterAssociatedException;
import id.onyx.obdp.view.utils.hdfs.HdfsApiException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthConfigurationBuilder {
    protected static final Logger LOG = LoggerFactory.getLogger(AuthConfigurationBuilder.class);
    private Map<String, String> params = new HashMap<String, String>();
    private ViewContext context;

    public AuthConfigurationBuilder(ViewContext context) {
        this.context = context;
    }

    private void parseProperties() throws HdfsApiException {
        String auth = (String)this.context.getProperties().get("webhdfs.auth");
        if (Strings.isNullOrEmpty((String)auth)) {
            if (this.context.getCluster() != null) {
                auth = this.getConfigurationFromAmbari();
            } else {
                auth = "auth=SIMPLE";
                LOG.warn(String.format("HDFS090 Authentication parameters could not be determined. %s assumed.", auth));
            }
        }
        LOG.debug("Hdfs auth params : {}", (Object)auth);
        this.parseAuthString(auth);
    }

    private void parseAuthString(String auth) {
        for (String param : auth.split(";")) {
            String[] keyvalue = param.split("=");
            if (keyvalue.length != 2) {
                LOG.error("HDFS050 Can not parse authentication param " + param + " in " + auth);
                continue;
            }
            this.params.put(keyvalue[0], keyvalue[1]);
        }
    }

    private String getConfigurationFromAmbari() throws NoClusterAssociatedException {
        String authMethod = this.context.getCluster().getConfigurationValue("core-site", "hadoop.security.authentication");
        Object authString = String.format("auth=%s", authMethod);
        String proxyUser = this.context.getCluster().getConfigurationValue("cluster-env", "ambari_principal_name");
        if (proxyUser != null && !authMethod.equalsIgnoreCase("SIMPLE")) {
            authString = (String)authString + String.format(";proxyuser=%s", proxyUser.split("@")[0]);
        }
        return authString;
    }

    public Map<String, String> build() throws HdfsApiException {
        this.parseProperties();
        return this.params;
    }
}

