/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.view.utils.ambari;

import id.onyx.obdp.view.ViewContext;
import id.onyx.obdp.view.utils.ambari.AmbariApi;
import id.onyx.obdp.view.utils.ambari.AmbariApiException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Services {
    public static final String HTTPS_ONLY = "HTTPS_ONLY";
    public static final String HTTP_ONLY = "HTTP_ONLY";
    public static final String YARN_SITE = "yarn-site";
    public static final String YARN_HTTP_POLICY = "yarn.http.policy";
    public static final String YARN_RESOURCEMANAGER_HA_ENABLED = "yarn.resourcemanager.ha.enabled";
    private static final String YARN_RESOURCEMANAGER_HTTPS_KEY = "yarn.resourcemanager.webapp.https.address";
    private static final String YARN_RESOURCEMANAGER_HTTP_KEY = "yarn.resourcemanager.webapp.address";
    private static final String YARN_RESOURCEMANAGER_HA_RM_IDS_KEY = "yarn.resourcemanager.ha.rm-ids";
    private static final String YARN_RESOURCEMANAGER_HTTP_HA_PARTIAL_KEY = "yarn.resourcemanager.webapp.address.";
    private static final String YARN_RESOURCEMANAGER_HTTPS_HA_PARTIAL_KEY = "yarn.resourcemanager.webapp.https.address.";
    private static final String YARN_RESOURCEMANAGER_HOSTNAME_KEY = "yarn.resourcemanager.hostname";
    private static final String YARN_RESOURCEMANAGER_HOSTNAME_PARTIAL_KEY = "yarn.resourcemanager.hostname.";
    private static final String YARN_RESOURCEMANAGER_DEFAULT_HTTP_PORT = "8088";
    private static final String YARN_RESOURCEMANAGER_DEFAULT_HTTPS_PORT = "8090";
    private static final String YARN_ATS_URL = "yarn.ats.url";
    private static final String YARN_TIMELINE_WEBAPP_HTTP_ADDRESS_KEY = "yarn.timeline-service.webapp.address";
    private static final String YARN_TIMELINE_WEBAPP_HTTPS_ADDRESS_KEY = "yarn.timeline-service.webapp.https.address";
    public static final String RM_INFO_API_ENDPOINT = "/ws/v1/cluster/info";
    public static final String TIMELINE_AUTH_TYPE_PROP_KEY = "timeline.http.auth.type";
    public static final String HADOOP_HTTP_AUTH_TYPE_KEY = "hadoop.http.auth.type";
    private final AmbariApi ambariApi;
    private ViewContext context;
    protected static final Logger LOG = LoggerFactory.getLogger(Services.class);

    public Services(AmbariApi ambariApi, ViewContext context) {
        this.ambariApi = ambariApi;
        this.context = context;
    }

    public String getRMUrl() {
        String url = this.context.getCluster() != null ? this.getRMUrlFromClusterConfig() : this.getRmUrlFromCustomConfig();
        return this.removeTrailingSlash(url);
    }

    private String getRMUrlFromClusterConfig() {
        Object url;
        String haEnabled = this.getYarnConfig(YARN_RESOURCEMANAGER_HA_ENABLED);
        String httpPolicy = this.getYarnConfig(YARN_HTTP_POLICY);
        if (!HTTP_ONLY.equals(httpPolicy) && !HTTPS_ONLY.equals(httpPolicy)) {
            LOG.error(String.format("RA030 Unknown value %s of yarn-site/yarn.http.policy. HTTP_ONLY assumed.", httpPolicy));
            httpPolicy = HTTP_ONLY;
        }
        if (haEnabled != null && haEnabled.equals("true")) {
            String[] urls = this.getRMHAUrls(httpPolicy);
            url = this.getActiveRMUrl(urls);
        } else {
            Object object = url = httpPolicy.equals(HTTPS_ONLY) ? this.getYarnConfig(YARN_RESOURCEMANAGER_HTTPS_KEY) : this.getYarnConfig(YARN_RESOURCEMANAGER_HTTP_KEY);
            if (url == null || ((String)url).isEmpty()) {
                url = this.getYarnConfig(YARN_RESOURCEMANAGER_HOSTNAME_KEY).trim() + ":" + this.getDefaultRMPort(httpPolicy);
            }
            url = Services.addProtocolIfMissing((String)url, this.getProtocol(httpPolicy));
        }
        return url;
    }

    private String[] getRMHAUrls(String httpPolicy) {
        String haRmIds = this.getYarnConfig(YARN_RESOURCEMANAGER_HA_RM_IDS_KEY);
        String[] ids = haRmIds.split(",");
        int index = 0;
        String[] urls = new String[ids.length];
        for (String id : ids) {
            Object url;
            Object object = url = HTTPS_ONLY.equals(httpPolicy) ? this.getYarnConfig(YARN_RESOURCEMANAGER_HTTPS_HA_PARTIAL_KEY + id) : this.getYarnConfig(YARN_RESOURCEMANAGER_HTTP_HA_PARTIAL_KEY + id);
            if (url == null || ((String)url).isEmpty()) {
                url = this.getYarnConfig(YARN_RESOURCEMANAGER_HOSTNAME_PARTIAL_KEY + id).trim() + ":" + this.getDefaultRMPort(httpPolicy);
            }
            urls[index++] = Services.addProtocolIfMissing(((String)url).trim(), this.getProtocol(httpPolicy));
        }
        return urls;
    }

    private String getRmUrlFromCustomConfig() {
        String resourceManagerUrls = (String)this.context.getProperties().get("yarn.resourcemanager.url");
        if (!StringUtils.isEmpty((String)resourceManagerUrls)) {
            String[] urls = resourceManagerUrls.split(",");
            if (!Services.hasProtocol(urls)) {
                throw new AmbariApiException("RA070 View is not cluster associated. All Resource Manager URL should contain protocol.");
            }
            return this.getActiveRMUrl(urls);
        }
        throw new AmbariApiException("RA070 View is not cluster associated. 'YARN ResourceManager URL' should be provided");
    }

    private String removeTrailingSlash(String url) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    private String getActiveRMUrl(String[] urls) {
        if (urls.length == 1) {
            return urls[0].trim();
        }
        for (String url : urls) {
            if (!this.isActiveUrl(url = url.trim())) continue;
            return url;
        }
        LOG.error("All ResourceManagers are not accessible or none seem to be active.");
        throw new AmbariApiException("RA110 All ResourceManagers are not accessible or none seem to be active.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isActiveUrl(String url) {
        InputStream inputStream = null;
        try {
            inputStream = this.context.getURLStreamProvider().readFrom(url + RM_INFO_API_ENDPOINT, "GET", (String)null, new HashMap());
            String response = IOUtils.toString((InputStream)inputStream);
            String haState = this.getHAStateFromRMResponse(response);
            if (StringUtils.isNotEmpty((String)haState) && "ACTIVE".equals(haState)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            LOG.error("Resource Manager : %s is not accessible. This cannot be a active RM. Returning false.");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private String getHAStateFromRMResponse(String response) {
        JSONObject jsonObject = (JSONObject)JSONValue.parse((String)response);
        JSONObject clusterInfo = (JSONObject)jsonObject.get((Object)"clusterInfo");
        return (String)clusterInfo.get((Object)"haState");
    }

    public String getWebHCatURL() {
        String host = null;
        if (this.context.getCluster() != null) {
            List hiveServerHosts = this.context.getCluster().getHostsForServiceComponent("HIVE", "WEBHCAT_SERVER");
            if (!hiveServerHosts.isEmpty()) {
                host = (String)hiveServerHosts.get(0);
                LOG.info("WEBHCAT_SERVER component was found on host " + host);
            } else {
                LOG.warn("No host was found with WEBHCAT_SERVER component. Using hive.host property to get hostname.");
            }
        }
        if (host == null && ((host = (String)this.context.getProperties().get("webhcat.hostname")) == null || host.isEmpty())) {
            throw new AmbariApiException("RA080 Can't determine WebHCat hostname neither by associated cluster nor by webhcat.hostname property.");
        }
        String port = (String)this.context.getProperties().get("webhcat.port");
        if (port == null || port.isEmpty()) {
            throw new AmbariApiException("RA090 Can't determine WebHCat port neither by associated cluster nor by webhcat.port property.");
        }
        return String.format("http://%s:%s/templeton/v1", host, port);
    }

    public String getTimelineServerUrl() {
        String url = this.context.getCluster() != null ? this.getATSUrlFromCluster() : this.getATSUrlFromCustom();
        return this.removeTrailingSlash(url);
    }

    private String getATSUrlFromCustom() {
        String atsUrl = (String)this.context.getProperties().get(YARN_ATS_URL);
        if (!StringUtils.isEmpty((String)atsUrl)) {
            if (!Services.hasProtocol(atsUrl)) {
                throw new AmbariApiException("RA070 View is not cluster associated. Timeline Server URL should contain protocol.");
            }
            return atsUrl;
        }
        throw new AmbariApiException("RA070 View is not cluster associated. 'YARN Timeline Server URL' should be provided");
    }

    public String getYARNProtocol() {
        String httpPolicy = this.getYarnConfig(YARN_HTTP_POLICY);
        if (!HTTP_ONLY.equals(httpPolicy) && !HTTPS_ONLY.equals(httpPolicy)) {
            LOG.error(String.format("RA030 Unknown value %s of yarn-site/yarn.http.policy. HTTP_ONLY assumed.", httpPolicy));
            httpPolicy = HTTP_ONLY;
        }
        return this.getProtocol(httpPolicy);
    }

    private String getATSUrlFromCluster() {
        String httpPolicy = this.getYarnConfig(YARN_HTTP_POLICY);
        if (!HTTP_ONLY.equals(httpPolicy) && !HTTPS_ONLY.equals(httpPolicy)) {
            LOG.error(String.format("RA030 Unknown value %s of yarn-site/yarn.http.policy. HTTP_ONLY assumed.", httpPolicy));
            httpPolicy = HTTP_ONLY;
        }
        String url = httpPolicy.equals(HTTPS_ONLY) ? this.getYarnConfig(YARN_TIMELINE_WEBAPP_HTTPS_ADDRESS_KEY) : this.getYarnConfig(YARN_TIMELINE_WEBAPP_HTTP_ADDRESS_KEY);
        url = Services.addProtocolIfMissing(url, this.getProtocol(httpPolicy));
        return url;
    }

    public static String addProtocolIfMissing(String url, String protocol) throws AmbariApiException {
        if (!Services.hasProtocol((String)url)) {
            url = protocol + "://" + (String)url;
        }
        return url;
    }

    public static boolean hasProtocol(String[] urls) {
        for (String url : urls) {
            if (Services.hasProtocol(url)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasProtocol(String url) {
        return url.matches("^[^:]+://.*$");
    }

    private String getProtocol(String yarnHttpPolicyConfig) {
        return HTTPS_ONLY.equals(yarnHttpPolicyConfig) ? "https" : "http";
    }

    private String getYarnConfig(String key) {
        return this.context.getCluster().getConfigurationValue(YARN_SITE, key);
    }

    private String getDefaultRMPort(String yarnHttpPolicy) {
        return HTTPS_ONLY.equals(yarnHttpPolicy) ? YARN_RESOURCEMANAGER_DEFAULT_HTTPS_PORT : YARN_RESOURCEMANAGER_DEFAULT_HTTP_PORT;
    }

    public String getHadoopHttpWebAuthType() {
        return (String)this.context.getProperties().get(HADOOP_HTTP_AUTH_TYPE_KEY);
    }

    public String getTimelineServerAuthType() {
        return (String)this.context.getProperties().get(TIMELINE_AUTH_TYPE_PROP_KEY);
    }
}

