/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.view.utils.ambari;

import id.onyx.obdp.view.AmbariHttpException;
import id.onyx.obdp.view.ViewContext;
import id.onyx.obdp.view.utils.ambari.AmbariApiException;
import id.onyx.obdp.view.utils.ambari.NoClusterAssociatedException;
import id.onyx.obdp.view.utils.ambari.Services;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class AmbariApi {
    private ViewContext context;
    private Services services;
    private String requestedBy = "views";
    public static String API_PREFIX = "/api/v1/clusters/";

    public AmbariApi(ViewContext context) {
        this.context = context;
    }

    public void setRequestedBy(String requestedBy) {
        this.requestedBy = requestedBy;
    }

    public String requestClusterAPI(String path) throws AmbariApiException, AmbariHttpException {
        return this.requestClusterAPI(path, "GET", null, null);
    }

    public String requestClusterAPI(String path, String method, String data, Map<String, String> headers) throws AmbariApiException, AmbariHttpException {
        String response;
        try {
            if (this.context.getAmbariClusterStreamProvider() == null || this.context.getCluster() == null) {
                throw new NoClusterAssociatedException("RA030 View is not associated with any cluster. No way to request Ambari.");
            }
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            path = API_PREFIX + this.context.getCluster().getName() + (String)path;
            InputStream inputStream = this.context.getAmbariClusterStreamProvider().readFrom((String)path, method, data, this.addRequestedByHeader(headers));
            response = IOUtils.toString((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new AmbariApiException("RA040 I/O error while requesting Ambari", e);
        }
        return response;
    }

    public String readFromAmbari(String path, String method, String data, Map<String, String> headers) throws AmbariApiException, AmbariHttpException {
        String response;
        try {
            if (this.context.getAmbariClusterStreamProvider() == null) {
                throw new NoClusterAssociatedException("RA060 View is not associated with any cluster. No way to request Ambari.");
            }
            InputStream inputStream = this.context.getAmbariClusterStreamProvider().readFrom(path, method, data, this.addRequestedByHeader(headers));
            response = IOUtils.toString((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new AmbariApiException("RA050 I/O error while requesting Ambari", e);
        }
        return response;
    }

    public Services getServices() {
        if (this.services == null) {
            this.services = new Services(this, this.context);
        }
        return this.services;
    }

    private Map<String, String> addRequestedByHeader(Map<String, String> headers) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("X-Requested-By", this.requestedBy);
        return headers;
    }

    public boolean isClusterAssociated() {
        return this.context.getCluster() != null;
    }
}

