/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.view.commons.hdfs;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import id.onyx.obdp.view.ViewContext;
import id.onyx.obdp.view.utils.hdfs.ConfigurationBuilder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewPropertyHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationBuilder.class);

    public static Optional<Map<String, String>> getViewConfigs(ViewContext context, String viewConfigPropertyName) {
        HashMap<String, String> viewConfigs = new HashMap<String, String>();
        String keyValues = (String)context.getProperties().get(viewConfigPropertyName);
        LOG.debug("{} : {}", (Object)viewConfigPropertyName, (Object)keyValues);
        if (Strings.isNullOrEmpty((String)keyValues)) {
            LOG.info("No values found in {} property.", (Object)viewConfigPropertyName);
            return Optional.absent();
        }
        for (String entry : keyValues.split(";")) {
            String[] kv = entry.split("=");
            if (kv.length != 2) {
                LOG.error("Ignoring entry {}, because it is not formatted like key=value");
                continue;
            }
            viewConfigs.put(kv[0], kv[1]);
        }
        return Optional.of(viewConfigs);
    }
}

