/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.view.commons.hdfs;

import id.onyx.obdp.view.ViewContext;
import id.onyx.obdp.view.commons.exceptions.ServiceFormattedException;
import id.onyx.obdp.view.commons.hdfs.HdfsService;
import id.onyx.obdp.view.utils.hdfs.HdfsApi;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

public class UploadService
extends HdfsService {
    public UploadService(ViewContext context) {
        super(context);
    }

    public UploadService(ViewContext context, Map<String, String> customProperties) {
        super(context, customProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFile(String filePath, InputStream uploadedInputStream) throws IOException, InterruptedException {
        byte[] chunk = new byte[1024];
        try (FSDataOutputStream out = null;){
            int read;
            out = this.getApi().create(filePath, false);
            while ((read = uploadedInputStream.read(chunk)) != -1) {
                out.write(chunk, 0, read);
            }
        }
    }

    @PUT
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response uploadFile(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition contentDisposition, @FormDataParam(value="path") String path) {
        try {
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            String filePath = (String)path + new String(contentDisposition.getFileName().getBytes("ISO8859-1"), "UTF-8");
            this.uploadFile(filePath, uploadedInputStream);
            return Response.ok((Object)this.getApi().fileStatusToJSON(this.getApi().getFileStatus(filePath))).build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceFormattedException(ex.getMessage(), ex);
        }
    }

    @PUT
    @Path(value="/zip")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response uploadZip(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition contentDisposition, @FormDataParam(value="path") String path) {
        try {
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            ZipInputStream zip = new ZipInputStream(uploadedInputStream);
            ZipEntry ze = zip.getNextEntry();
            HdfsApi api = this.getApi();
            while (ze != null) {
                String filePath = (String)path + ze.getName();
                if (ze.isDirectory()) {
                    api.mkdir(filePath);
                } else {
                    this.uploadFile(filePath, zip);
                }
                ze = zip.getNextEntry();
            }
            return Response.ok((Object)this.getApi().fileStatusToJSON(api.listdir((String)path))).build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceFormattedException(ex.getMessage(), ex);
        }
    }
}

