/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import dev.equo.solstice.p2.CacheLocations;
import dev.equo.solstice.p2.FileMisc;
import dev.equo.solstice.p2.OfflineCache;
import dev.equo.solstice.p2.P2Client;
import dev.equo.solstice.p2.P2ClientCache;
import dev.equo.solstice.p2.P2Unit;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;

class JarCache {
    final File bundlePool = CacheLocations.p2bundlePool();
    final OkHttpClient client = new OkHttpClient.Builder().build();
    final P2ClientCache cachingPolicy;

    JarCache(P2ClientCache cachingPolicy) {
        this.cachingPolicy = cachingPolicy;
        FileMisc.mkdirs(this.bundlePool);
    }

    public File download(P2Unit unit) throws IOException {
        File repoDir = new File(this.bundlePool, OfflineCache.filenameSafe(unit.getRepoUrl()));
        File jar = new File(repoDir, unit.id + "_" + unit.version + ".jar");
        if (jar.isFile()) {
            return jar;
        }
        if (this.cachingPolicy.networkAllowed()) {
            File tempFile;
            block16: {
                if (!repoDir.isDirectory()) {
                    FileMisc.mkdirs(repoDir);
                    FileMisc.writeToken(repoDir, ".url", unit.getRepoUrl());
                }
                Request request = P2Client.buildRequest(unit.getJarUrl());
                tempFile = File.createTempFile(unit.id, ".jar");
                try (Response response = this.client.newCall(request).execute();){
                    if (response.code() == 200) {
                        try (BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)tempFile));){
                            sink.writeAll((Source)response.body().source());
                            break block16;
                        }
                    }
                    throw new IllegalArgumentException(response.code() + " at " + unit.getJarUrl());
                }
            }
            Files.move(tempFile.toPath(), jar.toPath(), new CopyOption[0]);
            return jar;
        }
        throw new IllegalStateException("No cached version of " + unit.getJarUrl() + " available, you must turn off offline mode.");
    }
}

