/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.analyze.PackagePattern;
import de.skuzzle.enforcer.restrictimports.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BannedImportGroupDefinition {
    private static final String DEFAULT_BASE_PACKAGE = new String("**");
    private String basePackage = DEFAULT_BASE_PACKAGE;
    private List<String> basePackages = new ArrayList<String>();
    private String bannedImport = null;
    private List<String> bannedImports = new ArrayList<String>();
    private String allowedImport = null;
    private List<String> allowedImports = new ArrayList<String>();
    private String exclusion = null;
    private List<String> exclusions = new ArrayList<String>();
    private String reason;

    public BannedImportGroup createGroupFromPluginConfiguration() {
        return BannedImportGroup.builder().withBasePackages(this.assembleList(this.basePackage, this.basePackages)).withBannedImports(this.assembleList(this.bannedImport, this.bannedImports)).withAllowedImports(this.assembleList(this.allowedImport, this.allowedImports)).withExclusions(this.assembleList(this.exclusion, this.exclusions)).withReason(this.reason).build();
    }

    public boolean hasInput() {
        return this.basePackage != DEFAULT_BASE_PACKAGE || !this.basePackages.isEmpty() || this.bannedImport != null || !this.bannedImports.isEmpty() || this.allowedImport != null || !this.allowedImports.isEmpty() || this.exclusion != null || !this.exclusions.isEmpty();
    }

    private List<PackagePattern> assembleList(String single, List<String> multi) {
        if (single == null) {
            return PackagePattern.parseAll(multi);
        }
        return Collections.singletonList(PackagePattern.parse(single));
    }

    public void setBasePackage(String basePackage) {
        Preconditions.checkArgument(this.basePackages.isEmpty(), "Configuration error: you should either specify a single base package using <basePackage> or multiple base packages using <basePackages> but not both", new Object[0]);
        this.basePackage = basePackage;
    }

    public void setBasePackages(List<String> basePackages) {
        Preconditions.checkArgument(this.basePackage == DEFAULT_BASE_PACKAGE, "Configuration error: you should either specify a single base package using <basePackage> or multiple base packages using <basePackages> but not both", new Object[0]);
        Preconditions.checkArgument(basePackages != null && !basePackages.isEmpty(), "bannedPackages must not be empty", new Object[0]);
        this.basePackage = null;
        this.basePackages = basePackages;
    }

    public void setBannedImport(String bannedImport) {
        Preconditions.checkArgument(this.bannedImports.isEmpty(), "Configuration error: you should either specify a single banned import using <bannedImport> or multiple banned imports using <bannedImports> but not both", new Object[0]);
        Preconditions.checkArgument(this.bannedImport == null, "If you want to specify multiple banned imports you have to wrap them in a <bannedImports> tag", new Object[0]);
        this.bannedImport = bannedImport;
    }

    public void setBannedImports(List<String> bannedPackages) {
        Preconditions.checkArgument(this.bannedImport == null, "Configuration error: you should either specify a single banned import using <bannedImport> or multiple banned imports using <bannedImports> but not both", new Object[0]);
        Preconditions.checkArgument(bannedPackages != null && !bannedPackages.isEmpty(), "bannedPackages must not be empty", new Object[0]);
        this.bannedImport = null;
        this.bannedImports = bannedPackages;
    }

    public void setAllowedImport(String allowedImport) {
        Preconditions.checkArgument(this.allowedImports.isEmpty(), "Configuration error: you should either specify a single allowed import using <allowedImport> or multiple allowed imports using <allowedImports> but not both", new Object[0]);
        Preconditions.checkArgument(this.allowedImport == null, "If you want to specify multiple allowed imports you have to wrap them in a <allowedImports> tag", new Object[0]);
        this.allowedImport = allowedImport;
    }

    public void setAllowedImports(List<String> allowedImports) {
        Preconditions.checkArgument(this.allowedImport == null, "Configuration error: you should either specify a single allowed import using <allowedImport> or multiple allowed imports using <allowedImports> but not both", new Object[0]);
        this.allowedImports = allowedImports;
    }

    public void setExclusion(String exclusion) {
        Preconditions.checkArgument(this.exclusions.isEmpty(), "Configuration error: you should either specify a single exclusion using <exclusion> or multiple exclusions using <exclusions> but not both", new Object[0]);
        Preconditions.checkArgument(this.exclusion == null, "If you want to specify multiple exclusions you have to wrap them in a <exclusions> tag", new Object[0]);
        this.exclusion = exclusion;
    }

    public void setExclusions(List<String> exclusions) {
        Preconditions.checkArgument(this.exclusion == null, "Configuration error: you should either specify a single exclusion using <exclusion> or multiple exclusions using <exclusions> but not both", new Object[0]);
        this.exclusions = exclusions;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
}

