/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.parser.lang;

import de.skuzzle.enforcer.restrictimports.parser.lang.LanguageSupport;
import de.skuzzle.enforcer.restrictimports.util.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SupportedLanguageHolder {
    private static final Logger logger = LoggerFactory.getLogger(SupportedLanguageHolder.class);
    static final Map<String, LanguageSupport> supportedLanguages = SupportedLanguageHolder.lookupImplementations();

    SupportedLanguageHolder() {
    }

    static Optional<LanguageSupport> getLanguageSupport(String extension) {
        String normalizedExtension = SupportedLanguageHolder.determineNormalizedExtension(extension);
        return Optional.ofNullable(supportedLanguages.get(normalizedExtension));
    }

    static boolean isLanguageSupported(String extension) {
        String normalizedExtension = SupportedLanguageHolder.determineNormalizedExtension(extension);
        return supportedLanguages.containsKey(normalizedExtension);
    }

    private static Map<String, LanguageSupport> lookupImplementations() {
        ServiceLoader<LanguageSupport> serviceProvider = ServiceLoader.load(LanguageSupport.class);
        HashMap<String, LanguageSupport> implementations = new HashMap<String, LanguageSupport>();
        serviceProvider.forEach(parser -> parser.getSupportedFileExtensions().stream().map(SupportedLanguageHolder::determineNormalizedExtension).forEach(normalizedExtension -> {
            if (implementations.put((String)normalizedExtension, (LanguageSupport)parser) != null) {
                throw new IllegalStateException("There are multiple parsers to handle file extension: " + normalizedExtension);
            }
            logger.debug("Registered {} for extension '{}'", parser, normalizedExtension);
        }));
        Preconditions.checkState(!implementations.isEmpty(), "No LanguageSupport instances found!", new Object[0]);
        return implementations;
    }

    private static String determineNormalizedExtension(String extension) {
        return extension.startsWith(".") ? extension.toLowerCase() : "." + extension.toLowerCase();
    }
}

