/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.parser.lang;

import de.skuzzle.enforcer.restrictimports.parser.ImportStatement;
import de.skuzzle.enforcer.restrictimports.parser.lang.FileExtension;
import de.skuzzle.enforcer.restrictimports.parser.lang.SupportedLanguageHolder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public interface LanguageSupport {
    public static LanguageSupport getLanguageSupport(Path path) {
        String extension = FileExtension.fromPath(path);
        return SupportedLanguageHolder.getLanguageSupport(extension).orElseThrow(() -> new IllegalArgumentException(String.format("Could not find a LanguageSupport implementation for normalized file extension: '%s' (%s)", extension, path)));
    }

    public static boolean isLanguageSupported(Path path) {
        Path filename = path.getFileName();
        return !Files.isDirectory(path, new LinkOption[0]) && SupportedLanguageHolder.isLanguageSupported(FileExtension.fromPath(filename));
    }

    public Set<String> getSupportedFileExtensions();

    public Optional<String> parsePackage(String var1);

    public List<ImportStatement> parseImport(String var1, int var2);
}

