/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.parser.lang;

import de.skuzzle.enforcer.restrictimports.parser.ImportStatement;
import de.skuzzle.enforcer.restrictimports.parser.lang.LanguageSupport;
import de.skuzzle.enforcer.restrictimports.util.Whitespaces;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class JavaLanguageSupport
implements LanguageSupport {
    private static final String STATIC_PREFIX = "static";
    private static final String IMPORT_STATEMENT = "import ";
    private static final String PACKAGE_STATEMENT = "package ";

    @Override
    public Set<String> getSupportedFileExtensions() {
        return Collections.singleton("java");
    }

    @Override
    public Optional<String> parsePackage(String line) {
        if (!this.isPackage(line)) {
            return Optional.empty();
        }
        return Optional.of(JavaLanguageSupport.extractPackageName(line));
    }

    @Override
    public List<ImportStatement> parseImport(String line, int lineNumber) {
        if (!this.isImport(line)) {
            return Collections.emptyList();
        }
        String[] parts = line.split(";");
        return Arrays.stream(parts).map(String::trim).filter(s -> !s.isEmpty()).map(s -> s.substring(IMPORT_STATEMENT.length())).map(String::trim).map(importName -> this.toImportStatement((String)importName, lineNumber)).collect(Collectors.toList());
    }

    private ImportStatement toImportStatement(String importName, int lineNumber) {
        if (importName.startsWith(STATIC_PREFIX)) {
            String realImportName = Whitespaces.trimAll(importName.substring(STATIC_PREFIX.length()));
            return new ImportStatement(realImportName, lineNumber, true);
        }
        return new ImportStatement(importName, lineNumber, false);
    }

    private boolean is(String compare, String line) {
        return line.startsWith(compare) && line.endsWith(";");
    }

    private boolean isPackage(String line) {
        return this.is(PACKAGE_STATEMENT, line);
    }

    private boolean isImport(String line) {
        return this.is(IMPORT_STATEMENT, line);
    }

    private static String extractPackageName(String line) {
        int spaceIdx = line.indexOf(" ");
        int semiIdx = line.indexOf(";");
        String sub = line.substring(spaceIdx, semiIdx);
        return sub.trim();
    }
}

