/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.parser;

import de.skuzzle.enforcer.restrictimports.parser.ImportStatement;
import de.skuzzle.enforcer.restrictimports.util.StringRepresentation;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;

public final class ParsedFile {
    private final Path path;
    private final String declaredPackage;
    private final String fqcn;
    private final Collection<ImportStatement> imports;

    public ParsedFile(Path path, String declaredPackage, String fqcn, Collection<ImportStatement> imports) {
        this.path = path;
        this.declaredPackage = declaredPackage;
        this.fqcn = fqcn;
        this.imports = imports;
    }

    public Path getPath() {
        return this.path;
    }

    public Collection<ImportStatement> getImports() {
        return this.imports;
    }

    public String getFqcn() {
        return this.fqcn;
    }

    public String toString() {
        return StringRepresentation.ofInstance(this).add("path", this.path).add("declaredPackage", this.declaredPackage).add("fqcn", this.fqcn).add("imports", this.imports).toString();
    }

    public int hashCode() {
        return Objects.hash(this.path, this.declaredPackage, this.fqcn, this.imports);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ParsedFile && Objects.equals(this.path, ((ParsedFile)obj).path) && Objects.equals(this.declaredPackage, ((ParsedFile)obj).declaredPackage) && Objects.equals(this.fqcn, ((ParsedFile)obj).fqcn) && Objects.equals(this.imports, ((ParsedFile)obj).imports);
    }
}

